package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Registration}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableRegistration.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "Registration"})
public final class ImmutableRegistration extends Registration {
  private final String name;
  private final String id;
  private final Optional<String> address;
  private final Optional<Integer> port;
  private final Optional<Registration.RegCheck> check;
  private final ImmutableList<Registration.RegCheck> checks;
  private final ImmutableList<String> tags;

  private ImmutableRegistration(
      String name,
      String id,
      Optional<String> address,
      Optional<Integer> port,
      Optional<Registration.RegCheck> check,
      ImmutableList<Registration.RegCheck> checks,
      ImmutableList<String> tags) {
    this.name = name;
    this.id = id;
    this.address = address;
    this.port = port;
    this.check = check;
    this.checks = checks;
    this.tags = tags;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public String getName() {
    return name;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code id} attribute
   */
  @JsonProperty("Id")
  @Override
  public String getId() {
    return id;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code address} attribute
   */
  @JsonProperty("Address")
  @Override
  public Optional<String> getAddress() {
    return address;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code port} attribute
   */
  @JsonProperty("Port")
  @Override
  public Optional<Integer> getPort() {
    return port;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code check} attribute
   */
  @JsonProperty("Check")
  @Override
  public Optional<Registration.RegCheck> getCheck() {
    return check;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code checks} attribute
   */
  @JsonProperty("Checks")
  @Override
  public ImmutableList<Registration.RegCheck> getChecks() {
    return checks;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code tags} attribute
   */
  @JsonProperty("Tags")
  @Override
  public ImmutableList<String> getTags() {
    return tags;
  }
  
  /**
   * Copy current immutable object by setting value for {@link Registration#getName() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final ImmutableRegistration withName(String value) {
    if (this.name == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableRegistration(newValue, this.id, this.address, this.port, this.check, this.checks, this.tags);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Registration#getId() id}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for id
   * @return modified copy of the {@code this} object
   */
  public final ImmutableRegistration withId(String value) {
    if (this.id == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableRegistration(this.name, newValue, this.address, this.port, this.check, this.checks, this.tags);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Registration#getAddress() address}.
   * @param value value for address
   * @return modified copy of {@code this} object
   */
  public final ImmutableRegistration withAddress(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableRegistration(this.name, this.id, newValue, this.port, this.check, this.checks, this.tags);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Registration#getAddress() address}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for address
   * @return modified copy of {@code this} object
   */
  public final ImmutableRegistration withAddress(Optional<String> optional) {
    if (this.address == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableRegistration(this.name, this.id, newValue, this.port, this.check, this.checks, this.tags);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Registration#getPort() port}.
   * @param value value for port
   * @return modified copy of {@code this} object
   */
  public final ImmutableRegistration withPort(int value) {
    Optional<Integer> newValue = Optional.of(value);
    return new ImmutableRegistration(this.name, this.id, this.address, newValue, this.check, this.checks, this.tags);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Registration#getPort() port}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for port
   * @return modified copy of {@code this} object
   */
  public final ImmutableRegistration withPort(Optional<Integer> optional) {
    if (this.port == optional) {
      return this;
    }
    Optional<Integer> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableRegistration(this.name, this.id, this.address, newValue, this.check, this.checks, this.tags);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Registration#getCheck() check}.
   * @param value value for check
   * @return modified copy of {@code this} object
   */
  public final ImmutableRegistration withCheck(Registration.RegCheck value) {
    Optional<Registration.RegCheck> newValue = Optional.of(value);
    return new ImmutableRegistration(this.name, this.id, this.address, this.port, newValue, this.checks, this.tags);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Registration#getCheck() check}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for check
   * @return modified copy of {@code this} object
   */
  public final ImmutableRegistration withCheck(Optional<Registration.RegCheck> optional) {
    if (this.check == optional) {
      return this;
    }
    Optional<Registration.RegCheck> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableRegistration(this.name, this.id, this.address, this.port, newValue, this.checks, this.tags);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link Registration#getChecks() checks}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableRegistration withChecks(Registration.RegCheck... elements) {
    ImmutableList<Registration.RegCheck> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, newValue, this.tags);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link Registration#getChecks() checks}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of checks elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableRegistration withChecks(Iterable<? extends Registration.RegCheck> elements) {
    if (this.checks == elements) {
      return this;
    }
    ImmutableList<Registration.RegCheck> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, newValue, this.tags);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link Registration#getTags() tags}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableRegistration withTags(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, this.checks, newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link Registration#getTags() tags}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of tags elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableRegistration withTags(Iterable<String> elements) {
    if (this.tags == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, this.checks, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableRegistration} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutableRegistration && equalTo((ImmutableRegistration) another));
  }
  
  private boolean equalTo(ImmutableRegistration another) {
    return name.equals(another.name)
        && id.equals(another.id)
        && address.equals(another.address)
        && port.equals(another.port)
        && check.equals(another.check)
        && checks.equals(another.checks)
        && tags.equals(another.tags);
  }
  
  /**
   * Computes hash code from attributes: {@code name}, {@code id}, {@code address}, {@code port}, {@code check}, {@code checks}, {@code tags}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + id.hashCode();
    h = h * 17 + address.hashCode();
    h = h * 17 + port.hashCode();
    h = h * 17 + check.hashCode();
    h = h * 17 + checks.hashCode();
    h = h * 17 + tags.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code Registration{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Registration")
        .add("name", name)
        .add("id", id)
        .add("address", address)
        .add("port", port)
        .add("check", check)
        .add("checks", checks)
        .add("tags", tags)
        .toString();
  }
  
  @JsonCreator
  public static ImmutableRegistration fromAllAttributes(
      @JsonProperty("Name") String name,
      @JsonProperty("Id") String id,
      @JsonProperty("Address") Optional<String> address,
      @JsonProperty("Port") Optional<Integer> port,
      @JsonProperty("Check") Optional<Registration.RegCheck> check,
      @JsonProperty("Checks") List<Registration.RegCheck> checks,
      @JsonProperty("Tags") List<String> tags) {
    ImmutableRegistration.Builder builder = ImmutableRegistration.builder();
    if (name != null) {
      builder.name(name);
    }
    if (id != null) {
      builder.id(id);
    }
    if (address != null) {
      builder.address(address);
    }
    if (port != null) {
      builder.port(port);
    }
    if (check != null) {
      builder.check(check);
    }
    if (checks != null) {
      builder.addAllChecks(checks);
    }
    if (tags != null) {
      builder.addAllTags(tags);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link Registration}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable Registration instance
   */
  public static ImmutableRegistration copyOf(Registration instance) {
    if (instance instanceof ImmutableRegistration) {
      return (ImmutableRegistration) instance;
    }
    return ImmutableRegistration.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.model.agent.ImmutableRegistration}.
   * @return new ImmutableRegistration builder
   */
  public static ImmutableRegistration.Builder builder() {
    return new ImmutableRegistration.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.model.agent.ImmutableRegistration}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_NAME = 0x1L;
    private static final long INITIALIZED_BIT_ID = 0x2L;
    private long initializedBitset;
  
    private String name;
    private String id;
    private Optional<String> address = Optional.absent();
    private Optional<Integer> port = Optional.absent();
    private Optional<Registration.RegCheck> check = Optional.absent();
    private ImmutableList.Builder<Registration.RegCheck> checksBuilder = ImmutableList.builder();
    private ImmutableList.Builder<String> tagsBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link Registration} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(Registration instance) {
      Preconditions.checkNotNull(instance);
      name(instance.getName());
      id(instance.getId());
      Optional<String> addressOptional = instance.getAddress();
      if (addressOptional.isPresent()) {
        address(addressOptional);
      }
      Optional<Integer> portOptional = instance.getPort();
      if (portOptional.isPresent()) {
        port(portOptional);
      }
      Optional<Registration.RegCheck> checkOptional = instance.getCheck();
      if (checkOptional.isPresent()) {
        check(checkOptional);
      }
      addAllChecks(instance.getChecks());
      addAllTags(instance.getTags());
      return this;
    }
  
    /**
     * Initializes value for {@link Registration#getName() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name);
      initializedBitset |= INITIALIZED_BIT_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link Registration#getId() id}.
     * @param id value for id
     * @return {@code this} builder for chained invocation
     */
    public final Builder id(String id) {
      this.id = Preconditions.checkNotNull(id);
      initializedBitset |= INITIALIZED_BIT_ID;
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Registration#getAddress() address}.
     * @param address value for address
     * @return {@code this} builder for chained invocation
     */
    public final Builder address(String address) {
      this.address = Optional.of(address);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Registration#getAddress() address}.
     * @param address value for address
     * @return {@code this} builder for chained invocation
     */
    public final Builder address(Optional<String> address) {
      this.address = Preconditions.checkNotNull(address);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Registration#getPort() port}.
     * @param port value for port
     * @return {@code this} builder for chained invocation
     */
    public final Builder port(int port) {
      this.port = Optional.of(port);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Registration#getPort() port}.
     * @param port value for port
     * @return {@code this} builder for chained invocation
     */
    public final Builder port(Optional<Integer> port) {
      this.port = Preconditions.checkNotNull(port);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Registration#getCheck() check}.
     * @param check value for check
     * @return {@code this} builder for chained invocation
     */
    public final Builder check(Registration.RegCheck check) {
      this.check = Optional.of(check);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Registration#getCheck() check}.
     * @param check value for check
     * @return {@code this} builder for chained invocation
     */
    public final Builder check(Optional<Registration.RegCheck> check) {
      this.check = Preconditions.checkNotNull(check);
      return this;
    }
  
    /**
     * Adds one element to {@link Registration#getChecks() checks} list.
     * @param element checks element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addChecks(Registration.RegCheck element) {
      checksBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link Registration#getChecks() checks} list.
     * @param elements array of checks elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addChecks(Registration.RegCheck... elements) {
      checksBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link Registration#getChecks() checks} list.
     * @param elements iterable of checks elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder checks(Iterable<? extends Registration.RegCheck> elements) {
      checksBuilder = ImmutableList.builder();
      return addAllChecks(elements);
    }
  
    /**
     * Adds elements to {@link Registration#getChecks() checks} list.
     * @param elements iterable of checks elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllChecks(Iterable<? extends Registration.RegCheck> elements) {
      checksBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link Registration#getTags() tags} list.
     * @param element tags element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addTags(String element) {
      tagsBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link Registration#getTags() tags} list.
     * @param elements array of tags elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addTags(String... elements) {
      tagsBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link Registration#getTags() tags} list.
     * @param elements iterable of tags elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder tags(Iterable<String> elements) {
      tagsBuilder = ImmutableList.builder();
      return addAllTags(elements);
    }
  
    /**
     * Adds elements to {@link Registration#getTags() tags} list.
     * @param elements iterable of tags elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllTags(Iterable<String> elements) {
      tagsBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.model.agent.ImmutableRegistration}.
     * @return immutable instance of Registration
     */
    public ImmutableRegistration build() {
      checkRequiredAttributes();
      return new ImmutableRegistration(name, id, address, port, check, checksBuilder.build(), tagsBuilder.build());
    }
  
    private boolean nameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NAME) != 0;
    }
  
    private boolean idIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ID) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!nameIsSet()) {
        attributes.add("name");
      }
      if (!idIsSet()) {
        attributes.add("id");
      }
      return "Cannot build Registration, some of required attributes are not set " + attributes;
    }
  }
}
