/*
 * Decompiled with CFR 0.152.
 */
package redis.netty4;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import redis.netty4.IRedisDecoderState;
import redis.netty4.Reply;

public abstract class AbstractRedisDecoderState
implements IRedisDecoderState {
    public static final char CR = '\r';
    public static final char LF = '\n';
    private static final char ZERO = '0';
    private IRedisDecoderState nextState;
    private Reply decodedReply;

    protected void setNextState(IRedisDecoderState nextState) {
        this.nextState = nextState;
    }

    @Override
    public IRedisDecoderState getNextState() {
        return this.nextState;
    }

    protected void setDecodedReply(Reply decodedReply) {
        this.decodedReply = decodedReply;
    }

    @Override
    public Reply getDecodedReply() {
        return this.decodedReply;
    }

    public Integer readBulkReplySize(ByteBuf is, int indexCrLf) throws IOException {
        Long l = AbstractRedisDecoderState.readLong(is, indexCrLf);
        if (l == null) {
            return null;
        }
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Java only supports arrays up to 2147483647 in size");
        }
        int size = l.intValue();
        return size;
    }

    public ByteBuf readBytes(ByteBuf is, int indexCrLf, int size) throws IOException {
        if (is.readableBytes() < size + 2) {
            return null;
        }
        ByteBuf buffer = is.readSlice(size);
        byte cr = is.readByte();
        byte lf = is.readByte();
        if (cr != 13 || lf != 10) {
            throw new IOException("Improper line ending: " + cr + ", " + lf);
        }
        return buffer;
    }

    public static Long readLong(ByteBuf is, int indexCrLf) throws IOException {
        long size = 0L;
        int sign = 1;
        byte read = is.readByte();
        if (read == 45) {
            read = is.readByte();
            sign = -1;
        }
        while (read != 13 || is.readByte() != 10) {
            int value = read - 48;
            if (value >= 0 && value < 10) {
                size *= 10L;
                size += (long)value;
            } else {
                throw new IOException("Invalid character in integer");
            }
            read = is.readByte();
        }
        return size * (long)sign;
    }

    public static Long readLong(ByteBuf is) throws IOException {
        return AbstractRedisDecoderState.readLong(is, AbstractRedisDecoderState.findCrLf(is));
    }

    public static int findCrLf(ByteBuf bb) {
        int ri = bb.readerIndex();
        int rb = bb.readableBytes();
        if (rb < 2) {
            return -1;
        }
        int i = bb.indexOf(ri, ri + rb, (byte)10);
        if (i > -1 && i > ri && bb.getByte(i - 1) == 13) {
            return i - 1;
        }
        return -1;
    }
}

