/*
 * Decompiled with CFR 0.152.
 */
package redis.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.netty4.IRedisDecoderState;
import redis.netty4.InitialRedisDecoderState;
import redis.netty4.Reply;

public class RedisReplyDecoder
extends ByteToMessageDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(RedisReplyDecoder.class);
    private IRedisDecoderState state = new InitialRedisDecoderState();

    @Override
    protected final void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        Object decoded = this.decode(ctx, in);
        while (decoded != null) {
            out.add(decoded);
            decoded = this.decode(ctx, in);
        }
    }

    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        if (LOG.isDebugEnabled()) {
            int readableBytes = in.readableBytes();
            LOG.trace("readableBytes={}", (Object)readableBytes);
            byte[] dst = new byte[readableBytes];
            in.getBytes(in.readerIndex(), dst, 0, readableBytes);
            if (LOG.isTraceEnabled()) {
                LOG.trace("*decoder received : {}", (Object)new String(dst, CharsetUtil.UTF_8).replaceAll("\r\n", " "));
            }
        }
        return this.receive(in);
    }

    protected Reply receive(ByteBuf in) throws IOException {
        this.state.decode(in);
        Reply res = this.state.getDecodedReply();
        this.state = this.state.getNextState();
        LOG.trace("*decoder res={}", (Object)res);
        return res;
    }
}

