/*
 * Decompiled with CFR 0.152.
 */
package redis.reply;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.RedisProtocol;
import redis.reply.BulkReply;
import redis.reply.IntegerReply;
import redis.reply.Reply;
import redis.util.Encoding;

public class MultiBulkReply
implements Reply<Reply[]> {
    public static final char MARKER = '*';
    private final Reply[] replies;

    public MultiBulkReply(InputStream is) throws IOException {
        long size = RedisProtocol.readLong(is);
        if (size == -1L) {
            this.replies = null;
        } else {
            if (size > Integer.MAX_VALUE || size < 0L) {
                throw new IllegalArgumentException("Invalid size: " + size);
            }
            this.replies = new Reply[(int)size];
            int i = 0;
            while ((long)i < size) {
                this.replies[i] = RedisProtocol.receive(is);
                ++i;
            }
        }
    }

    public MultiBulkReply(Reply[] replies) {
        this.replies = replies;
    }

    @Override
    public Reply[] data() {
        return this.replies;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        os.write(42);
        if (this.replies == null) {
            os.write(Encoding.NEG_ONE_WITH_CRLF);
        } else {
            os.write(RedisProtocol.toBytes(this.replies.length));
            os.write(CRLF);
            for (Reply reply : this.replies) {
                reply.write(os);
            }
        }
    }

    public List<String> asStringList(Charset charset) {
        if (this.replies == null) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>(this.replies.length);
        for (Reply reply : this.replies) {
            if (reply instanceof BulkReply) {
                strings.add(((BulkReply)reply).asString(charset));
                continue;
            }
            if (reply instanceof IntegerReply) {
                strings.add(reply.data().toString());
                continue;
            }
            throw new IllegalArgumentException("Could not convert " + reply + " to a string");
        }
        return strings;
    }

    public Set<String> asStringSet(Charset charset) {
        if (this.replies == null) {
            return null;
        }
        HashSet<String> strings = new HashSet<String>(this.replies.length);
        for (Reply reply : this.replies) {
            if (!(reply instanceof BulkReply)) {
                throw new IllegalArgumentException("Could not convert " + reply + " to a string");
            }
            strings.add(((BulkReply)reply).asString(charset));
        }
        return strings;
    }

    public Map<String, String> asStringMap(Charset charset) {
        if (this.replies == null) {
            return null;
        }
        int length = this.replies.length;
        HashMap<String, String> map = new HashMap<String, String>(length);
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Odd number of replies");
        }
        for (int i = 0; i < length; i += 2) {
            Reply key = this.replies[i];
            Reply value = this.replies[i + 1];
            if (key instanceof BulkReply) {
                if (!(value instanceof BulkReply)) {
                    throw new IllegalArgumentException("Could not convert value: " + value + " to a string");
                }
            } else {
                throw new IllegalArgumentException("Could not convert key: " + key + " to a string");
            }
            map.put(((BulkReply)key).asString(charset), ((BulkReply)value).asString(charset));
        }
        return map;
    }
}

