/*
 * Decompiled with CFR 0.152.
 */
package redis.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.netty4.AbstarctReply;
import redis.netty4.BulkReply;
import redis.netty4.Reply;
import redis.util.Encoding;

public class MultiBulkReply
extends AbstarctReply<Reply[]> {
    public static final char MARKER = '*';
    public static final MultiBulkReply EMPTY = new MultiBulkReply(new AbstarctReply[0]);
    private final int size;
    private int index = 0;

    public MultiBulkReply(Reply[] replies) {
        super(replies);
        this.size = replies.length;
    }

    public MultiBulkReply(int size2) {
        super(null);
        this.size = size2;
        if (this.size == -1) {
            this.setData(null);
        } else {
            if (this.size < 0) {
                throw new IllegalArgumentException("Invalid size: " + this.size);
            }
            this.setData(new Reply[this.size]);
        }
    }

    public void add(Reply r) throws IOException {
        if (this.index > ((Reply[])this.data()).length - 1) {
            throw new IOException("cannot add, MultiBulkReply is full !");
        }
        ((Reply[])this.data())[this.index] = r;
        ++this.index;
    }

    public boolean isFull() {
        return this.index == ((Reply[])this.data()).length;
    }

    @Override
    public void write(ByteBuf os) throws IOException {
        os.writeByte(42);
        if (this.data() == null) {
            os.writeBytes(Encoding.NEG_ONE_WITH_CRLF);
        } else {
            os.writeBytes(Encoding.numToBytes(((Reply[])this.data()).length, true));
            for (Reply reply : (Reply[])this.data()) {
                reply.write(os);
            }
        }
    }

    public List<String> asStringList(Charset charset) {
        if (this.data() == null) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>(((Reply[])this.data()).length);
        for (Reply reply : (Reply[])this.data()) {
            if (reply instanceof BulkReply) {
                strings.add(((BulkReply)reply).asString(charset));
                continue;
            }
            strings.add(reply.toString());
        }
        return strings;
    }

    public List<byte[]> asByteArrayList() {
        if (this.data() == null) {
            return null;
        }
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>(((Reply[])this.data()).length);
        for (Reply reply : (Reply[])this.data()) {
            if (!(reply instanceof BulkReply)) {
                throw new IllegalArgumentException("Could not convert " + reply + " to a byteArray");
            }
            byteArrays.add(((BulkReply)reply).asByteArray());
        }
        return byteArrays;
    }

    public Set<String> asStringSet(Charset charset) {
        if (this.data() == null) {
            return null;
        }
        HashSet<String> strings = new HashSet<String>(((Reply[])this.data()).length);
        for (Reply reply : (Reply[])this.data()) {
            if (reply instanceof BulkReply) {
                strings.add(((BulkReply)reply).asString(charset));
                continue;
            }
            strings.add(reply.toString());
        }
        return strings;
    }

    public Map<String, String> asStringMap(Charset charset) {
        if (this.data() == null) {
            return null;
        }
        int length = ((Reply[])this.data()).length;
        HashMap<String, String> map = new HashMap<String, String>(length);
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Odd number of replies");
        }
        for (int i = 0; i < length; i += 2) {
            Reply key = ((Reply[])this.data())[i];
            Reply value = ((Reply[])this.data())[i + 1];
            if (key instanceof BulkReply) {
                if (!(value instanceof BulkReply)) {
                    throw new IllegalArgumentException("Could not convert value: " + value + " to a string");
                }
            } else {
                throw new IllegalArgumentException("Could not convert key: " + key + " to a string");
            }
            map.put(((BulkReply)key).asString(charset), ((BulkReply)value).asString(charset));
        }
        return map;
    }

    public String toString() {
        return this.asStringList(CharsetUtil.UTF_8).toString();
    }

    @Override
    public void releaseAll() {
        for (Reply reply : (Reply[])this.data()) {
            reply.releaseAll();
        }
    }
}

