/*
 * Decompiled with CFR 0.152.
 */
package redis.util;

import redis.util.BytesKey;

public class BytesValue {
    protected final byte[] bytes;

    public BytesValue(byte[] bytes) {
        this.bytes = bytes;
    }

    public int hashCode() {
        int hashCode = 0;
        for (byte aByte : this.bytes) {
            hashCode += 43 * aByte;
        }
        return hashCode;
    }

    public static boolean equals(byte[] thisBytes, byte[] otherBytes) {
        int length = thisBytes.length;
        if (length != otherBytes.length) {
            return false;
        }
        int half = length / 2;
        for (int i = 0; i < half; ++i) {
            int end = length - i - 1;
            if (thisBytes[end] != otherBytes[end]) {
                return false;
            }
            if (thisBytes[i] == otherBytes[i]) continue;
            return false;
        }
        return half == length - half || thisBytes[half] == otherBytes[half];
    }

    public boolean equals(Object o) {
        return o instanceof BytesKey && BytesValue.equals(this.bytes, ((BytesKey)o).bytes);
    }

    public String toString() {
        return new String(this.bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

