/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.dom;

import oracle.xdb.dom.XDBAttribute;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBNode;
import oracle.xdb.dom.XDBNodeList;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XDBElement
extends XDBNode
implements Element {
    public XDBElement(XDBDocument owner, long xob) {
        super(owner, xob, (short)1);
        this.m_owner = owner;
    }

    private native long getAttrNodeNative(long var1, long var3, String var5, String var6);

    private native String getAttrValueNative(long var1, long var3, String var5, String var6);

    public String getAttribute(String attr) {
        if (this.isClosed()) {
            return null;
        }
        return this.getAttrValueNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, null, attr);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        if (this.isClosed()) {
            return null;
        }
        return this.getAttrValueNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, namespaceURI, localName);
    }

    public Attr getAttributeNode(String attr) {
        if (this.isClosed()) {
            return null;
        }
        long xob = this.getAttrNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, null, attr);
        if (xob != 0L) {
            return new XDBAttribute(this.m_owner, this, xob);
        }
        return null;
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        long xob = this.getAttrNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, namespaceURI, localName);
        if (xob != 0L) {
            return new XDBAttribute(this.m_owner, this, xob);
        }
        return null;
    }

    public XDBNodeList getChildrenByTagName(String tagName) {
        if (this.isClosed()) {
            return null;
        }
        long listcstate = this.getChildrenByTagNameNSNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, tagName, null);
        if (listcstate == 0L) {
            return null;
        }
        return new XDBNodeList(listcstate, this.m_owner);
    }

    public XDBNodeList getChildrenByTagNameNS(String tagName, String ns) {
        if (this.isClosed()) {
            return null;
        }
        long listcstate = this.getChildrenByTagNameNSNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, tagName, ns);
        if (listcstate == 0L) {
            return null;
        }
        return new XDBNodeList(listcstate, this.m_owner);
    }

    private synchronized native long getChildrenByTagNameNSNative(long var1, long var3, String var5, String var6);

    public NodeList getElementsByTagName(String tag) {
        if (this.isClosed()) {
            return null;
        }
        long listcstate = this.getElementsNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, null, tag);
        if (listcstate == 0L) {
            return null;
        }
        return new XDBNodeList(listcstate, this.m_owner);
    }

    public NodeList getElementsByTagNameNS(String nsURI, String tag) {
        if (this.isClosed()) {
            return null;
        }
        long listcstate = this.getElementsNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, nsURI, tag);
        if (listcstate == 0L) {
            return null;
        }
        return new XDBNodeList(listcstate, this.m_owner);
    }

    private native long getElementsNative(long var1, long var3, String var5, String var6);

    public String getTagName() {
        if (this.isClosed()) {
            return null;
        }
        return super.getNodeName();
    }

    private native boolean hasAttrNative(long var1, long var3, String var5, String var6);

    public boolean hasAttribute(String name) {
        if (this.isClosed()) {
            return false;
        }
        return this.hasAttrNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, null, name);
    }

    public boolean hasAttributeNS(String nsURI, String name) {
        if (this.isClosed()) {
            return false;
        }
        return this.hasAttrNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, nsURI, name);
    }

    private native void removeAttrNative(long var1, long var3, String var5, String var6);

    private native void removeAttrNodeNative(long var1, long var3, long var5);

    public void removeAttribute(String attr) {
        if (this.isClosed()) {
            return;
        }
        this.removeAttrNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, null, attr);
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        this.removeAttrNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, namespaceURI, localName);
    }

    public Attr removeAttributeNode(Attr oldattr) {
        if (this.isClosed()) {
            return null;
        }
        XDBAttribute xattr = (XDBAttribute)oldattr;
        this.removeAttrNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, xattr.toCState());
        return oldattr;
    }

    public String resolveNSPrefix(String prefix) {
        if (this.isClosed()) {
            return null;
        }
        return this.resolveNSPrefixNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, prefix);
    }

    private synchronized native String resolveNSPrefixNative(long var1, long var3, String var5);

    private native long setAttrNodeNative(long var1, long var3, long var5);

    private native void setAttrValueNative(long var1, long var3, String var5, String var6, String var7);

    public void setAttribute(String name, String attr) {
        if (this.isClosed()) {
            return;
        }
        XDBNode.validateName(name);
        this.setAttrValueNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, null, name, attr);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        XDBNode.validateName(qualifiedName);
        this.setAttrValueNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, namespaceURI, qualifiedName, value);
    }

    public Attr setAttributeNode(Attr newattr) throws DOMException {
        long oldattrxob;
        if (this.isClosed()) {
            return null;
        }
        XDBAttribute xattr = (XDBAttribute)newattr;
        try {
            oldattrxob = this.setAttrNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, xattr.toCState());
        }
        catch (DOMException ex) {
            switch (ex.code) {
                case 32124: {
                    throw new DOMException(10, "Attribute in use");
                }
            }
            throw ex;
        }
        if (oldattrxob != 0L) {
            return new XDBAttribute(this.m_owner, this, oldattrxob);
        }
        return null;
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        long oldattrxob;
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        XDBAttribute xattr = (XDBAttribute)newAttr;
        try {
            oldattrxob = this.setAttrNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, xattr.toCState());
        }
        catch (DOMException ex) {
            switch (ex.code) {
                case 32124: {
                    throw new DOMException(10, "Attribute in use");
                }
            }
            throw ex;
        }
        if (oldattrxob != 0L) {
            return new XDBAttribute(this.m_owner, this, oldattrxob);
        }
        return null;
    }
}

