/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.polyglot.HostInteropErrors;
import com.oracle.truffle.polyglot.HostInteropReflect;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.PolyglotClassCastException;
import com.oracle.truffle.polyglot.PolyglotFunction;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotList;
import com.oracle.truffle.polyglot.PolyglotMap;
import com.oracle.truffle.polyglot.ToHostNodeGen;
import com.oracle.truffle.polyglot.ToHostPrimitiveNode;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.graalvm.polyglot.Value;

abstract class ToHostNode
extends Node {
    static final int LIMIT = 3;
    static final int STRICT = 0;
    static final int LOOSE = 1;
    static final int FUNCTION_PROXY = 2;
    static final int OBJECT_PROXY = 3;
    static final int COERCE = 4;
    static final int HOST_PROXY = 5;
    static final int[] PRIORITIES = new int[]{0, 1, 2, 3, 4, 5};
    @Node.Child
    private Node isExecutable = Message.IS_EXECUTABLE.createNode();
    @Node.Child
    private Node isInstantiable = Message.IS_INSTANTIABLE.createNode();
    @Node.Child
    private Node isNull = Message.IS_NULL.createNode();
    @Node.Child
    private Node hasKeysNode = Message.HAS_KEYS.createNode();
    @Node.Child
    private ToHostPrimitiveNode primitive = ToHostPrimitiveNode.create();

    ToHostNode() {
    }

    public abstract Object execute(Object var1, Class<?> var2, Type var3, PolyglotLanguageContext var4);

    @Specialization(guards={"operand == null"})
    protected Object doNull(Object operand, Class<?> targetType, Type genericType, PolyglotLanguageContext languageContext) {
        return null;
    }

    @Specialization(guards={"operand != null", "operand.getClass() == cachedOperandType", "targetType == cachedTargetType"}, limit="LIMIT")
    protected Object doCached(Object operand, Class<?> targetType, Type genericType, PolyglotLanguageContext languageContext, @Cached(value="operand.getClass()") Class<?> cachedOperandType, @Cached(value="targetType") Class<?> cachedTargetType) {
        return this.convertImpl(cachedOperandType.cast(operand), cachedTargetType, genericType, languageContext);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"operand != null"}, replaces={"doCached"})
    protected Object doGeneric(Object operand, Class<?> targetType, Type genericType, PolyglotLanguageContext languageContext) {
        return this.convertImpl(operand, targetType, genericType, languageContext);
    }

    private Object convertImpl(Object value, Class<?> targetType, Type genericType, PolyglotLanguageContext languageContext) {
        Object convertedValue;
        if (ToHostNode.isAssignableFromTrufflePrimitiveType(targetType)) {
            Object unboxed = this.primitive.unbox(value);
            convertedValue = this.primitive.toPrimitive(unboxed, targetType);
            if (convertedValue != null) {
                return convertedValue;
            }
            if (targetType == Character.TYPE || targetType == Character.class) {
                int v;
                Integer safeChar = this.primitive.toInteger(unboxed);
                if (safeChar != null && (v = safeChar.intValue()) >= 0 && v < 65536) {
                    return Character.valueOf((char)v);
                }
            } else if (targetType == String.class && PolyglotImpl.isGuestPrimitive(unboxed)) {
                return ToHostNode.convertToString(unboxed);
            }
        }
        if (targetType == Value.class && languageContext != null) {
            convertedValue = value instanceof Value ? value : languageContext.asValue(value);
        } else if (value instanceof TruffleObject) {
            convertedValue = this.asJavaObject((TruffleObject)value, targetType, genericType, languageContext);
        } else if (targetType.isAssignableFrom(value.getClass())) {
            convertedValue = value;
        } else {
            CompilerDirectives.transferToInterpreter();
            String reason = ToHostNode.isAssignableFromTrufflePrimitiveType(targetType) ? "Invalid or lossy primitive coercion." : "Unsupported target type.";
            throw HostInteropErrors.cannotConvert(languageContext, value, targetType, reason);
        }
        return convertedValue;
    }

    boolean canConvertToPrimitive(Object value, Class<?> targetType, int priority) {
        int v;
        Integer safeChar;
        if (HostObject.isJavaInstance(targetType, value)) {
            return true;
        }
        if (!ToHostNode.isAssignableFromTrufflePrimitiveType(targetType)) {
            return false;
        }
        Object unboxed = this.primitive.unbox(value);
        Object convertedValue = this.primitive.toPrimitive(unboxed, targetType);
        if (convertedValue != null) {
            return true;
        }
        if (priority <= 0) {
            return false;
        }
        return targetType == Character.TYPE || targetType == Character.class ? (safeChar = this.primitive.toInteger(unboxed)) != null && (v = safeChar.intValue()) >= 0 && v < 65536 : priority >= 4 && targetType == String.class && PolyglotImpl.isGuestPrimitive(unboxed);
    }

    boolean canConvert(Object value, Class<?> targetType, Type genericType, Object languageContext, int priority) {
        return this.canConvert(value, targetType, genericType, languageContext != null, priority);
    }

    boolean canConvert(Object value, Class<?> targetType, int priority) {
        return this.canConvert(value, targetType, (Type)null, true, priority);
    }

    private boolean canConvert(Object value, Class<?> targetType, Type genericType, boolean allowValue, int priority) {
        if (this.canConvertToPrimitive(value, targetType, priority)) {
            return true;
        }
        if (priority <= 0) {
            return false;
        }
        if (targetType == Value.class && allowValue) {
            return true;
        }
        if (value instanceof TruffleObject) {
            TruffleObject tValue = (TruffleObject)value;
            if (ForeignAccess.sendIsNull(this.isNull, tValue)) {
                return !targetType.isPrimitive();
            }
            if (targetType == Object.class) {
                return true;
            }
            if (HostObject.isJavaInstance(targetType, tValue)) {
                return true;
            }
            if (targetType == List.class) {
                return this.primitive.hasSize(tValue);
            }
            if (targetType == Map.class) {
                return this.primitive.hasKeys(tValue);
            }
            if (targetType.isArray()) {
                return this.primitive.hasSize(tValue);
            }
            if (priority < 5 && HostObject.isInstance(tValue)) {
                return false;
            }
            if (TruffleOptions.AOT) {
                if (priority >= 2 && targetType == Function.class) {
                    return this.isExecutable(tValue) || this.isInstantiable(tValue);
                }
                return false;
            }
            if (priority >= 2 && HostInteropReflect.isFunctionalInterface(targetType) && (this.isExecutable(tValue) || this.isInstantiable(tValue))) {
                return true;
            }
            return priority >= 3 && targetType.isInterface() && ForeignAccess.sendHasKeys(this.hasKeysNode, tValue);
        }
        assert (!(value instanceof TruffleObject));
        return targetType.isInstance(value);
    }

    static boolean isAssignableFromTrufflePrimitiveType(Class<?> clazz) {
        return clazz == Integer.TYPE || clazz == Integer.class || clazz == Boolean.TYPE || clazz == Boolean.class || clazz == Byte.TYPE || clazz == Byte.class || clazz == Short.TYPE || clazz == Short.class || clazz == Long.TYPE || clazz == Long.class || clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class || clazz == Character.TYPE || clazz == Character.class || clazz == Number.class || CharSequence.class.isAssignableFrom(clazz);
    }

    private boolean isExecutable(TruffleObject object) {
        return ForeignAccess.sendIsExecutable(this.isExecutable, object);
    }

    private boolean isInstantiable(TruffleObject object) {
        return ForeignAccess.sendIsInstantiable(this.isInstantiable, object);
    }

    private Object convertToObject(TruffleObject truffleObject, PolyglotLanguageContext languageContext) {
        Object primitiveValue = this.primitive.unbox(truffleObject);
        if (primitiveValue != null) {
            return primitiveValue;
        }
        if (this.primitive.hasKeys(truffleObject)) {
            return this.asJavaObject(truffleObject, Map.class, null, languageContext);
        }
        if (this.primitive.hasSize(truffleObject)) {
            return this.asJavaObject(truffleObject, List.class, null, languageContext);
        }
        if (this.isExecutable(truffleObject) || this.isInstantiable(truffleObject)) {
            return this.asJavaObject(truffleObject, Function.class, null, languageContext);
        }
        return languageContext.asValue(truffleObject);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CompilerDirectives.TruffleBoundary
    private <T> T asJavaObject(TruffleObject truffleObject, Class<T> targetType, Type genericType, PolyglotLanguageContext languageContext) {
        Map obj;
        Objects.requireNonNull(truffleObject);
        if (this.primitive.isNull(truffleObject)) {
            if (!targetType.isPrimitive()) return null;
            throw HostInteropErrors.nullCoercion(languageContext, truffleObject, targetType);
        }
        if (HostObject.isJavaInstance(targetType, truffleObject)) {
            obj = HostObject.valueOf(truffleObject);
        } else if (targetType == Object.class) {
            obj = this.convertToObject(truffleObject, languageContext);
        } else if (targetType == List.class) {
            if (!this.primitive.hasSize(truffleObject)) throw HostInteropErrors.cannotConvert(languageContext, truffleObject, targetType, "Value must have array elements.");
            boolean implementsFunction = this.shouldImplementFunction(truffleObject);
            TypeAndClass<?> elementType = ToHostNode.getGenericParameterType(genericType, 0);
            obj = PolyglotList.create(languageContext, truffleObject, implementsFunction, elementType.clazz, elementType.type);
        } else if (targetType == Map.class) {
            boolean hasKeys;
            Class keyClazz = ToHostNode.getGenericParameterType((Type)genericType, (int)0).clazz;
            TypeAndClass<?> valueType = ToHostNode.getGenericParameterType(genericType, 1);
            if (!ToHostNode.isSupportedMapKeyType(keyClazz)) {
                throw ToHostNode.newInvalidKeyTypeException(keyClazz);
            }
            boolean hasSize = Number.class.isAssignableFrom(keyClazz) && this.primitive.hasSize(truffleObject);
            boolean bl = hasKeys = (keyClazz == Object.class || keyClazz == String.class) && this.primitive.hasKeys(truffleObject);
            if (!hasKeys && !hasSize) throw HostInteropErrors.cannotConvert(languageContext, truffleObject, targetType, "Value must have members or array elements.");
            boolean implementsFunction = this.shouldImplementFunction(truffleObject);
            obj = PolyglotMap.create(languageContext, truffleObject, implementsFunction, keyClazz, valueType.clazz, valueType.type);
        } else if (targetType == Function.class) {
            TypeAndClass<?> returnType = ToHostNode.getGenericParameterType(genericType, 1);
            if (this.isExecutable(truffleObject) || this.isInstantiable(truffleObject)) {
                obj = PolyglotFunction.create(languageContext, truffleObject, returnType.clazz, returnType.type);
            } else {
                if (TruffleOptions.AOT || !ForeignAccess.sendHasKeys(this.hasKeysNode, truffleObject)) throw HostInteropErrors.cannotConvert(languageContext, truffleObject, targetType, "Value must be executable or instantiable.");
                obj = HostInteropReflect.newProxyInstance(targetType, truffleObject, languageContext);
            }
        } else if (targetType.isArray()) {
            if (!this.primitive.hasSize(truffleObject)) throw HostInteropErrors.cannotConvert(languageContext, truffleObject, targetType, "Value must have array elements.");
            obj = ToHostNode.truffleObjectToArray(truffleObject, targetType, genericType, languageContext);
        } else {
            if (TruffleOptions.AOT || !targetType.isInterface()) throw HostInteropErrors.cannotConvert(languageContext, truffleObject, targetType, "Unsupported target type.");
            if (HostInteropReflect.isFunctionalInterface(targetType) && (this.isExecutable(truffleObject) || this.isInstantiable(truffleObject))) {
                obj = HostInteropReflect.asJavaFunction(targetType, truffleObject, languageContext);
            } else {
                if (!ForeignAccess.sendHasKeys(this.hasKeysNode, truffleObject)) throw HostInteropErrors.cannotConvert(languageContext, truffleObject, targetType, "Value must have members.");
                obj = HostInteropReflect.newProxyInstance(targetType, truffleObject, languageContext);
            }
        }
        assert (targetType.isInstance(obj));
        return targetType.cast(obj);
    }

    private boolean shouldImplementFunction(TruffleObject truffleObject) {
        boolean executable = this.isExecutable(truffleObject);
        boolean instantiable = false;
        if (!executable) {
            instantiable = this.isInstantiable(truffleObject);
        }
        boolean implementsFunction = executable || instantiable;
        return implementsFunction;
    }

    private static boolean isSupportedMapKeyType(Class<?> keyType) {
        return keyType == Object.class || keyType == String.class || keyType == Long.class || keyType == Integer.class || keyType == Number.class;
    }

    @CompilerDirectives.TruffleBoundary
    private static ClassCastException newInvalidKeyTypeException(Type targetType) {
        String message = "Unsupported Map key type: " + targetType;
        return new PolyglotClassCastException(message);
    }

    private static TypeAndClass<?> getGenericParameterType(Type genericType, int index) {
        if (!TruffleOptions.AOT && genericType instanceof ParameterizedType) {
            ParameterizedType parametrizedType = (ParameterizedType)genericType;
            Type[] typeArguments = parametrizedType.getActualTypeArguments();
            Class elementClass = Object.class;
            if (index < typeArguments.length) {
                Type elementType = typeArguments[index];
                if (elementType instanceof ParameterizedType) {
                    elementType = ((ParameterizedType)elementType).getRawType();
                }
                if (elementType instanceof Class) {
                    elementClass = (Class)elementType;
                }
                return new TypeAndClass(typeArguments[index], elementClass);
            }
        }
        return TypeAndClass.ANY;
    }

    private static Type getGenericArrayComponentType(Type genericType) {
        Type genericComponentType = null;
        if (!TruffleOptions.AOT && genericType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)genericType;
            genericComponentType = genericArrayType.getGenericComponentType();
        }
        return genericComponentType;
    }

    private static Object truffleObjectToArray(TruffleObject foreignObject, Class<?> arrayType, Type genericArrayType, PolyglotLanguageContext languageContext) {
        Class<?> componentType = arrayType.getComponentType();
        List<?> list = PolyglotList.create(languageContext, foreignObject, false, componentType, ToHostNode.getGenericArrayComponentType(genericArrayType));
        Object array = Array.newInstance(componentType, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, list.get(i));
        }
        return array;
    }

    @CompilerDirectives.TruffleBoundary
    private static String convertToString(Object value) {
        return value.toString();
    }

    public static ToHostNode create() {
        return ToHostNodeGen.create();
    }

    static final class TypeAndClass<T> {
        static final TypeAndClass<Object> ANY = new TypeAndClass<Object>(null, Object.class);
        final Type type;
        final Class<T> clazz;

        TypeAndClass(Type type, Class<T> clazz) {
            this.type = type;
            this.clazz = clazz;
        }

        public String toString() {
            return "[" + this.clazz + ": " + Objects.toString(this.type) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TypeAndClass)) {
                return false;
            }
            TypeAndClass other = (TypeAndClass)obj;
            return Objects.equals(this.clazz, other.clazz) && Objects.equals(this.type, other.type);
        }
    }
}

