/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotThread;
import java.util.LinkedList;

final class PolyglotThreadInfo {
    static final PolyglotThreadInfo NULL = new PolyglotThreadInfo(null);
    final Thread thread;
    private int enteredCount;
    final LinkedList<Object> explicitContextStack = new LinkedList();
    volatile boolean cancelled;

    PolyglotThreadInfo(Thread thread) {
        this.thread = thread;
    }

    boolean isCurrent() {
        return this.thread == Thread.currentThread();
    }

    void enter() {
        assert (Thread.currentThread() == this.thread);
        ++this.enteredCount;
    }

    boolean isPolyglotThread(PolyglotContextImpl c) {
        if (this.thread instanceof PolyglotThread) {
            return ((PolyglotThread)this.thread).isOwner(c);
        }
        return false;
    }

    void leave() {
        assert (Thread.currentThread() == this.thread);
        --this.enteredCount;
    }

    boolean isLastActive() {
        assert (Thread.currentThread() == this.thread);
        return this.thread != null && this.enteredCount == 1 && !this.cancelled;
    }

    boolean isActive() {
        return this.thread != null && this.enteredCount > 0 && !this.cancelled;
    }

    public String toString() {
        return super.toString() + "[thread=" + this.thread + ", enteredCount=" + this.enteredCount + ", cancelled=" + this.cancelled + "]";
    }
}

