/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.polyglot.InstrumentCache;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.VMAccessor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Instrument;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

class PolyglotInstrument
extends AbstractPolyglotImpl.AbstractInstrumentImpl
implements PolyglotImpl.VMObject {
    Instrument api;
    InstrumentInfo info;
    final InstrumentCache cache;
    final PolyglotEngineImpl engine;
    private final Object instrumentLock = new Object();
    private volatile OptionDescriptors options;
    private volatile OptionValuesImpl optionValues;
    private volatile boolean initialized;
    private volatile boolean created;

    PolyglotInstrument(PolyglotEngineImpl engine, InstrumentCache cache) {
        super((AbstractPolyglotImpl)engine.impl);
        this.engine = engine;
        this.cache = cache;
    }

    public OptionDescriptors getOptions() {
        this.engine.checkState();
        this.ensureInitialized();
        return this.options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OptionValuesImpl getOptionValues() {
        if (this.optionValues == null) {
            Object object = this.instrumentLock;
            synchronized (object) {
                if (this.optionValues == null) {
                    this.optionValues = new OptionValuesImpl(this.engine, this.getOptions());
                }
            }
        }
        return this.optionValues;
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this.engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureInitialized() {
        if (!this.initialized) {
            Object object = this.instrumentLock;
            synchronized (object) {
                if (!this.initialized) {
                    try {
                        Class<?> loadedInstrument = this.cache.getInstrumentationClass();
                        VMAccessor.INSTRUMENT.initializeInstrument(this.engine.instrumentationHandler, this, loadedInstrument);
                        this.options = VMAccessor.INSTRUMENT.describeOptions(this.engine.instrumentationHandler, this, this.cache.getId());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(String.format("Error initializing instrument '%s' using class '%s'.", this.cache.getId(), this.cache.getClassName()), e);
                    }
                    this.initialized = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureCreated() {
        if (!this.created) {
            Object object = this.instrumentLock;
            synchronized (object) {
                if (!this.created) {
                    if (!this.initialized) {
                        this.ensureInitialized();
                    }
                    VMAccessor.INSTRUMENT.createInstrument(this.engine.instrumentationHandler, this, this.cache.services(), this.getOptionValues());
                    this.created = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyClosing() {
        if (this.created) {
            Object object = this.instrumentLock;
            synchronized (object) {
                if (this.created) {
                    VMAccessor.INSTRUMENT.finalizeInstrument(this.engine.instrumentationHandler, this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureClosed() {
        assert (Thread.holdsLock(this.engine));
        if (this.created) {
            Object object = this.instrumentLock;
            synchronized (object) {
                if (this.created) {
                    VMAccessor.INSTRUMENT.disposeInstrument(this.engine.instrumentationHandler, this, false);
                }
                this.created = false;
                this.initialized = false;
                this.options = null;
                this.optionValues = null;
            }
        }
    }

    public <T> T lookup(Class<T> serviceClass) {
        return this.lookup(serviceClass, true);
    }

    <T> T lookup(Class<T> serviceClass, boolean wrapExceptions) {
        this.engine.checkState();
        if (this.cache.supportsService(serviceClass)) {
            try {
                this.ensureCreated();
            }
            catch (Throwable t) {
                if (wrapExceptions) {
                    throw PolyglotImpl.wrapGuestException(this.engine, t);
                }
                throw t;
            }
            return VMAccessor.INSTRUMENT.getInstrumentationHandlerService(this.engine.instrumentationHandler, this, serviceClass);
        }
        return null;
    }

    public String getId() {
        return this.cache.getId();
    }

    public String getName() {
        return this.cache.getName();
    }

    public String getVersion() {
        String version = this.cache.getVersion();
        if (version.equals("inherit")) {
            return this.engine.getVersion();
        }
        return version;
    }
}

