/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionValues;

final class OptionValuesImpl
implements OptionValues {
    private static final float FUZZY_MATCH_THRESHOLD = 0.7f;
    static final String SYSTEM_PROPERTY_PREFIX = "polyglot.";
    private final PolyglotEngineImpl engine;
    private final OptionDescriptors descriptors;
    private final Map<OptionKey<?>, Object> values;

    OptionValuesImpl(PolyglotEngineImpl engine, OptionDescriptors descriptors) {
        this.engine = engine;
        this.descriptors = descriptors;
        this.values = new HashMap();
    }

    public int hashCode() {
        int result = 31 + this.descriptors.hashCode();
        result = 31 * result + this.engine.hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OptionValues)) {
            return super.equals(obj);
        }
        if (this == obj) {
            return true;
        }
        OptionValues other = (OptionValues)obj;
        if (this.getDescriptors().equals(other.getDescriptors())) {
            if (!this.hasSetOptions() && !other.hasSetOptions()) {
                return true;
            }
            if (other instanceof OptionValuesImpl) {
                for (OptionKey<?> key : this.values.keySet()) {
                    if (!this.hasBeenSet(key) && !other.hasBeenSet(key) || this.get(key).equals(other.get(key))) continue;
                    return false;
                }
                for (OptionKey<?> key : ((OptionValuesImpl)other).values.keySet()) {
                    if (!this.hasBeenSet(key) && !other.hasBeenSet(key) || this.get(key).equals(other.get(key))) continue;
                    return false;
                }
                return true;
            }
            for (OptionDescriptor descriptor : this.getDescriptors()) {
                OptionKey key = descriptor.getKey();
                if (!this.hasBeenSet(key) && !other.hasBeenSet(key) || this.get(key).equals(other.get(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void putAll(Map<String, String> providedValues) {
        for (String key : providedValues.keySet()) {
            this.put(key, providedValues.get(key));
        }
    }

    public void put(String key, String value) {
        OptionDescriptor descriptor = this.findDescriptor(key);
        this.values.put(descriptor.getKey(), descriptor.getKey().getType().convert(value));
    }

    private OptionValuesImpl(OptionValuesImpl copy) {
        this.engine = copy.engine;
        this.values = new HashMap(copy.values);
        this.descriptors = copy.descriptors;
    }

    public boolean hasBeenSet(OptionKey<?> optionKey) {
        return this.values.containsKey(optionKey);
    }

    OptionValuesImpl copy() {
        return new OptionValuesImpl(this);
    }

    public OptionDescriptors getDescriptors() {
        return this.descriptors;
    }

    public <T> T get(OptionKey<T> optionKey) {
        Object value = this.values.get(optionKey);
        if (value == null) {
            return (T)optionKey.getDefaultValue();
        }
        return (T)value;
    }

    public <T> void set(OptionKey<T> optionKey, T value) {
        optionKey.getType().validate(value);
        this.values.put(optionKey, value);
    }

    public boolean hasSetOptions() {
        return !this.values.isEmpty();
    }

    private OptionDescriptor findDescriptor(String key) {
        OptionDescriptor descriptor = this.descriptors.get(key);
        if (descriptor == null) {
            throw this.failNotFound(key);
        }
        return descriptor;
    }

    private RuntimeException failNotFound(String key) {
        OptionDescriptors allOptions;
        Exception errorOptions = null;
        try {
            allOptions = this.engine == null ? this.descriptors : this.engine.getAllOptions();
        }
        catch (Exception e) {
            errorOptions = e;
            allOptions = this.descriptors;
        }
        RuntimeException error = OptionValuesImpl.failNotFound(allOptions, key);
        if (errorOptions != null) {
            error.addSuppressed(errorOptions);
        }
        throw error;
    }

    static RuntimeException failNotFound(OptionDescriptors allOptions, String key) {
        List<OptionDescriptor> matches = OptionValuesImpl.fuzzyMatch(allOptions, key);
        Formatter msg = new Formatter();
        msg.format("Could not find option with name %s.", key);
        Iterator iterator = matches.iterator();
        if (iterator.hasNext()) {
            msg.format("%nDid you mean one of the following?", new Object[0]);
            for (OptionDescriptor match : matches) {
                msg.format("%n    %s=<%s>", match.getName(), match.getKey().getType().getName());
            }
        }
        throw new IllegalArgumentException(msg.toString());
    }

    static List<OptionDescriptor> fuzzyMatch(OptionDescriptors descriptors, String optionKey) {
        ArrayList<OptionDescriptor> matches = new ArrayList<OptionDescriptor>();
        for (OptionDescriptor option : descriptors) {
            float score = OptionValuesImpl.stringSimiliarity(option.getName(), optionKey);
            if (!(score >= 0.7f)) continue;
            matches.add(option);
        }
        return matches;
    }

    private static float stringSimiliarity(String str1, String str2) {
        int hit = 0;
        block0: for (int i = 0; i < str1.length() - 1; ++i) {
            for (int j = 0; j < str2.length() - 1; ++j) {
                if (str1.charAt(i) != str2.charAt(j) || str1.charAt(i + 1) != str2.charAt(j + 1)) continue;
                ++hit;
                continue block0;
            }
        }
        return 2.0f * (float)hit / (float)(str1.length() + str2.length());
    }
}

