/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.HostObjectMR;
import com.oracle.truffle.polyglot.HostObjectMRForeignFactory;
import java.util.List;

final class HostObjectMRForeign
implements ForeignAccess.StandardFactory,
ForeignAccess.Factory {
    public static final ForeignAccess ACCESS = ForeignAccess.create(new HostObjectMRForeign(), null);

    @Deprecated
    public static ForeignAccess createAccess() {
        return ForeignAccess.create(new HostObjectMRForeign(), null);
    }

    private HostObjectMRForeign() {
    }

    @Override
    public boolean canHandle(TruffleObject obj) {
        return HostObject.isInstance(obj);
    }

    @Override
    public CallTarget accessIsNull() {
        return Truffle.getRuntime().createCallTarget(NullCheckSubNode.createRoot());
    }

    @Override
    public CallTarget accessIsExecutable() {
        return Truffle.getRuntime().createCallTarget(IsExecutableObjectSubNode.createRoot());
    }

    @Override
    public CallTarget accessIsInstantiable() {
        return Truffle.getRuntime().createCallTarget(IsInstantiableObjectSubNode.createRoot());
    }

    @Override
    public CallTarget accessIsBoxed() {
        return Truffle.getRuntime().createCallTarget(BoxedCheckSubNode.createRoot());
    }

    @Override
    public CallTarget accessHasKeys() {
        return Truffle.getRuntime().createCallTarget(HasKeysSubNode.createRoot());
    }

    @Override
    public CallTarget accessHasSize() {
        return Truffle.getRuntime().createCallTarget(ArrayHasSizeSubNode.createRoot());
    }

    @Override
    public CallTarget accessGetSize() {
        return Truffle.getRuntime().createCallTarget(ArrayGetSizeSubNode.createRoot());
    }

    @Override
    public CallTarget accessUnbox() {
        return Truffle.getRuntime().createCallTarget(UnboxSubNode.createRoot());
    }

    @Override
    public CallTarget accessRead() {
        return Truffle.getRuntime().createCallTarget(ReadSubNode.createRoot());
    }

    @Override
    public CallTarget accessWrite() {
        return Truffle.getRuntime().createCallTarget(WriteSubNode.createRoot());
    }

    @Override
    public CallTarget accessRemove() {
        return Truffle.getRuntime().createCallTarget(RemoveSubNode.createRoot());
    }

    @Override
    public CallTarget accessExecute(int argumentsLength) {
        return Truffle.getRuntime().createCallTarget(ExecuteObjectSubNode.createRoot());
    }

    @Override
    public CallTarget accessInvoke(int argumentsLength) {
        return Truffle.getRuntime().createCallTarget(InvokeSubNode.createRoot());
    }

    @Override
    public CallTarget accessNew(int argumentsLength) {
        return Truffle.getRuntime().createCallTarget(NewSubNode.createRoot());
    }

    @Override
    public CallTarget accessKeyInfo() {
        return Truffle.getRuntime().createCallTarget(KeyInfoSubNode.createRoot());
    }

    @Override
    public CallTarget accessKeys() {
        return Truffle.getRuntime().createCallTarget(KeysSubNode.createRoot());
    }

    @Override
    public CallTarget accessIsPointer() {
        return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }

    @Override
    public CallTarget accessAsPointer() {
        return null;
    }

    @Override
    public CallTarget accessToNative() {
        return null;
    }

    @Override
    public CallTarget accessMessage(Message unknown) {
        return null;
    }

    static abstract class HasKeysSubNode
    extends HostObjectMR.HasKeysNode {
        HasKeysSubNode() {
        }

        public abstract Object executeWithTarget(VirtualFrame var1, Object var2);

        @Specialization
        protected Object accessWithTarget(HostObject receiver) {
            return this.access(receiver);
        }

        public static RootNode createRoot() {
            return new HAS_KEYSRootNode();
        }

        private static final class HAS_KEYSRootNode
        extends RootNode {
            @Node.Child
            private HasKeysSubNode node = HostObjectMRForeignFactory.HasKeysSubNodeGen.create();

            protected HAS_KEYSRootNode() {
                super(null);
            }

            @Override
            public String getName() {
                return "Interop::HAS_KEYS::" + HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                TruffleObject receiver = ForeignAccess.getReceiver(frame);
                try {
                    return this.node.executeWithTarget(frame, receiver);
                }
                catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof HasKeysSubNode) {
                        throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    }
                    throw e;
                }
            }
        }
    }

    static abstract class KeyInfoSubNode
    extends HostObjectMR.KeyInfoNode {
        KeyInfoSubNode() {
        }

        public abstract Object executeWithTarget(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        protected Object accessWithTarget(HostObject receiver, int index) {
            return this.access(receiver, index);
        }

        @Specialization
        protected Object accessWithTarget(HostObject receiver, Number index) {
            return this.access(receiver, index);
        }

        @Specialization
        protected Object accessWithTarget(HostObject receiver, String name) {
            return this.access(receiver, name);
        }

        public static RootNode createRoot() {
            return new KEY_INFORootNode();
        }

        private static final class KEY_INFORootNode
        extends RootNode {
            @Node.Child
            private KeyInfoSubNode node = HostObjectMRForeignFactory.KeyInfoSubNodeGen.create();

            protected KEY_INFORootNode() {
                super(null);
            }

            @Override
            public String getName() {
                return "Interop::KEY_INFO::" + HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                TruffleObject receiver = ForeignAccess.getReceiver(frame);
                Object identifier = ForeignAccess.getArguments(frame).get(0);
                try {
                    return this.node.executeWithTarget(frame, receiver, identifier);
                }
                catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof KeyInfoSubNode) {
                        throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    }
                    throw e;
                }
            }
        }
    }

    static abstract class RemoveSubNode
    extends HostObjectMR.RemoveNode {
        RemoveSubNode() {
        }

        public abstract Object executeWithTarget(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        protected Object accessWithTarget(HostObject receiver, Number index) {
            return this.access(receiver, index);
        }

        @Specialization
        protected Object accessWithTarget(HostObject receiver, String name) {
            return this.access(receiver, name);
        }

        public static RootNode createRoot() {
            return new REMOVERootNode();
        }

        private static final class REMOVERootNode
        extends RootNode {
            @Node.Child
            private RemoveSubNode node = HostObjectMRForeignFactory.RemoveSubNodeGen.create();

            protected REMOVERootNode() {
                super(null);
            }

            @Override
            public String getName() {
                return "Interop::REMOVE::" + HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                TruffleObject receiver = ForeignAccess.getReceiver(frame);
                Object identifier = ForeignAccess.getArguments(frame).get(0);
                try {
                    return this.node.executeWithTarget(frame, receiver, identifier);
                }
                catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof RemoveSubNode) {
                        throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    }
                    throw e;
                }
            }
        }
    }

    static abstract class IsInstantiableObjectSubNode
    extends HostObjectMR.IsInstantiableObjectNode {
        IsInstantiableObjectSubNode() {
        }

        public abstract Object executeWithTarget(VirtualFrame var1, Object var2);

        @Specialization
        protected Object accessWithTarget(HostObject receiver) {
            return this.access(receiver);
        }

        public static RootNode createRoot() {
            return new IS_INSTANTIABLERootNode();
        }

        private static final class IS_INSTANTIABLERootNode
        extends RootNode {
            @Node.Child
            private IsInstantiableObjectSubNode node = HostObjectMRForeignFactory.IsInstantiableObjectSubNodeGen.create();

            protected IS_INSTANTIABLERootNode() {
                super(null);
            }

            @Override
            public String getName() {
                return "Interop::IS_INSTANTIABLE::" + HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                TruffleObject receiver = ForeignAccess.getReceiver(frame);
                try {
                    return this.node.executeWithTarget(frame, receiver);
                }
                catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof IsInstantiableObjectSubNode) {
                        throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    }
                    throw e;
                }
            }
        }
    }

    static abstract class ArrayHasSizeSubNode
    extends HostObjectMR.ArrayHasSizeNode {
        ArrayHasSizeSubNode() {
        }

        public abstract Object executeWithTarget(VirtualFrame var1, Object var2);

        @Specialization
        protected Object accessWithTarget(HostObject receiver) {
            return this.access(receiver);
        }

        public static RootNode createRoot() {
            return new HAS_SIZERootNode();
        }

        private static final class HAS_SIZERootNode
        extends RootNode {
            @Node.Child
            private ArrayHasSizeSubNode node = HostObjectMRForeignFactory.ArrayHasSizeSubNodeGen.create();

            protected HAS_SIZERootNode() {
                super(null);
            }

            @Override
            public String getName() {
                return "Interop::HAS_SIZE::" + HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                TruffleObject receiver = ForeignAccess.getReceiver(frame);
                try {
                    return this.node.executeWithTarget(frame, receiver);
                }
                catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ArrayHasSizeSubNode) {
                        throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    }
                    throw e;
                }
            }
        }
    }

    static abstract class ArrayGetSizeSubNode
    extends HostObjectMR.ArrayGetSizeNode {
        ArrayGetSizeSubNode() {
        }

        public abstract Object executeWithTarget(VirtualFrame var1, Object var2);

        @Specialization
        protected Object accessWithTarget(HostObject receiver) {
            return this.access(receiver);
        }

        public static RootNode createRoot() {
            return new GET_SIZERootNode();
        }

        private static final class GET_SIZERootNode
        extends RootNode {
            @Node.Child
            private ArrayGetSizeSubNode node = HostObjectMRForeignFactory.ArrayGetSizeSubNodeGen.create();

            protected GET_SIZERootNode() {
                super(null);
            }

            @Override
            public String getName() {
                return "Interop::GET_SIZE::" + HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                TruffleObject receiver = ForeignAccess.getReceiver(frame);
                try {
                    return this.node.executeWithTarget(frame, receiver);
                }
                catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ArrayGetSizeSubNode) {
                        throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    }
                    throw e;
                }
            }
        }
    }

    static abstract class IsExecutableObjectSubNode
    extends HostObjectMR.IsExecutableObjectNode {
        IsExecutableObjectSubNode() {
        }

        public abstract Object executeWithTarget(VirtualFrame var1, Object var2);

        @Specialization
        protected Object accessWithTarget(HostObject receiver) {
            return this.access(receiver);
        }

        public static RootNode createRoot() {
            return new IS_EXECUTABLERootNode();
        }

        private static final class IS_EXECUTABLERootNode
        extends RootNode {
            @Node.Child
            private IsExecutableObjectSubNode node = HostObjectMRForeignFactory.IsExecutableObjectSubNodeGen.create();

            protected IS_EXECUTABLERootNode() {
                super(null);
            }

            @Override
            public String getName() {
                return "Interop::IS_EXECUTABLE::" + HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                TruffleObject receiver = ForeignAccess.getReceiver(frame);
                try {
                    return this.node.executeWithTarget(frame, receiver);
                }
                catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof IsExecutableObjectSubNode) {
                        throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    }
                    throw e;
                }
            }
        }
    }

    static abstract class BoxedCheckSubNode
    extends HostObjectMR.BoxedCheckNode {
        BoxedCheckSubNode() {
        }

        public abstract Object executeWithTarget(VirtualFrame var1, Object var2);

        @Specialization
        protected Object accessWithTarget(HostObject object) {
            return this.access(object);
        }

        public static RootNode createRoot() {
            return new IS_BOXEDRootNode();
        }

        private static final class IS_BOXEDRootNode
        extends RootNode {
            @Node.Child
            private BoxedCheckSubNode node = HostObjectMRForeignFactory.BoxedCheckSubNodeGen.create();

            protected IS_BOXEDRootNode() {
                super(null);
            }

            @Override
            public String getName() {
                return "Interop::IS_BOXED::" + HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                TruffleObject receiver = ForeignAccess.getReceiver(frame);
                try {
                    return this.node.executeWithTarget(frame, receiver);
                }
                catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof BoxedCheckSubNode) {
                        throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    }
                    throw e;
                }
            }
        }
    }

    static abstract class UnboxSubNode
    extends HostObjectMR.UnboxNode {
        UnboxSubNode() {
        }

        public abstract Object executeWithTarget(VirtualFrame var1, Object var2);

        @Specialization
        protected Object accessWithTarget(HostObject object) {
            return this.access(object);
        }

        public static RootNode createRoot() {
            return new UNBOXRootNode();
        }

        private static final class UNBOXRootNode
        extends RootNode {
            @Node.Child
            private UnboxSubNode node = HostObjectMRForeignFactory.UnboxSubNodeGen.create();

            protected UNBOXRootNode() {
                super(null);
            }

            @Override
            public String getName() {
                return "Interop::UNBOX::" + HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                TruffleObject receiver = ForeignAccess.getReceiver(frame);
                try {
                    return this.node.executeWithTarget(frame, receiver);
                }
                catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof UnboxSubNode) {
                        throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    }
                    throw e;
                }
            }
        }
    }

    static abstract class NullCheckSubNode
    extends HostObjectMR.NullCheckNode {
        NullCheckSubNode() {
        }

        public abstract Object executeWithTarget(VirtualFrame var1, Object var2);

        @Specialization
        protected Object accessWithTarget(HostObject object) {
            return this.access(object);
        }

        public static RootNode createRoot() {
            return new IS_NULLRootNode();
        }

        private static final class IS_NULLRootNode
        extends RootNode {
            @Node.Child
            private NullCheckSubNode node = HostObjectMRForeignFactory.NullCheckSubNodeGen.create();

            protected IS_NULLRootNode() {
                super(null);
            }

            @Override
            public String getName() {
                return "Interop::IS_NULL::" + HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                TruffleObject receiver = ForeignAccess.getReceiver(frame);
                try {
                    return this.node.executeWithTarget(frame, receiver);
                }
                catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof NullCheckSubNode) {
                        throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    }
                    throw e;
                }
            }
        }
    }

    static abstract class KeysSubNode
    extends HostObjectMR.KeysNode {
        KeysSubNode() {
        }

        public abstract Object executeWithTarget(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        protected Object accessWithTarget(HostObject receiver, boolean includeInternal) {
            return this.access(receiver, includeInternal);
        }

        public static RootNode createRoot() {
            return new KEYSRootNode();
        }

        private static final class KEYSRootNode
        extends RootNode {
            @Node.Child
            private KeysSubNode node = HostObjectMRForeignFactory.KeysSubNodeGen.create();

            protected KEYSRootNode() {
                super(null);
            }

            @Override
            public String getName() {
                return "Interop::KEYS::" + HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                TruffleObject receiver = ForeignAccess.getReceiver(frame);
                List<Object> arguments = ForeignAccess.getArguments(frame);
                Object internal = arguments.isEmpty() ? Boolean.valueOf(false) : arguments.get(0);
                try {
                    return this.node.executeWithTarget(frame, receiver, internal);
                }
                catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof KeysSubNode) {
                        throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    }
                    throw e;
                }
            }
        }
    }

    static abstract class ReadSubNode
    extends HostObjectMR.ReadNode {
        ReadSubNode() {
        }

        public abstract Object executeWithTarget(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        protected Object accessWithTarget(HostObject object, Number index) {
            return this.access(object, index);
        }

        @Specialization
        protected Object accessWithTarget(HostObject object, String name) {
            return this.access(object, name);
        }

        public static RootNode createRoot() {
            return new READRootNode();
        }

        private static final class READRootNode
        extends RootNode {
            @Node.Child
            private ReadSubNode node = HostObjectMRForeignFactory.ReadSubNodeGen.create();

            protected READRootNode() {
                super(null);
            }

            @Override
            public String getName() {
                return "Interop::READ::" + HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                TruffleObject receiver = ForeignAccess.getReceiver(frame);
                Object identifier = ForeignAccess.getArguments(frame).get(0);
                try {
                    return this.node.executeWithTarget(frame, receiver, identifier);
                }
                catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ReadSubNode) {
                        throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    }
                    throw e;
                }
            }
        }
    }

    static abstract class InvokeSubNode
    extends HostObjectMR.InvokeNode {
        InvokeSubNode() {
        }

        public abstract Object executeWithTarget(VirtualFrame var1, Object var2, Object var3, Object var4);

        @Specialization
        protected Object accessWithTarget(HostObject object, String name, Object[] args) {
            return this.access(object, name, args);
        }

        public static RootNode createRoot() {
            return new INVOKERootNode();
        }

        private static final class INVOKERootNode
        extends RootNode {
            @Node.Child
            private InvokeSubNode node = HostObjectMRForeignFactory.InvokeSubNodeGen.create();

            protected INVOKERootNode() {
                super(null);
            }

            @Override
            public String getName() {
                return "Interop::INVOKE::" + HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                try {
                    TruffleObject receiver = ForeignAccess.getReceiver(frame);
                    List<Object> arguments = ForeignAccess.getArguments(frame);
                    Object identifier = arguments.get(0);
                    Object[] args = new Object[arguments.size() - 1];
                    for (int i = 0; i < arguments.size() - 1; ++i) {
                        args[i] = arguments.get(i + 1);
                    }
                    return this.node.executeWithTarget(frame, receiver, identifier, args);
                }
                catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof InvokeSubNode) {
                        throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    }
                    throw e;
                }
            }
        }
    }

    static abstract class NewSubNode
    extends HostObjectMR.NewNode {
        NewSubNode() {
        }

        public abstract Object executeWithTarget(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        protected Object accessWithTarget(HostObject receiver, Object[] args) {
            return this.access(receiver, args);
        }

        public static RootNode createRoot() {
            return new NEWRootNode();
        }

        private static final class NEWRootNode
        extends RootNode {
            @Node.Child
            private NewSubNode node = HostObjectMRForeignFactory.NewSubNodeGen.create();

            protected NEWRootNode() {
                super(null);
            }

            @Override
            public String getName() {
                return "Interop::NEW::" + HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                try {
                    TruffleObject receiver = ForeignAccess.getReceiver(frame);
                    List<Object> arguments = ForeignAccess.getArguments(frame);
                    Object[] args = new Object[arguments.size()];
                    for (int i = 0; i < arguments.size(); ++i) {
                        args[i] = arguments.get(i);
                    }
                    return this.node.executeWithTarget(frame, receiver, args);
                }
                catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof NewSubNode) {
                        throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    }
                    throw e;
                }
            }
        }
    }

    static abstract class WriteSubNode
    extends HostObjectMR.WriteNode {
        WriteSubNode() {
        }

        public abstract Object executeWithTarget(VirtualFrame var1, Object var2, Object var3, Object var4);

        @Specialization
        protected Object accessWithTarget(HostObject receiver, Number index, Object value) {
            return this.access(receiver, index, value);
        }

        @Specialization
        protected Object accessWithTarget(HostObject receiver, String name, Object value) {
            return this.access(receiver, name, value);
        }

        public static RootNode createRoot() {
            return new WRITERootNode();
        }

        private static final class WRITERootNode
        extends RootNode {
            @Node.Child
            private WriteSubNode node = HostObjectMRForeignFactory.WriteSubNodeGen.create();

            protected WRITERootNode() {
                super(null);
            }

            @Override
            public String getName() {
                return "Interop::WRITE::" + HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                TruffleObject receiver = ForeignAccess.getReceiver(frame);
                Object identifier = ForeignAccess.getArguments(frame).get(0);
                Object value = ForeignAccess.getArguments(frame).get(1);
                try {
                    return this.node.executeWithTarget(frame, receiver, identifier, value);
                }
                catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof WriteSubNode) {
                        throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    }
                    throw e;
                }
            }
        }
    }

    static abstract class ExecuteObjectSubNode
    extends HostObjectMR.ExecuteObjectNode {
        ExecuteObjectSubNode() {
        }

        public abstract Object executeWithTarget(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        protected Object accessWithTarget(HostObject receiver, Object[] args) {
            return this.access(receiver, args);
        }

        public static RootNode createRoot() {
            return new EXECUTERootNode();
        }

        private static final class EXECUTERootNode
        extends RootNode {
            @Node.Child
            private ExecuteObjectSubNode node = HostObjectMRForeignFactory.ExecuteObjectSubNodeGen.create();

            protected EXECUTERootNode() {
                super(null);
            }

            @Override
            public String getName() {
                return "Interop::EXECUTE::" + HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                try {
                    TruffleObject receiver = ForeignAccess.getReceiver(frame);
                    List<Object> arguments = ForeignAccess.getArguments(frame);
                    Object[] args = new Object[arguments.size()];
                    for (int i = 0; i < arguments.size(); ++i) {
                        args[i] = arguments.get(i);
                    }
                    return this.node.executeWithTarget(frame, receiver, args);
                }
                catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ExecuteObjectSubNode) {
                        throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    }
                    throw e;
                }
            }
        }
    }
}

