/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.polyglot.PolyglotArrayIndexOutOfBoundsException;
import com.oracle.truffle.polyglot.PolyglotClassCastException;
import com.oracle.truffle.polyglot.PolyglotIllegalArgumentException;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotNullPointerException;
import com.oracle.truffle.polyglot.PolyglotUnsupportedException;
import com.oracle.truffle.polyglot.PolyglotValue;
import java.lang.reflect.Type;
import java.util.Arrays;

class HostInteropErrors {
    HostInteropErrors() {
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException nullCoercion(PolyglotLanguageContext languageContext, TruffleObject nullValue, Type targetType) {
        return HostInteropErrors.newNullPointerException(String.format("Cannot convert null value %s to Java type '%s'.", HostInteropErrors.getValueInfo(languageContext, nullValue), targetType.getTypeName()));
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException cannotConvert(PolyglotLanguageContext languageContext, Object value, Type targetType, String reason) {
        return HostInteropErrors.newClassCastException(String.format("Cannot convert %s to Java type '%s': %s", HostInteropErrors.getValueInfo(languageContext, value), targetType.getTypeName(), reason));
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException invalidListIndex(PolyglotLanguageContext context, Object receiver, Type componentType, int index) {
        String message = String.format("Invalid index %s for List<%s> %s.", index, HostInteropErrors.formatComponentType(componentType), HostInteropErrors.getValueInfo(context, receiver));
        throw HostInteropErrors.newArrayIndexOutOfBounds(message);
    }

    private static Object formatComponentType(Type componentType) {
        return componentType == null || componentType == Object.class ? "Object" : componentType.getTypeName();
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException listUnsupported(PolyglotLanguageContext context, Object receiver, Type componentType, String operation) {
        String message = String.format("Unsupported operation %s for List<%s> %s.", operation, HostInteropErrors.formatComponentType(componentType), HostInteropErrors.getValueInfo(context, receiver));
        throw HostInteropErrors.newUnsupportedOperationException(message);
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException mapUnsupported(PolyglotLanguageContext context, Object receiver, Type keyType, Type valueType, String operation) {
        String message = String.format("Unsupported operation %s for Map<%s, %s> %s.", operation, HostInteropErrors.formatComponentType(keyType), HostInteropErrors.formatComponentType(valueType), HostInteropErrors.getValueInfo(context, receiver));
        throw HostInteropErrors.newUnsupportedOperationException(message);
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException invalidMapValue(PolyglotLanguageContext context, Object receiver, Type keyType, Type valueType, Object identifier, Object value) {
        throw HostInteropErrors.newClassCastException(String.format("Invalid value %s for Map<%s, %s> %s and identifier '%s'.", HostInteropErrors.getValueInfo(context, value), HostInteropErrors.formatComponentType(keyType), HostInteropErrors.formatComponentType(valueType), HostInteropErrors.getValueInfo(context, receiver), identifier));
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException invalidMapIdentifier(PolyglotLanguageContext context, Object receiver, Type keyType, Type valueType, Object identifier) {
        if (identifier instanceof Number || identifier instanceof String) {
            throw HostInteropErrors.newIllegalArgumentException(String.format("Invalid or unmodifiable value for identifier '%s' for Map<%s, %s> %s.", identifier, HostInteropErrors.formatComponentType(keyType), HostInteropErrors.formatComponentType(valueType), HostInteropErrors.getValueInfo(context, receiver)));
        }
        throw HostInteropErrors.newIllegalArgumentException(String.format("Illegal identifier type '%s' for Map<%s, %s> %s.", identifier == null ? "null" : identifier.getClass().getTypeName(), HostInteropErrors.formatComponentType(keyType), HostInteropErrors.formatComponentType(valueType), HostInteropErrors.getValueInfo(context, receiver)));
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException invalidListValue(PolyglotLanguageContext context, Object receiver, Type componentType, int identifier, Object value) {
        throw HostInteropErrors.newClassCastException(String.format("Invalid value %s for List<%s> %s and index %s.", HostInteropErrors.getValueInfo(context, value), HostInteropErrors.formatComponentType(componentType), HostInteropErrors.getValueInfo(context, receiver), identifier));
    }

    static RuntimeException invalidExecuteArgumentType(PolyglotLanguageContext context, Object receiver, Object[] arguments) {
        String[] formattedArgs = HostInteropErrors.formatArgs(context, arguments);
        String message = String.format("Invalid argument when executing %s with arguments %s.", HostInteropErrors.getValueInfo(context, receiver), Arrays.asList(formattedArgs));
        throw HostInteropErrors.newIllegalArgumentException(message);
    }

    static RuntimeException invalidInstantiateArgumentType(PolyglotLanguageContext context, Object receiver, Object[] arguments) {
        String[] formattedArgs = HostInteropErrors.formatArgs(context, arguments);
        String message = String.format("Invalid argument when instantiating %s with arguments %s.", HostInteropErrors.getValueInfo(context, receiver), Arrays.asList(formattedArgs));
        throw HostInteropErrors.newIllegalArgumentException(message);
    }

    static RuntimeException invalidInstantiateArity(PolyglotLanguageContext context, Object receiver, Object[] arguments, int expected, int actual) {
        String[] formattedArgs = HostInteropErrors.formatArgs(context, arguments);
        String message = String.format("Invalid argument count when instantiating %s with arguments %s. Expected %s argument(s) but got %s.", HostInteropErrors.getValueInfo(context, receiver), Arrays.asList(formattedArgs), expected, actual);
        throw HostInteropErrors.newIllegalArgumentException(message);
    }

    static RuntimeException invalidExecuteArity(PolyglotLanguageContext context, Object receiver, Object[] arguments, int expected, int actual) {
        String[] formattedArgs = HostInteropErrors.formatArgs(context, arguments);
        String message = String.format("Invalid argument count when executing %s with arguments %s. Expected %s argument(s) but got %s.", HostInteropErrors.getValueInfo(context, receiver), Arrays.asList(formattedArgs), expected, actual);
        throw HostInteropErrors.newIllegalArgumentException(message);
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException invokeUnsupported(PolyglotLanguageContext context, Object receiver, String identifier) {
        String message = String.format("Unsupported operation identifier '%s' and  object %s. Identifier is not executable or instantiable.", identifier, HostInteropErrors.getValueInfo(context, receiver));
        throw HostInteropErrors.newUnsupportedOperationException(message);
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException executeUnsupported(PolyglotLanguageContext context, Object receiver) {
        String message = String.format("Unsupported operation for object %s. Object is not executable or instantiable.", HostInteropErrors.getValueInfo(context, receiver));
        throw HostInteropErrors.newUnsupportedOperationException(message);
    }

    private static String[] formatArgs(PolyglotLanguageContext context, Object[] arguments) {
        String[] formattedArgs = new String[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            formattedArgs[i] = HostInteropErrors.getValueInfo(context, arguments[i]);
        }
        return formattedArgs;
    }

    static String getValueInfo(PolyglotLanguageContext languageContext, Object value) {
        return PolyglotValue.getValueInfo(languageContext, value);
    }

    private static RuntimeException newNullPointerException(String message) {
        CompilerDirectives.transferToInterpreter();
        throw new PolyglotNullPointerException(message);
    }

    private static RuntimeException newUnsupportedOperationException(String message) {
        CompilerDirectives.transferToInterpreter();
        throw new PolyglotUnsupportedException(message);
    }

    private static RuntimeException newClassCastException(String message) {
        CompilerDirectives.transferToInterpreter();
        throw new PolyglotClassCastException(message);
    }

    static final RuntimeException newIllegalArgumentException(String message) {
        CompilerDirectives.transferToInterpreter();
        throw new PolyglotIllegalArgumentException(message);
    }

    private static RuntimeException newArrayIndexOutOfBounds(String message) {
        CompilerDirectives.transferToInterpreter();
        throw new PolyglotArrayIndexOutOfBoundsException(message);
    }
}

