/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.polyglot.HostInteropReflect;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

abstract class HostFieldDesc {
    private final Class<?> type;
    private final Type genericType;

    private HostFieldDesc(Class<?> type, Type genericType) {
        this.type = type;
        this.genericType = genericType;
    }

    public final Class<?> getType() {
        return this.type;
    }

    public final Type getGenericType() {
        return this.genericType;
    }

    public abstract Object get(Object var1);

    public abstract void set(Object var1, Object var2);

    static HostFieldDesc unreflect(Field reflectionField) {
        assert (HostFieldDesc.isAccessible(reflectionField));
        if (TruffleOptions.AOT) {
            return new ReflectImpl(reflectionField);
        }
        return new MHImpl(reflectionField);
    }

    static boolean isAccessible(Field field) {
        return Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers());
    }

    private static final class MHImpl
    extends HostFieldDesc {
        private final Field field;
        @CompilerDirectives.CompilationFinal
        private MethodHandle getHandle;
        @CompilerDirectives.CompilationFinal
        private MethodHandle setHandle;

        MHImpl(Field field) {
            super(field.getType(), field.getGenericType());
            this.field = field;
        }

        @Override
        public Object get(Object receiver) {
            if (this.getHandle == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getHandle = this.makeGetMethodHandle();
            }
            try {
                return MHImpl.invokeGetHandle(this.getHandle, receiver);
            }
            catch (Exception e) {
                throw UnsupportedTypeException.raise(e, HostInteropReflect.EMPTY);
            }
            catch (Throwable e) {
                throw HostInteropReflect.rethrow(e);
            }
        }

        @Override
        public void set(Object receiver, Object value) {
            if (this.setHandle == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setHandle = this.makeSetMethodHandle();
            }
            try {
                MHImpl.invokeSetHandle(this.setHandle, receiver, value);
            }
            catch (Exception e) {
                throw UnsupportedTypeException.raise(e, new Object[]{value});
            }
            catch (Throwable e) {
                throw HostInteropReflect.rethrow(e);
            }
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static Object invokeGetHandle(MethodHandle invokeHandle, Object receiver) throws Throwable {
            return invokeHandle.invokeExact(receiver);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static void invokeSetHandle(MethodHandle invokeHandle, Object receiver, Object value) throws Throwable {
            invokeHandle.invokeExact(receiver, value);
        }

        private MethodHandle makeGetMethodHandle() {
            try {
                if (Modifier.isStatic(this.field.getModifiers())) {
                    MethodHandle getter = MethodHandles.publicLookup().findStaticGetter(this.field.getDeclaringClass(), this.field.getName(), this.field.getType());
                    return MethodHandles.dropArguments(getter.asType(MethodType.methodType(Object.class)), 0, new Class[]{Object.class});
                }
                MethodHandle getter = MethodHandles.publicLookup().findGetter(this.field.getDeclaringClass(), this.field.getName(), this.field.getType());
                return getter.asType(MethodType.methodType(Object.class, Object.class));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalStateException(e);
            }
        }

        private MethodHandle makeSetMethodHandle() {
            try {
                if (Modifier.isStatic(this.field.getModifiers())) {
                    MethodHandle setter = MethodHandles.publicLookup().findStaticSetter(this.field.getDeclaringClass(), this.field.getName(), this.field.getType());
                    return MethodHandles.dropArguments(setter.asType(MethodType.methodType(Void.TYPE, Object.class)), 0, new Class[]{Object.class});
                }
                MethodHandle setter = MethodHandles.publicLookup().findSetter(this.field.getDeclaringClass(), this.field.getName(), this.field.getType());
                return setter.asType(MethodType.methodType(Void.TYPE, Object.class, Object.class));
            }
            catch (NoSuchFieldException e) {
                throw UnknownIdentifierException.raise(this.field.getName());
            }
            catch (IllegalAccessException e) {
                if (Modifier.isFinal(this.field.getModifiers())) {
                    throw UnknownIdentifierException.raise(this.field.getName());
                }
                throw new IllegalStateException(e);
            }
        }

        public String toString() {
            return "Field[" + this.field.toString() + "]";
        }
    }

    private static final class ReflectImpl
    extends HostFieldDesc {
        private final Field field;

        ReflectImpl(Field field) {
            super(field.getType(), field.getGenericType());
            this.field = field;
        }

        @Override
        public Object get(Object receiver) {
            try {
                return ReflectImpl.reflectGet(this.field, receiver);
            }
            catch (IllegalArgumentException e) {
                throw UnsupportedTypeException.raise(e, HostInteropReflect.EMPTY);
            }
            catch (IllegalAccessException e) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void set(Object receiver, Object value) {
            try {
                ReflectImpl.reflectSet(this.field, receiver, value);
            }
            catch (IllegalArgumentException e) {
                throw UnsupportedTypeException.raise(e, HostInteropReflect.EMPTY);
            }
            catch (IllegalAccessException e) {
                CompilerDirectives.transferToInterpreter();
                if (Modifier.isFinal(this.field.getModifiers())) {
                    throw UnknownIdentifierException.raise(this.field.getName());
                }
                throw new IllegalStateException(e);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static Object reflectGet(Field field, Object receiver) throws IllegalArgumentException, IllegalAccessException {
            return field.get(receiver);
        }

        @CompilerDirectives.TruffleBoundary
        private static void reflectSet(Field field, Object receiver, Object value) throws IllegalArgumentException, IllegalAccessException {
            field.set(receiver, value);
        }

        public String toString() {
            return "Field[" + this.field.toString() + "]";
        }
    }
}

