/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.polyglot.HostEntryRootNode;
import com.oracle.truffle.polyglot.HostInteropReflect;
import com.oracle.truffle.polyglot.PolyglotExecuteNode;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Objects;

class FunctionProxyNode
extends HostEntryRootNode<TruffleObject> {
    final Class<?> receiverClass;
    final Method method;
    @Node.Child
    private PolyglotExecuteNode executeNode;
    @CompilerDirectives.CompilationFinal
    private Class<?> returnClass;
    @CompilerDirectives.CompilationFinal
    private Type returnType;

    FunctionProxyNode(Class<?> receiverType, Method method) {
        this.receiverClass = receiverType;
        this.method = method;
    }

    @Override
    protected Class<? extends TruffleObject> getReceiverType() {
        return this.receiverClass;
    }

    @Override
    public final String getName() {
        return "FunctionalInterfaceProxy<" + this.receiverClass + ", " + this.method + ">";
    }

    @Override
    protected Object executeImpl(PolyglotLanguageContext languageContext, TruffleObject function, Object[] args, int offset) {
        if (this.executeNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.returnClass = HostInteropReflect.getMethodReturnType(this.method);
            this.returnType = HostInteropReflect.getMethodGenericReturnType(this.method);
            this.executeNode = this.insert(new PolyglotExecuteNode());
        }
        return this.executeNode.execute(languageContext, function, args[offset], this.returnClass, this.returnType);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.receiverClass);
        result = 31 * result + Objects.hashCode(this.method);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FunctionProxyNode)) {
            return false;
        }
        FunctionProxyNode other = (FunctionProxyNode)obj;
        return this.receiverClass == other.receiverClass && this.method.equals(other.method);
    }

    static CallTarget lookup(PolyglotLanguageContext languageContext, Class<?> receiverClass, Method method) {
        FunctionProxyNode node = new FunctionProxyNode(receiverClass, method);
        CallTarget target = FunctionProxyNode.lookupHostCodeCache(languageContext, node, CallTarget.class);
        if (target == null) {
            target = FunctionProxyNode.installHostCodeCache(languageContext, node, FunctionProxyNode.createTarget(node), CallTarget.class);
        }
        return target;
    }
}

