/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.polyglot.FunctionProxyNode;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

final class FunctionProxyHandler
implements InvocationHandler {
    final TruffleObject functionObj;
    final PolyglotLanguageContext languageContext;
    private final Method functionMethod;
    private final CallTarget target;

    FunctionProxyHandler(TruffleObject obj, Method functionMethod, PolyglotLanguageContext languageContext) {
        this.functionObj = obj;
        this.languageContext = languageContext;
        this.functionMethod = functionMethod;
        this.target = FunctionProxyNode.lookup(languageContext, obj.getClass(), functionMethod);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        CompilerAsserts.neverPartOfCompilation();
        if (method.equals(this.functionMethod)) {
            return this.target.call(this.languageContext, this.functionObj, this.spreadVarArgsArray(arguments));
        }
        return FunctionProxyHandler.invokeDefault(proxy, method, arguments);
    }

    private Object[] spreadVarArgsArray(Object[] arguments) {
        if (!this.functionMethod.isVarArgs()) {
            return arguments;
        }
        if (arguments.length == 1) {
            return (Object[])arguments[0];
        }
        int allButOne = arguments.length - 1;
        Object[] last = (Object[])arguments[allButOne];
        Object[] merge = new Object[allButOne + last.length];
        System.arraycopy(arguments, 0, merge, 0, allButOne);
        System.arraycopy(last, 0, merge, allButOne, last.length);
        return merge;
    }

    private static Object invokeDefault(Object proxy, Method method, Object[] arguments) throws Throwable {
        MethodHandle mh;
        if (method.getDeclaringClass() == Object.class) {
            switch (method.getName()) {
                case "equals": {
                    return proxy == arguments[0];
                }
                case "hashCode": {
                    return System.identityHashCode(proxy);
                }
                case "toString": {
                    return proxy.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(proxy));
                }
            }
            throw new UnsupportedOperationException(method.getName());
        }
        Class<?> declaringClass = method.getDeclaringClass();
        assert (declaringClass.isInterface()) : declaringClass;
        try {
            mh = MethodHandles.lookup().findSpecial(declaringClass, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), declaringClass);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(method.getName(), e);
        }
        return mh.bindTo(proxy).invokeWithArguments(arguments);
    }
}

