/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotThread;

final class ContextThreadLocal
extends ThreadLocal<Object> {
    private final Assumption singleThread = Truffle.getRuntime().createAssumption("constant context store");
    private PolyglotContextImpl firstContext;
    @CompilerDirectives.CompilationFinal
    private volatile Thread firstThread;

    ContextThreadLocal() {
    }

    @Override
    protected Object initialValue() {
        if (Thread.currentThread() == this.firstThread) {
            PolyglotContextImpl context = this.firstContext;
            this.firstContext = null;
            this.firstThread = null;
            return context;
        }
        return null;
    }

    public boolean isSet() {
        if (this.singleThread.isValid()) {
            boolean set = this.firstContext != null;
            return (TruffleOptions.AOT ? ContextThreadLocal.currentThread() : Thread.currentThread()) == this.firstThread && set;
        }
        return this.getTL() != null;
    }

    @Override
    public Object get() {
        Object context;
        if (this.singleThread.isValid()) {
            if ((TruffleOptions.AOT ? ContextThreadLocal.currentThread() : Thread.currentThread()) == this.firstThread) {
                context = this.firstContext;
            } else {
                CompilerDirectives.transferToInterpreter();
                context = this.getImplSlowPath();
            }
        } else {
            context = this.getTL();
        }
        return context;
    }

    @CompilerDirectives.TruffleBoundary
    static Thread currentThread() {
        return Thread.currentThread();
    }

    @Override
    public void set(Object value) {
        this.setReturnParent(value);
    }

    Object setReturnParent(Object value) {
        if (this.singleThread.isValid()) {
            Object prev;
            if ((TruffleOptions.AOT ? ContextThreadLocal.currentThread() : Thread.currentThread()) == this.firstThread) {
                prev = this.firstContext;
                this.firstContext = (PolyglotContextImpl)value;
            } else {
                CompilerDirectives.transferToInterpreter();
                prev = this.setReturnParentSlowPath(value);
            }
            return prev;
        }
        return this.setTLReturnParent(value);
    }

    private synchronized Object getImplSlowPath() {
        if (!this.singleThread.isValid()) {
            return this.getTL();
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private Object getTL() {
        Thread current = Thread.currentThread();
        if (current instanceof PolyglotThread) {
            PolyglotThread polyglotThread = (PolyglotThread)current;
            Object context = polyglotThread.context;
            if (context == null && this.firstThread == current) {
                context = polyglotThread.context = this.firstContext;
                this.firstContext = null;
                this.firstThread = null;
            }
            return context;
        }
        return super.get();
    }

    @CompilerDirectives.TruffleBoundary
    private Object setTLReturnParent(Object context) {
        Thread current = Thread.currentThread();
        if (current instanceof PolyglotThread) {
            PolyglotThread polyglotThread = (PolyglotThread)current;
            Object prev = polyglotThread.context;
            polyglotThread.context = context;
            return prev;
        }
        Object prev = super.get();
        super.set(context);
        return prev;
    }

    private synchronized Object setReturnParentSlowPath(Object context) {
        if (!this.singleThread.isValid()) {
            return this.setTLReturnParent(context);
        }
        Thread currentThread = Thread.currentThread();
        Thread storeThread = this.firstThread;
        PolyglotContextImpl prev = this.firstContext;
        if (currentThread == storeThread) {
            this.firstContext = (PolyglotContextImpl)context;
        } else if (storeThread == null) {
            this.firstThread = currentThread;
            this.firstContext = (PolyglotContextImpl)context;
        } else {
            this.singleThread.invalidate();
            return this.setTLReturnParent(context);
        }
        return prev;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

