/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.utilities;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JSONHelper {
    private static StringBuilder AstJsonDumpBuilder = new StringBuilder();
    static final DumpAccessor ACCESSOR = new DumpAccessor();

    @Deprecated
    public JSONHelper() {
    }

    @Deprecated
    public static void dumpNewChild(Node parentNode, Node childNode) {
        if (AstJsonDumpBuilder != null) {
            AstJsonDumpBuilder.append("{ \"action\": \"insertNode\", \"parentId\": \"" + JSONHelper.getID(parentNode) + "\", \"newId\": \"" + JSONHelper.getID(childNode) + "\" },\n");
        }
    }

    @Deprecated
    public static void dumpReplaceChild(Node oldNode, Node newNode, CharSequence reason) {
        if (AstJsonDumpBuilder != null) {
            AstJsonDumpBuilder.append("{ \"action\": \"replaceNode\", \"oldId\": \"" + JSONHelper.getID(oldNode) + "\", \"newId\": \"" + JSONHelper.getID(newNode) + "\", \"reason\": " + JSONHelper.quote(reason) + " },\n");
        }
    }

    @Deprecated
    public static void dumpNewNode(Node newNode) {
        if (AstJsonDumpBuilder != null) {
            TruffleLanguage clazz;
            String language = "";
            RootNode root = newNode.getRootNode();
            if (root != null && (clazz = root.getLanguage(TruffleLanguage.class)) != null) {
                language = clazz.getClass().getName();
            }
            AstJsonDumpBuilder.append("{ \"action\": \"createNode\", \"newId\": \"" + JSONHelper.getID(newNode) + "\", \"type\": \"" + JSONHelper.getType(newNode) + "\", \"description\": \"" + newNode.getDescription() + "\", \"language\": \"" + language + "\" },\n");
        }
    }

    @Deprecated
    public static String getResult() {
        return AstJsonDumpBuilder.toString();
    }

    private static String getID(Node newChild) {
        return String.valueOf(newChild.hashCode());
    }

    private static String getType(Node node) {
        return node.getClass().getSimpleName();
    }

    private static String quote(CharSequence value) {
        StringBuilder builder = new StringBuilder(value.length() + 2);
        builder.append('\"');
        block9: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    builder.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    builder.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    builder.append("\\b");
                    continue block9;
                }
                case '\f': {
                    builder.append("\\f");
                    continue block9;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block9;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block9;
                }
                case '\t': {
                    builder.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        builder.append("\\u00");
                        builder.append(Character.forDigit(c >> 4 & 0xF, 16));
                        builder.append(Character.forDigit(c & 0xF, 16));
                        continue block9;
                    }
                    builder.append(c);
                }
            }
        }
        builder.append('\"');
        return builder.toString();
    }

    @Deprecated
    public static void restart() {
        AstJsonDumpBuilder = new StringBuilder();
    }

    public static JSONObjectBuilder object() {
        return new JSONObjectBuilder();
    }

    public static JSONArrayBuilder array() {
        return new JSONArrayBuilder();
    }

    private static final class DumpAccessor
    extends Accessor {
        private static final Accessor.DumpSupport DUMP_SUPPORT = new Accessor.DumpSupport(){

            @Override
            public void dump(Node newNode, Node newChild, CharSequence reason) {
                if (reason != null) {
                    JSONHelper.dumpReplaceChild(newNode, newChild, reason);
                } else if (newChild != null) {
                    JSONHelper.dumpNewChild(newNode, newChild);
                } else {
                    JSONHelper.dumpNewNode(newNode);
                }
            }
        };

        private DumpAccessor() {
        }

        @Override
        protected Accessor.DumpSupport dumpSupport() {
            return DUMP_SUPPORT;
        }
    }

    public static final class JSONArrayBuilder
    extends JSONStringBuilder {
        private final List<Object> contents = new ArrayList<Object>();

        private JSONArrayBuilder() {
        }

        public JSONArrayBuilder add(String value) {
            this.contents.add(value);
            return this;
        }

        public JSONArrayBuilder add(Number value) {
            this.contents.add(value);
            return this;
        }

        public JSONArrayBuilder add(Boolean value) {
            this.contents.add(value);
            return this;
        }

        public JSONArrayBuilder add(JSONStringBuilder value) {
            this.contents.add(value);
            return this;
        }

        @Override
        protected void appendTo(StringBuilder sb) {
            sb.append("[");
            boolean comma = false;
            for (Object value : this.contents) {
                if (comma) {
                    sb.append(", ");
                }
                JSONArrayBuilder.appendValue(sb, value);
                comma = true;
            }
            sb.append("]");
        }
    }

    public static final class JSONObjectBuilder
    extends JSONStringBuilder {
        private final Map<String, Object> contents = new LinkedHashMap<String, Object>();

        private JSONObjectBuilder() {
        }

        public JSONObjectBuilder add(String key, String value) {
            this.contents.put(key, value);
            return this;
        }

        public JSONObjectBuilder add(String key, Number value) {
            this.contents.put(key, value);
            return this;
        }

        public JSONObjectBuilder add(String key, Boolean value) {
            this.contents.put(key, value);
            return this;
        }

        public JSONObjectBuilder add(String key, JSONStringBuilder value) {
            this.contents.put(key, value);
            return this;
        }

        @Override
        protected void appendTo(StringBuilder sb) {
            sb.append("{");
            boolean comma = false;
            for (Map.Entry<String, Object> entry : this.contents.entrySet()) {
                if (comma) {
                    sb.append(", ");
                }
                sb.append(JSONHelper.quote(entry.getKey()));
                sb.append(": ");
                JSONObjectBuilder.appendValue(sb, entry.getValue());
                comma = true;
            }
            sb.append("}");
        }
    }

    public static abstract class JSONStringBuilder {
        @Deprecated
        protected JSONStringBuilder() {
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendTo(sb);
            return sb.toString();
        }

        protected abstract void appendTo(StringBuilder var1);

        protected static void appendValue(StringBuilder sb, Object value) {
            if (value instanceof JSONStringBuilder) {
                ((JSONStringBuilder)value).appendTo(sb);
            } else if (value instanceof Integer || value instanceof Boolean || value == null) {
                sb.append(value);
            } else {
                sb.append(JSONHelper.quote(String.valueOf(value)));
            }
        }
    }
}

