/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.source.Source;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;

final class SourceAccessor
extends Accessor {
    static final SourceAccessor ACCESSOR = new SourceAccessor();

    protected SourceAccessor() {
    }

    @Override
    protected Accessor.SourceSupport sourceSupport() {
        return new SourceSupportImpl();
    }

    @Override
    protected Accessor.LanguageSupport languageSupport() {
        return super.languageSupport();
    }

    @Override
    protected Accessor.EngineSupport engineSupport() {
        return super.engineSupport();
    }

    static Collection<ClassLoader> allLoaders() {
        return ACCESSOR.loaders();
    }

    static byte[] readTruffleFile(File file) throws IOException {
        return ACCESSOR.languageSupport().truffleFileContent(file);
    }

    static boolean isTruffleFile(File file) {
        return ACCESSOR.languageSupport().checkTruffleFile(file);
    }

    static File asFile(TruffleFile file) {
        return ACCESSOR.languageSupport().asFile(file);
    }

    static final class SourceSupportImpl
    extends Accessor.SourceSupport {
        SourceSupportImpl() {
        }

        @Override
        public Source copySource(Source source) {
            return source.copy();
        }

        @Override
        public Object getSourceIdentifier(Source source) {
            return source.getSourceId();
        }

        @Override
        public org.graalvm.polyglot.Source getPolyglotSource(Source source) {
            return source.polyglotSource;
        }

        @Override
        public void setPolyglotSource(Source source, org.graalvm.polyglot.Source polyglotSource) {
            source.polyglotSource = polyglotSource;
        }

        @Override
        public String findMimeType(File file) throws IOException {
            return Source.findMimeType(file.toPath(), null);
        }

        @Override
        public String findMimeType(URL url) throws IOException {
            return Source.findMimeType(url);
        }

        @Override
        public Source.SourceBuilder newBuilder(String language, File origin) {
            return Source.newBuilder(language, origin);
        }

        @Override
        public boolean isLegacySource(Source source) {
            return source.isLegacy();
        }
    }
}

