/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerOptions;
import com.oracle.truffle.api.ExecutionContext;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.impl.DefaultCompilerOptions;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.concurrent.locks.ReentrantLock;

public abstract class RootNode
extends ExecutableNode {
    final Object sourceVM;
    private RootCallTarget callTarget;
    @CompilerDirectives.CompilationFinal
    private FrameDescriptor frameDescriptor;
    final ReentrantLock lock = new ReentrantLock();
    volatile byte instrumentationBits;

    protected RootNode(TruffleLanguage<?> language) {
        this(language, null);
    }

    protected RootNode(TruffleLanguage<?> language, FrameDescriptor frameDescriptor) {
        super(language);
        CompilerAsserts.neverPartOfCompilation();
        this.sourceVM = this.language != null ? Node.ACCESSOR.engineSupport().getVMFromLanguageObject(Node.ACCESSOR.languageSupport().getLanguageInfo(this.language).getEngineObject()) : RootNode.getCurrentVM();
        this.frameDescriptor = frameDescriptor == null ? new FrameDescriptor() : frameDescriptor;
    }

    private static Object getCurrentVM() {
        Accessor.EngineSupport engine = Node.ACCESSOR.engineSupport();
        if (engine != null) {
            return engine.getCurrentVM();
        }
        return null;
    }

    public final <C, T extends TruffleLanguage<C>> C getCurrentContext(Class<T> languageClass) {
        if (this.language == null) {
            return null;
        }
        return ((TruffleLanguage)this.getLanguage(languageClass)).getContextReference().get();
    }

    @Override
    public Node copy() {
        RootNode root = (RootNode)super.copy();
        root.frameDescriptor = this.frameDescriptor;
        return root;
    }

    public String getName() {
        return null;
    }

    public boolean isInternal() {
        if (this.getLanguageInfo() == null) {
            return true;
        }
        SourceSection sc = this.getSourceSection();
        if (sc != null) {
            return sc.getSource().isInternal();
        }
        return false;
    }

    public boolean isCaptureFramesForTrace() {
        return false;
    }

    public boolean isCloningAllowed() {
        return false;
    }

    protected boolean isCloneUninitializedSupported() {
        return false;
    }

    protected RootNode cloneUninitialized() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final void reportLoopCount(int iterations) {
        LoopNode.reportLoopCount(this, iterations);
    }

    @Override
    public abstract Object execute(VirtualFrame var1);

    public final RootCallTarget getCallTarget() {
        return this.callTarget;
    }

    public final FrameDescriptor getFrameDescriptor() {
        return this.frameDescriptor;
    }

    @Deprecated
    public final void setCallTarget(RootCallTarget callTarget) {
        this.callTarget = callTarget;
    }

    @Deprecated
    public ExecutionContext getExecutionContext() {
        return null;
    }

    public CompilerOptions getCompilerOptions() {
        ExecutionContext context = this.getExecutionContext();
        if (context == null) {
            return DefaultCompilerOptions.INSTANCE;
        }
        return context.getCompilerOptions();
    }

    protected boolean isInstrumentable() {
        return true;
    }

    public static RootNode createConstantNode(Object constant) {
        return new Constant(constant);
    }

    private static final class Constant
    extends RootNode {
        private final Object value;

        Constant(Object value) {
            super(null);
            this.value = value;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.value;
        }
    }
}

