/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;

public abstract class ExecutableNode
extends Node {
    final TruffleLanguage<?> language;

    protected ExecutableNode(TruffleLanguage<?> language) {
        CompilerAsserts.neverPartOfCompilation();
        this.language = language;
        if (language != null && this.getLanguageInfo() == null) {
            throw new IllegalArgumentException("Truffle language instance is not initialized.");
        }
    }

    public abstract Object execute(VirtualFrame var1);

    public final LanguageInfo getLanguageInfo() {
        if (this.language != null) {
            return Node.ACCESSOR.languageSupport().getLanguageInfo(this.language);
        }
        return null;
    }

    public final <C extends TruffleLanguage> C getLanguage(Class<C> languageClass) {
        if (this.language == null) {
            return null;
        }
        TruffleLanguage<?> spi = this.language;
        if (!(spi.getClass() == languageClass || languageClass.isInstance(spi) && languageClass != TruffleLanguage.class && TruffleLanguage.class.isAssignableFrom(languageClass))) {
            CompilerDirectives.transferToInterpreter();
            throw new ClassCastException("Illegal language class specified. Expected " + spi.getClass().getName() + ".");
        }
        return (C)spi;
    }
}

