/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

public final class KeyInfo {
    public static final int NONE = 0;
    public static final int READABLE = 2;
    public static final int MODIFIABLE = 4;
    public static final int INVOCABLE = 8;
    public static final int INTERNAL = 16;
    public static final int REMOVABLE = 32;
    public static final int INSERTABLE = 64;
    private static final int WRITABLE = 68;
    private static final int EXISTING = 62;

    private KeyInfo() {
    }

    public static boolean isExisting(int infoBits) {
        return (infoBits & 0x3E) != 0;
    }

    public static boolean isReadable(int infoBits) {
        return (infoBits & 2) != 0;
    }

    public static boolean isWritable(int infoBits) {
        return (infoBits & 0x44) != 0;
    }

    public static boolean isInvocable(int infoBits) {
        return (infoBits & 8) != 0;
    }

    public static boolean isInternal(int infoBits) {
        return (infoBits & 0x10) != 0;
    }

    public static boolean isRemovable(int infoBits) {
        return (infoBits & 0x20) != 0;
    }

    public static boolean isModifiable(int infoBits) {
        return (infoBits & 4) != 0;
    }

    public static boolean isInsertable(int infoBits) {
        return (infoBits & 0x40) != 0;
    }

    @Deprecated
    public static Builder newBuilder() {
        KeyInfo keyInfo = new KeyInfo();
        keyInfo.getClass();
        return keyInfo.new Builder();
    }

    @Deprecated
    public final class Builder {
        private int infoBits = 1;

        private Builder() {
        }

        public Builder setReadable(boolean readable) {
            this.setBit(1, readable);
            return this;
        }

        public Builder setWritable(boolean readable) {
            this.setBit(2, readable);
            return this;
        }

        public Builder setInvocable(boolean readable) {
            this.setBit(3, readable);
            return this;
        }

        public Builder setInternal(boolean readable) {
            this.setBit(4, readable);
            return this;
        }

        public Builder setRemovable(boolean removable) {
            this.setBit(5, removable);
            return this;
        }

        public int build() {
            return this.infoBits;
        }

        private void setBit(int b, boolean value) {
            int v = value ? 1 : 0;
            this.infoBits = this.infoBits & ~(1 << b) | v << b;
        }
    }
}

