/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.interop.EmptyTruffleObject;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.InteropAccessNode;
import com.oracle.truffle.api.interop.KeyInfo;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;

class InteropAccessor
extends Accessor {
    InteropAccessor() {
    }

    @Override
    protected Accessor.InteropSupport interopSupport() {
        return new Accessor.InteropSupport(){

            @Override
            public boolean canHandle(Object foreignAccess, Object receiver) {
                ForeignAccess fa = (ForeignAccess)foreignAccess;
                TruffleObject obj = (TruffleObject)receiver;
                return fa.canHandle(obj);
            }

            @Override
            public CallTarget canHandleTarget(Object access) {
                ForeignAccess fa = (ForeignAccess)access;
                return fa.checkLanguage();
            }

            @Override
            public boolean isTruffleObject(Object value) {
                return value instanceof TruffleObject;
            }

            @Override
            public void checkInteropType(Object result) {
                InteropAccessNode.checkInteropType(result);
            }

            @Override
            public Object createDefaultNodeObject(Node node) {
                return EmptyTruffleObject.INSTANCE;
            }

            @Override
            public boolean isValidNodeObject(Object obj) {
                if (obj instanceof TruffleObject) {
                    Number size;
                    TruffleObject keys;
                    TruffleObject tObj = (TruffleObject)obj;
                    if (!ForeignAccess.sendHasKeys(Message.HAS_KEYS.createNode(), tObj)) {
                        throw new AssertionError((Object)"Invalid node object: must return true for the HAS_KEYS message.");
                    }
                    try {
                        keys = ForeignAccess.sendKeys(Message.KEYS.createNode(), tObj);
                    }
                    catch (UnsupportedMessageException e) {
                        throw new AssertionError("Invalid node object: must support the KEYS message.", e);
                    }
                    if (!(keys instanceof TruffleObject)) {
                        throw new AssertionError((Object)"Invalid node object: the returned KEYS object must be a TruffleObject.");
                    }
                    TruffleObject tKeys = keys;
                    Node hasSize = Message.HAS_SIZE.createNode();
                    if (!ForeignAccess.sendHasSize(hasSize, tKeys)) {
                        throw new AssertionError((Object)"Invalid node object: the returned KEYS object must support HAS_SIZE.");
                    }
                    Node getSize = Message.GET_SIZE.createNode();
                    try {
                        size = (Number)ForeignAccess.sendGetSize(getSize, tKeys);
                    }
                    catch (UnsupportedMessageException e) {
                        throw new AssertionError((Object)"Invalid node object: the returned KEYS object must have a size.");
                    }
                    Node readKeyNode = Message.READ.createNode();
                    Node readElementNode = Message.READ.createNode();
                    Node keyInfoNode = Message.KEY_INFO.createNode();
                    long longValue = size.longValue();
                    for (long i = 0L; i < longValue; ++i) {
                        Object key;
                        try {
                            key = ForeignAccess.sendRead(readKeyNode, tKeys, i);
                        }
                        catch (UnknownIdentifierException | UnsupportedMessageException e) {
                            throw new AssertionError((Object)("Invalid node object: the returned KEYS object must be readable at number identifier " + i));
                        }
                        if (!(key instanceof String)) {
                            throw new AssertionError((Object)("Invalid node object: the returned KEYS object must return a string at number identifier " + i + ". But was " + key.getClass().getName() + "."));
                        }
                        try {
                            ForeignAccess.sendRead(readElementNode, tObj, key);
                        }
                        catch (UnknownIdentifierException | UnsupportedMessageException e) {
                            throw new AssertionError((Object)("Invalid node object: the returned KEYS element must be readable with identifier " + key));
                        }
                        int keyInfo = ForeignAccess.sendKeyInfo(keyInfoNode, tObj, key);
                        if (KeyInfo.isWritable(keyInfo)) {
                            throw new AssertionError((Object)("Invalid node object: The key " + key + " is marked as writable but node objects must not be writable."));
                        }
                    }
                    Node node = Message.HAS_SIZE.createNode();
                    if (ForeignAccess.sendHasSize(node, tObj)) {
                        throw new AssertionError((Object)"Invalid node object: the node object must not return true for HAS_SIZE.");
                    }
                    return true;
                }
                throw new AssertionError((Object)"Invalid node object: Node objects must be of type TruffleObject.");
            }
        };
    }
}

