/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.InteropAccessNode;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=InteropAccessNode.class)
final class InteropAccessNodeGen
extends InteropAccessNode {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @Node.Child
    private CachedData cached_cache;
    @Node.Child
    private IndirectCallNode generic_indirectCall_;

    private InteropAccessNodeGen(Message message) {
        super(message);
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    protected Object executeImpl(TruffleObject arg0Value, Object[] arg1Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0) {
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    if (InteropAccessNode.acceptCached(arg0Value, s1_.foreignAccess_, s1_.canHandleCall_)) {
                        return InteropAccessNode.doCached(arg0Value, arg1Value, s1_.foreignAccess_, s1_.sendMessageCall_, s1_.canHandleCall_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                return this.doGeneric(arg0Value, arg1Value, this.generic_indirectCall_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(TruffleObject arg0Value, Object[] arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            Object object;
            DirectCallNode canHandleCall__;
            ForeignAccess foreignAccess__;
            int count1_ = 0;
            CachedData s1_ = this.cached_cache;
            if ((state & 1) != 0) {
                while (s1_ != null && !InteropAccessNode.acceptCached(arg0Value, s1_.foreignAccess_, s1_.canHandleCall_)) {
                    s1_ = s1_.next_;
                    ++count1_;
                }
            }
            if (s1_ == null && InteropAccessNode.acceptCached(arg0Value, foreignAccess__ = arg0Value.getForeignAccess(), canHandleCall__ = InteropAccessNode.createInlinedCallNode(this.createCanHandleTarget(foreignAccess__))) && count1_ < 8) {
                s1_ = new CachedData(this.cached_cache);
                s1_.foreignAccess_ = foreignAccess__;
                s1_.sendMessageCall_ = InteropAccessNode.createInlinedCallNode(this.createMessageTarget(foreignAccess__));
                s1_.canHandleCall_ = canHandleCall__;
                this.cached_cache = super.insert(s1_);
                this.state_ = state |= 1;
            }
            if (s1_ != null) {
                lock.unlock();
                hasLock = false;
                object = InteropAccessNode.doCached(arg0Value, arg1Value, s1_.foreignAccess_, s1_.sendMessageCall_, s1_.canHandleCall_);
                return object;
            }
            this.generic_indirectCall_ = super.insert(IndirectCallNode.create());
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            object = this.doGeneric(arg0Value, arg1Value, this.generic_indirectCall_);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        CachedData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static InteropAccessNode create(Message message) {
        return new InteropAccessNodeGen(message);
    }

    @GeneratedBy(value=InteropAccessNode.class)
    private static final class CachedData
    extends Node {
        @Node.Child
        CachedData next_;
        @CompilerDirectives.CompilationFinal
        ForeignAccess foreignAccess_;
        @Node.Child
        DirectCallNode sendMessageCall_;
        @Node.Child
        DirectCallNode canHandleCall_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }
}

