/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.InteropAccessNodeGen;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;

abstract class InteropAccessNode
extends Node {
    static final int ARG0_RECEIVER = 0;
    protected static final int CACHE_SIZE = 8;
    protected final Message message;
    @CompilerDirectives.CompilationFinal
    private int previousLength = -2;
    private final BranchProfile profileDefaultUnsupported = BranchProfile.create();

    protected InteropAccessNode(Message message) {
        this.message = message;
    }

    public final Object execute(TruffleObject receiver) throws InteropException {
        return InteropAccessNode.checkInteropType(this.executeImpl(receiver, new Object[]{receiver}));
    }

    public final Object executeOrFalse(TruffleObject receiver) throws InteropException {
        try {
            return InteropAccessNode.checkInteropType(this.executeImplInterop(receiver, new Object[]{receiver}));
        }
        catch (UnsupportedMessageException ex) {
            this.profileDefaultUnsupported.enter();
            return false;
        }
    }

    public final Object execute(TruffleObject receiver, Object[] arguments) throws InteropException {
        return InteropAccessNode.checkInteropType(this.executeImpl(receiver, this.insertArg1(arguments, receiver)));
    }

    public final Object execute(TruffleObject receiver, Object arg0) throws InteropException {
        return InteropAccessNode.checkInteropType(this.executeImpl(receiver, new Object[]{receiver, InteropAccessNode.checkInteropType(arg0)}));
    }

    public final Object execute(TruffleObject receiver, Object arg0, Object arg1) throws InteropException {
        return InteropAccessNode.checkInteropType(this.executeImpl(receiver, new Object[]{receiver, InteropAccessNode.checkInteropType(arg0), InteropAccessNode.checkInteropType(arg1)}));
    }

    public final Object execute(TruffleObject receiver, Object arg0, Object[] arguments) throws InteropException {
        return InteropAccessNode.checkInteropType(this.executeImpl(receiver, this.insertArg2(arguments, receiver, arg0)));
    }

    @Deprecated
    public final Object executeOld(TruffleObject receiver, Object[] arguments) {
        return InteropAccessNode.checkInteropType(this.executeImpl(receiver, this.insertArg1(arguments, receiver)));
    }

    private Object[] insertArg1(Object[] arguments, Object arg0) {
        int length = this.profileLength(arguments.length);
        Object[] newArguments = new Object[length + 1];
        newArguments[0] = InteropAccessNode.checkInteropType(arg0);
        InteropAccessNode.arraycopy(arguments, 0, newArguments, 1, length);
        return newArguments;
    }

    private Object[] insertArg2(Object[] arguments, Object arg0, Object arg1) {
        int length = this.profileLength(arguments.length);
        Object[] newArguments = new Object[length + 2];
        newArguments[0] = InteropAccessNode.checkInteropType(arg0);
        newArguments[1] = InteropAccessNode.checkInteropType(arg1);
        InteropAccessNode.arraycopy(arguments, 0, newArguments, 2, length);
        return newArguments;
    }

    private static void arraycopy(Object[] src, int srcPos, Object[] dest, int destPos, int length) {
        for (int i = 0; i < length; ++i) {
            dest[destPos + i] = InteropAccessNode.checkInteropType(src[srcPos + i]);
        }
    }

    static Object checkInteropType(Object obj) {
        assert (InteropAccessNode.checkInteropTypeImpl(obj));
        return obj;
    }

    private static boolean checkInteropTypeImpl(Object obj) {
        if (obj instanceof TruffleObject) {
            return true;
        }
        if (obj == null) {
            CompilerDirectives.transferToInterpreter();
            return InteropAccessNode.yieldAnError(null);
        }
        Class<?> clazz = obj.getClass();
        if (clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == Character.class || clazz == Boolean.class || clazz == String.class) {
            return true;
        }
        CompilerDirectives.transferToInterpreter();
        return InteropAccessNode.yieldAnError(obj.getClass());
    }

    private static boolean yieldAnError(Class<?> clazz) {
        CompilerDirectives.transferToInterpreter();
        StringBuilder sb = new StringBuilder();
        sb.append(clazz == null ? "null" : clazz.getName());
        sb.append(" isn't allowed Truffle interop type!\n");
        if (clazz == null) {
            throw new NullPointerException(sb.toString());
        }
        throw new ClassCastException(sb.toString());
    }

    private int profileLength(int length) {
        int returnLength = length;
        if (this.previousLength != -1) {
            if (this.previousLength == length) {
                returnLength = this.previousLength;
            } else {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.previousLength = this.previousLength == -2 ? length : -1;
            }
        }
        return returnLength;
    }

    private Object executeImplInterop(TruffleObject receiver, Object[] arguments) throws InteropException {
        return this.executeImpl(receiver, arguments);
    }

    protected abstract Object executeImpl(TruffleObject var1, Object[] var2);

    @Specialization(guards={"acceptCached(receiver, foreignAccess, canHandleCall)"}, limit="CACHE_SIZE")
    protected static Object doCached(TruffleObject receiver, Object[] arguments, @Cached(value="receiver.getForeignAccess()") ForeignAccess foreignAccess, @Cached(value="createInlinedCallNode(createMessageTarget(foreignAccess))") DirectCallNode sendMessageCall, @Cached(value="createInlinedCallNode(createCanHandleTarget(foreignAccess))") DirectCallNode canHandleCall) {
        return sendMessageCall.call(arguments);
    }

    protected static boolean acceptCached(TruffleObject receiver, ForeignAccess foreignAccess, DirectCallNode canHandleCall) {
        if (canHandleCall != null) {
            return (Boolean)canHandleCall.call(new Object[]{receiver});
        }
        if (foreignAccess != null) {
            return foreignAccess.canHandle(receiver);
        }
        return false;
    }

    protected static DirectCallNode createInlinedCallNode(CallTarget target) {
        if (target == null) {
            return null;
        }
        DirectCallNode callNode = DirectCallNode.create(target);
        callNode.forceInlining();
        return callNode;
    }

    @Specialization
    protected Object doGeneric(TruffleObject receiver, Object[] arguments, @Cached(value="create()") IndirectCallNode indirectCall) {
        return indirectCall.call(this.createGenericMessageTarget(receiver), arguments);
    }

    @CompilerDirectives.TruffleBoundary
    protected CallTarget createCanHandleTarget(ForeignAccess access) {
        return access != null ? access.checkLanguage() : null;
    }

    @CompilerDirectives.TruffleBoundary
    protected CallTarget createGenericMessageTarget(TruffleObject receiver) {
        return this.createMessageTarget(receiver.getForeignAccess());
    }

    protected CallTarget createMessageTarget(ForeignAccess fa) {
        CallTarget ct = null;
        if (fa != null) {
            ct = fa.access(this.message);
        }
        if (ct == null) {
            throw UnsupportedMessageException.raise(this.message);
        }
        return ct;
    }

    public static InteropAccessNode create(Message message) {
        return InteropAccessNodeGen.create(message);
    }
}

