/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropAccessNode;
import com.oracle.truffle.api.interop.InteropAccessor;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.KnownMessage;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.interop.impl.ReadOnlyArrayList;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.List;

public final class ForeignAccess {
    private final Factory factory;
    private final RootNode languageCheck;
    private final Thread initThread;
    private static final InteropAccessor ACCESSOR = new InteropAccessor();

    private ForeignAccess(Factory faf) {
        this(null, faf);
    }

    private ForeignAccess(RootNode languageCheck, Factory faf) {
        this.factory = faf;
        this.initThread = null;
        this.languageCheck = languageCheck;
        CompilerAsserts.neverPartOfCompilation("do not create a ForeignAccess object from compiled code");
    }

    public static ForeignAccess create(Class<? extends TruffleObject> baseClass, StandardFactory factory) {
        if (baseClass == null) {
            Factory f = (Factory)((Object)factory);
            assert (f != null);
        }
        return new ForeignAccess(new DelegatingFactory(baseClass, factory));
    }

    @Deprecated
    public static ForeignAccess create(Class<? extends TruffleObject> baseClass, Factory26 factory) {
        if (baseClass == null) {
            Factory f = (Factory)((Object)factory);
            assert (f != null);
        }
        return new ForeignAccess(new DelegatingFactory26(baseClass, factory));
    }

    public static ForeignAccess create(StandardFactory factory, RootNode languageCheck) {
        if (languageCheck == null) {
            Factory f = (Factory)((Object)factory);
            assert (f != null);
        }
        return new ForeignAccess(languageCheck, new DelegatingFactory(null, factory));
    }

    @Deprecated
    public static ForeignAccess create(Factory26 factory, RootNode languageCheck) {
        if (languageCheck == null) {
            Factory f = (Factory)((Object)factory);
            assert (f != null);
        }
        return new ForeignAccess(languageCheck, new DelegatingFactory26(null, factory));
    }

    public static ForeignAccess create(Factory factory) {
        return new ForeignAccess(factory);
    }

    @Deprecated
    public static Object execute(Node foreignNode, VirtualFrame frame, TruffleObject receiver, Object ... arguments) {
        return ((InteropAccessNode)foreignNode).executeOld(receiver, arguments);
    }

    public static Object send(Node foreignNode, TruffleObject receiver, Object ... arguments) throws InteropException {
        try {
            return ((InteropAccessNode)foreignNode).execute(receiver, arguments);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
    }

    public static Object sendRead(Node readNode, TruffleObject receiver, Object identifier) throws UnknownIdentifierException, UnsupportedMessageException {
        try {
            return ((InteropAccessNode)readNode).execute(receiver, identifier);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (UnknownIdentifierException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    public static Object sendWrite(Node writeNode, TruffleObject receiver, Object identifier, Object value) throws UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException {
        try {
            return ((InteropAccessNode)writeNode).execute(receiver, identifier, value);
        }
        catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    public static boolean sendRemove(Node removeNode, TruffleObject receiver, Object identifier) throws UnknownIdentifierException, UnsupportedMessageException {
        try {
            return (Boolean)((InteropAccessNode)removeNode).execute(receiver, identifier);
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    public static Object sendUnbox(Node unboxNode, TruffleObject receiver) throws UnsupportedMessageException {
        try {
            return ((InteropAccessNode)unboxNode).execute(receiver);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    public static boolean sendIsPointer(Node isPointerNode, TruffleObject receiver) {
        try {
            return (Boolean)((InteropAccessNode)isPointerNode).executeOrFalse(receiver);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    public static long sendAsPointer(Node asPointerNode, TruffleObject receiver) throws UnsupportedMessageException {
        try {
            return (Long)((InteropAccessNode)asPointerNode).execute(receiver);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    public static Object sendToNative(Node toNativeNode, TruffleObject receiver) throws UnsupportedMessageException {
        try {
            return ((InteropAccessNode)toNativeNode).execute(receiver);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    public static Object sendExecute(Node executeNode, TruffleObject receiver, Object ... arguments) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        try {
            return ((InteropAccessNode)executeNode).execute(receiver, arguments);
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    public static boolean sendIsExecutable(Node isExecutableNode, TruffleObject receiver) {
        try {
            return (Boolean)((InteropAccessNode)isExecutableNode).executeOrFalse(receiver);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    public static boolean sendIsInstantiable(Node isInstantiableNode, TruffleObject receiver) {
        try {
            return (Boolean)((InteropAccessNode)isInstantiableNode).executeOrFalse(receiver);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    public static Object sendInvoke(Node invokeNode, TruffleObject receiver, String identifier, Object ... arguments) throws UnsupportedTypeException, ArityException, UnknownIdentifierException, UnsupportedMessageException {
        try {
            return ((InteropAccessNode)invokeNode).execute(receiver, (Object)identifier, arguments);
        }
        catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    public static Object sendNew(Node newNode, TruffleObject receiver, Object ... arguments) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        try {
            return ((InteropAccessNode)newNode).execute(receiver, arguments);
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    public static boolean sendIsNull(Node isNullNode, TruffleObject receiver) {
        try {
            return (Boolean)((InteropAccessNode)isNullNode).executeOrFalse(receiver);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    public static boolean sendHasSize(Node hasSizeNode, TruffleObject receiver) {
        try {
            return (Boolean)((InteropAccessNode)hasSizeNode).executeOrFalse(receiver);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    public static Object sendGetSize(Node getSizeNode, TruffleObject receiver) throws UnsupportedMessageException {
        try {
            return ((InteropAccessNode)getSizeNode).execute(receiver);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    public static boolean sendIsBoxed(Node isBoxedNode, TruffleObject receiver) {
        try {
            return (Boolean)((InteropAccessNode)isBoxedNode).executeOrFalse(receiver);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    public static int sendKeyInfo(Node keyInfoNode, TruffleObject receiver, Object identifier) {
        try {
            return (Integer)ForeignAccess.send(keyInfoNode, receiver, identifier);
        }
        catch (UnsupportedMessageException ex) {
            CompilerDirectives.transferToInterpreter();
            try {
                TruffleObject keys = ForeignAccess.sendKeys(Message.KEYS.createNode(), receiver, true);
                Number sizeNumber = (Number)ForeignAccess.sendGetSize(Message.GET_SIZE.createNode(), keys);
                int size = sizeNumber.intValue();
                Node readNode = Message.READ.createNode();
                for (int i = 0; i < size; ++i) {
                    Object key = ForeignAccess.sendRead(readNode, keys, i);
                    if (!identifier.equals(key)) continue;
                    return 7;
                }
            }
            catch (UnknownIdentifierException | UnsupportedMessageException keys) {
                // empty catch block
            }
            try {
                boolean hasSize = ForeignAccess.sendHasSize(Message.HAS_SIZE.createNode(), receiver);
                if (hasSize && identifier instanceof Number) {
                    int id = ((Number)identifier).intValue();
                    if (id < 0 || (double)id != ((Number)identifier).doubleValue()) {
                        return 0;
                    }
                    Number sizeNumber = (Number)ForeignAccess.sendGetSize(Message.GET_SIZE.createNode(), receiver);
                    int size = sizeNumber.intValue();
                    if (id < size) {
                        return 7;
                    }
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            return 0;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    public static boolean sendHasKeys(Node hasKeysNode, TruffleObject receiver) {
        try {
            return (Boolean)((InteropAccessNode)hasKeysNode).execute(receiver);
        }
        catch (UnsupportedMessageException ex) {
            CompilerDirectives.transferToInterpreter();
            try {
                ForeignAccess.sendKeys(Message.KEYS.createNode(), receiver, true);
                return true;
            }
            catch (UnsupportedMessageException uex) {
                return false;
            }
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    public static TruffleObject sendKeys(Node keysNode, TruffleObject receiver) throws UnsupportedMessageException {
        try {
            return (TruffleObject)ForeignAccess.send(keysNode, receiver, new Object[0]);
        }
        catch (UnsupportedMessageException ex) {
            CompilerDirectives.transferToInterpreter();
            throw ex;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    public static TruffleObject sendKeys(Node keysNode, TruffleObject receiver, boolean includeInternal) throws UnsupportedMessageException {
        try {
            return (TruffleObject)ForeignAccess.send(keysNode, receiver, includeInternal);
        }
        catch (UnsupportedMessageException ex) {
            CompilerDirectives.transferToInterpreter();
            throw ex;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    public static List<Object> getArguments(Frame frame) {
        Object[] arr = frame.getArguments();
        return ReadOnlyArrayList.asList(arr, 1, arr.length);
    }

    public static TruffleObject getReceiver(Frame frame) {
        return (TruffleObject)frame.getArguments()[0];
    }

    public String toString() {
        Object f = this.factory instanceof DelegatingFactory ? ((DelegatingFactory)this.factory).factory : (this.factory instanceof DelegatingFactory26 ? ((DelegatingFactory26)this.factory).factory : this.factory);
        return "ForeignAccess[" + f.getClass().getName() + "]";
    }

    CallTarget access(Message message) {
        return this.factory.accessMessage(message);
    }

    CallTarget checkLanguage() {
        if (this.languageCheck != null) {
            return Truffle.getRuntime().createCallTarget((RootNode)this.languageCheck.deepCopy());
        }
        return null;
    }

    boolean canHandle(TruffleObject receiver) {
        return this.factory.canHandle(receiver);
    }

    private static class DelegatingFactory26
    implements Factory {
        private final Class<?> baseClass;
        private final Factory26 factory;

        DelegatingFactory26(Class<?> baseClass, Factory26 factory) {
            this.baseClass = baseClass;
            this.factory = factory;
        }

        @Override
        public boolean canHandle(TruffleObject obj) {
            if (this.baseClass == null) {
                return ((Factory)((Object)this.factory)).canHandle(obj);
            }
            return this.baseClass.isInstance(obj);
        }

        @Override
        public CallTarget accessMessage(Message msg) {
            return DelegatingFactory26.accessMessage(this.factory, msg);
        }

        private static CallTarget accessMessage(Factory26 factory, Message msg) {
            if (msg instanceof KnownMessage) {
                switch (msg.hashCode()) {
                    case 423430: {
                        return factory.accessExecute(0);
                    }
                    case 423429: {
                        return factory.accessInvoke(0);
                    }
                    case 423428: {
                        return factory.accessNew(0);
                    }
                    case 423432: {
                        return factory.accessGetSize();
                    }
                    case 423433: {
                        return factory.accessHasSize();
                    }
                    case 423434: {
                        return factory.accessIsBoxed();
                    }
                    case 423435: {
                        return factory.accessIsExecutable();
                    }
                    case 423436: {
                        return factory.accessIsNull();
                    }
                    case 423438: {
                        return factory.accessRead();
                    }
                    case 423437: {
                        return factory.accessUnbox();
                    }
                    case 423431: {
                        return factory.accessWrite();
                    }
                    case 423439: {
                        return factory.accessKeys();
                    }
                    case 423440: {
                        return factory.accessKeyInfo();
                    }
                    case 423531: {
                        return factory.accessIsPointer();
                    }
                    case 423532: {
                        return factory.accessAsPointer();
                    }
                    case 423533: {
                        return factory.accessToNative();
                    }
                }
            }
            return factory.accessMessage(msg);
        }
    }

    private static class DelegatingFactory
    implements Factory {
        private final Class<?> baseClass;
        private final StandardFactory factory;

        DelegatingFactory(Class<?> baseClass, StandardFactory factory) {
            this.baseClass = baseClass;
            this.factory = factory;
        }

        @Override
        public boolean canHandle(TruffleObject obj) {
            if (this.baseClass == null) {
                return ((Factory)((Object)this.factory)).canHandle(obj);
            }
            return this.baseClass.isInstance(obj);
        }

        @Override
        public CallTarget accessMessage(Message msg) {
            return DelegatingFactory.accessMessage(this.factory, msg);
        }

        private static CallTarget accessMessage(StandardFactory factory, Message msg) {
            if (msg instanceof KnownMessage) {
                switch (msg.hashCode()) {
                    case 423430: {
                        return factory.accessExecute(0);
                    }
                    case 423429: {
                        return factory.accessInvoke(0);
                    }
                    case 423428: {
                        return factory.accessNew(0);
                    }
                    case 423432: {
                        return factory.accessGetSize();
                    }
                    case 423441: {
                        return factory.accessHasKeys();
                    }
                    case 423433: {
                        return factory.accessHasSize();
                    }
                    case 423434: {
                        return factory.accessIsBoxed();
                    }
                    case 423435: {
                        return factory.accessIsExecutable();
                    }
                    case 423442: {
                        return factory.accessIsInstantiable();
                    }
                    case 423436: {
                        return factory.accessIsNull();
                    }
                    case 423438: {
                        return factory.accessRead();
                    }
                    case 423437: {
                        return factory.accessUnbox();
                    }
                    case 423431: {
                        return factory.accessWrite();
                    }
                    case 423443: {
                        return factory.accessRemove();
                    }
                    case 423439: {
                        return factory.accessKeys();
                    }
                    case 423440: {
                        return factory.accessKeyInfo();
                    }
                    case 423531: {
                        return factory.accessIsPointer();
                    }
                    case 423532: {
                        return factory.accessAsPointer();
                    }
                    case 423533: {
                        return factory.accessToNative();
                    }
                }
            }
            return factory.accessMessage(msg);
        }
    }

    @Deprecated
    public static interface Factory26 {
        public CallTarget accessIsNull();

        public CallTarget accessIsExecutable();

        public CallTarget accessIsBoxed();

        public CallTarget accessHasSize();

        public CallTarget accessGetSize();

        public CallTarget accessUnbox();

        public CallTarget accessRead();

        public CallTarget accessWrite();

        public CallTarget accessExecute(int var1);

        public CallTarget accessInvoke(int var1);

        public CallTarget accessNew(int var1);

        public CallTarget accessKeys();

        public CallTarget accessKeyInfo();

        default public CallTarget accessIsPointer() {
            return null;
        }

        default public CallTarget accessAsPointer() {
            return null;
        }

        default public CallTarget accessToNative() {
            return null;
        }

        public CallTarget accessMessage(Message var1);
    }

    public static interface StandardFactory {
        default public CallTarget accessIsNull() {
            return null;
        }

        default public CallTarget accessIsExecutable() {
            return null;
        }

        default public CallTarget accessIsInstantiable() {
            return null;
        }

        default public CallTarget accessIsBoxed() {
            return null;
        }

        default public CallTarget accessHasSize() {
            return null;
        }

        default public CallTarget accessGetSize() {
            return null;
        }

        default public CallTarget accessUnbox() {
            return null;
        }

        default public CallTarget accessRead() {
            return null;
        }

        default public CallTarget accessWrite() {
            return null;
        }

        default public CallTarget accessRemove() {
            return null;
        }

        default public CallTarget accessExecute(int argumentsLength) {
            return null;
        }

        default public CallTarget accessInvoke(int argumentsLength) {
            return null;
        }

        default public CallTarget accessNew(int argumentsLength) {
            return null;
        }

        default public CallTarget accessHasKeys() {
            return null;
        }

        default public CallTarget accessKeys() {
            return null;
        }

        default public CallTarget accessKeyInfo() {
            return null;
        }

        default public CallTarget accessIsPointer() {
            return null;
        }

        default public CallTarget accessAsPointer() {
            return null;
        }

        default public CallTarget accessToNative() {
            return null;
        }

        default public CallTarget accessMessage(Message unknown) {
            return null;
        }
    }

    public static interface Factory {
        public boolean canHandle(TruffleObject var1);

        public CallTarget accessMessage(Message var1);
    }
}

