/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrumentation;

import com.oracle.truffle.api.instrumentation.AllocationReporter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

final class PropChangeSupport {
    private final AllocationReporter source;
    private final List<Object> propSupport = new CopyOnWriteArrayList<Object>();

    PropChangeSupport(AllocationReporter source) {
        this.source = source;
    }

    void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.add(listener);
    }

    void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.remove(listener);
    }

    void firePropertyChange(String prop, Object old, Object n) {
        if (this.propSupport.isEmpty()) {
            return;
        }
        PropertyChangeEvent ev = new PropertyChangeEvent(this.source, prop, old, n);
        for (PropertyChangeListener l : this.propSupport.toArray(new PropertyChangeListener[0])) {
            l.propertyChange(ev);
        }
    }
}

