/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrumentation;

import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.source.SourceSection;
import java.util.List;
import java.util.Set;

class DefaultNearestNodeSearch {
    DefaultNearestNodeSearch() {
    }

    static Node findNearestNodeAt(int offset, Node contextNode, Set<Class<? extends Tag>> tags) {
        Node node = (Node)((Object)((InstrumentableNode)((Object)contextNode)).materializeInstrumentableNodes(tags));
        SourceSection section = node.getSourceSection();
        int startIndex = section.getCharIndex();
        int endIndex = DefaultNearestNodeSearch.getCharEndIndex(section);
        if (startIndex <= offset && offset <= endIndex) {
            Node parent = DefaultNearestNodeSearch.findParentTaggedNode(node, tags);
            Node ch = DefaultNearestNodeSearch.findChildTaggedNode(node, offset, tags, parent != null, false);
            while (ch == null) {
                if (node == parent) {
                    return parent;
                }
                if ((node = node.getParent()) == null) break;
                ch = DefaultNearestNodeSearch.findChildTaggedNode(node, offset, tags, parent != null, false);
            }
            return ch;
        }
        if (endIndex < offset) {
            return DefaultNearestNodeSearch.findLastNode(node, tags);
        }
        return DefaultNearestNodeSearch.findFirstNode(node, tags);
    }

    private static Node findChildTaggedNode(Node node, final int offset, final Set<Class<? extends Tag>> tags, final boolean haveOuterCandidate, final boolean preferFirst) {
        Node secondaryTaggedNode;
        Node secondaryNode;
        Node primaryTaggedNode;
        Node primaryNode;
        final Node[] highestLowerNode = new Node[]{null};
        final Node[] highestLowerTaggedNode = new Node[]{null};
        final Node[] lowestHigherNode = new Node[]{null};
        final Node[] lowestHigherTaggedNode = new Node[]{null};
        final Node[] foundNode = new Node[]{null};
        NodeUtil.forEachChild(node, new NodeVisitor(){
            int highestLowerNodeIndex = 0;
            int highestLowerTaggedNodeIndex = 0;
            int lowestHigherNodeIndex = 0;
            int lowestHigherTaggedNodeIndex = 0;

            @Override
            public boolean visit(Node childNode) {
                SourceSection ss;
                Node ch = childNode;
                if (ch instanceof InstrumentableNode.WrapperNode) {
                    ch = ((InstrumentableNode.WrapperNode)((Object)ch)).getDelegateNode();
                }
                if (ch instanceof InstrumentableNode && ((InstrumentableNode)((Object)ch)).isInstrumentable()) {
                    ss = (ch = (Node)((Object)((InstrumentableNode)((Object)ch)).materializeInstrumentableNodes(tags))).getSourceSection();
                    if (ss == null) {
                        return true;
                    }
                } else {
                    NodeUtil.forEachChild(ch, this);
                    return foundNode[0] == null;
                }
                boolean isTagged = DefaultNearestNodeSearch.isTaggedWith((InstrumentableNode)((Object)ch), (Set<Class<? extends Tag>>)tags);
                int i1 = ss.getCharIndex();
                int i2 = DefaultNearestNodeSearch.getCharEndIndex(ss);
                if (isTagged && offset == i1) {
                    foundNode[0] = ch;
                    return false;
                }
                if (i1 <= offset && offset <= i2) {
                    Node taggedNode = DefaultNearestNodeSearch.findChildTaggedNode(ch, offset, tags, isTagged || haveOuterCandidate, preferFirst);
                    if (taggedNode != null) {
                        foundNode[0] = taggedNode;
                        return false;
                    }
                    if (isTagged) {
                        foundNode[0] = ch;
                        return false;
                    }
                }
                if (offset < i1) {
                    if (lowestHigherNode[0] == null || this.lowestHigherNodeIndex > i1) {
                        lowestHigherNode[0] = ch;
                        this.lowestHigherNodeIndex = i1;
                    }
                    if (isTagged && (lowestHigherTaggedNode[0] == null || this.lowestHigherTaggedNodeIndex > i1)) {
                        lowestHigherTaggedNode[0] = ch;
                        this.lowestHigherTaggedNodeIndex = i1;
                    }
                }
                if (i2 < offset) {
                    if (highestLowerNode[0] == null || (preferFirst ? i1 < this.highestLowerNodeIndex : this.highestLowerNodeIndex < i1)) {
                        highestLowerNode[0] = ch;
                        this.highestLowerNodeIndex = i1;
                    }
                    if (isTagged && (highestLowerTaggedNode[0] == null || (preferFirst ? i1 < this.highestLowerTaggedNodeIndex : this.highestLowerTaggedNodeIndex < i1))) {
                        highestLowerTaggedNode[0] = ch;
                        this.highestLowerTaggedNodeIndex = i1;
                    }
                }
                return true;
            }
        });
        if (foundNode[0] != null) {
            return foundNode[0];
        }
        if (preferFirst) {
            primaryNode = highestLowerNode[0];
            primaryTaggedNode = highestLowerTaggedNode[0];
            secondaryNode = lowestHigherNode[0];
            secondaryTaggedNode = lowestHigherTaggedNode[0];
        } else {
            primaryNode = lowestHigherNode[0];
            primaryTaggedNode = lowestHigherTaggedNode[0];
            secondaryNode = highestLowerNode[0];
            secondaryTaggedNode = highestLowerTaggedNode[0];
        }
        if (DefaultNearestNodeSearch.isTaggedWith(primaryNode, tags)) {
            return primaryNode;
        }
        Node taggedNode = null;
        if (!haveOuterCandidate && primaryNode != null) {
            taggedNode = DefaultNearestNodeSearch.findChildTaggedNode(primaryNode, offset, tags, haveOuterCandidate, true);
        }
        if (taggedNode == null && primaryTaggedNode != null) {
            return primaryTaggedNode;
        }
        if (DefaultNearestNodeSearch.isTaggedWith(secondaryNode, tags)) {
            return secondaryNode;
        }
        if (!haveOuterCandidate && taggedNode == null && secondaryNode != null) {
            taggedNode = DefaultNearestNodeSearch.findChildTaggedNode(secondaryNode, offset, tags, haveOuterCandidate, true);
        }
        if (taggedNode == null && secondaryTaggedNode != null) {
            return secondaryTaggedNode;
        }
        return taggedNode;
    }

    private static int getCharEndIndex(SourceSection ss) {
        if (ss.getCharLength() > 0) {
            return ss.getCharEndIndex() - 1;
        }
        return ss.getCharIndex();
    }

    private static Node findParentTaggedNode(Node node, Set<Class<? extends Tag>> tags) {
        if (DefaultNearestNodeSearch.isTaggedWith(node, tags)) {
            return node;
        }
        Node parent = node.getParent();
        if (parent == null) {
            return null;
        }
        return DefaultNearestNodeSearch.findParentTaggedNode(parent, tags);
    }

    private static Node findFirstNode(Node contextNode, final Set<Class<? extends Tag>> tags) {
        final Node[] first = new Node[]{null};
        contextNode.accept(new NodeVisitor(){

            @Override
            public boolean visit(Node node) {
                if (DefaultNearestNodeSearch.isTaggedWith(node, (Set<Class<? extends Tag>>)tags)) {
                    first[0] = node;
                    return false;
                }
                return true;
            }
        });
        return first[0];
    }

    private static Node findLastNode(Node contextNode, Set<Class<? extends Tag>> tags) {
        if (DefaultNearestNodeSearch.isTaggedWith(contextNode, tags)) {
            return contextNode;
        }
        List<Node> children = NodeUtil.findNodeChildren(contextNode);
        for (int i = children.size() - 1; i >= 0; --i) {
            Node last;
            Node ch = children.get(i);
            if (ch instanceof InstrumentableNode.WrapperNode) {
                ch = ((InstrumentableNode.WrapperNode)((Object)ch)).getDelegateNode();
            }
            if ((last = DefaultNearestNodeSearch.findLastNode(ch, tags)) == null) continue;
            return last;
        }
        return null;
    }

    private static boolean isTaggedWith(Node node, Set<Class<? extends Tag>> tags) {
        if (node instanceof InstrumentableNode && ((InstrumentableNode)((Object)node)).isInstrumentable()) {
            InstrumentableNode inode = ((InstrumentableNode)((Object)node)).materializeInstrumentableNodes(tags);
            return DefaultNearestNodeSearch.isTaggedWith(inode, tags);
        }
        return false;
    }

    private static boolean isTaggedWith(InstrumentableNode inode, Set<Class<? extends Tag>> tags) {
        for (Class<? extends Tag> tag : tags) {
            if (!inode.hasTag(tag)) continue;
            return true;
        }
        return false;
    }
}

