/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.LoopCountReceiver;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.impl.DelegatingOutputStream;
import com.oracle.truffle.api.impl.DispatchOutputStream;
import com.oracle.truffle.api.impl.TVMCI;
import com.oracle.truffle.api.impl.TruffleLocator;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.io.FileSystem;

public abstract class Accessor {
    @CompilerDirectives.CompilationFinal
    private static LanguageSupport API;
    @CompilerDirectives.CompilationFinal
    private static EngineSupport SPI;
    private static Nodes NODES;
    private static InstrumentSupport INSTRUMENTHANDLER;
    private static DumpSupport DUMP;
    private static InteropSupport INTEROP;
    private static Frames FRAMES;
    private static SourceSupport SOURCE;
    private static final TVMCI SUPPORT;

    protected final Collection<ClassLoader> loaders() {
        return TruffleLocator.loaders();
    }

    protected void initializeNativeImageTruffleLocator() {
        TruffleLocator.initializeNativeImageTruffleLocator();
    }

    private static void conditionallyInitDebugger() throws IllegalStateException {
        block4: {
            try {
                Class.forName("com.oracle.truffle.api.debug.Debugger", true, Accessor.class.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                boolean assertOn = false;
                if (!$assertionsDisabled) {
                    assertOn = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (assertOn) break block4;
                throw new IllegalStateException(ex);
            }
        }
    }

    private static void conditionallyInitInstrumentation() throws IllegalStateException {
        block4: {
            try {
                Class.forName("com.oracle.truffle.api.instrumentation.InstrumentationHandler", true, Accessor.class.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                boolean assertOn = false;
                if (!$assertionsDisabled) {
                    assertOn = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (assertOn) break block4;
                throw new IllegalStateException(ex);
            }
        }
    }

    private static void conditionallyInitSourceAccessor() throws IllegalStateException {
        block4: {
            try {
                Class.forName("com.oracle.truffle.api.source.Source", true, Accessor.class.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                boolean assertOn = false;
                if (!$assertionsDisabled) {
                    assertOn = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (assertOn) break block4;
                throw new IllegalStateException(ex);
            }
        }
    }

    private static void conditionallyInitInterop() throws IllegalStateException {
        block4: {
            try {
                Class.forName("com.oracle.truffle.api.interop.ForeignAccess", true, Accessor.class.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                boolean assertOn = false;
                if (!$assertionsDisabled) {
                    assertOn = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (assertOn) break block4;
                throw new IllegalStateException(ex);
            }
        }
    }

    protected Accessor() {
        if (!this.getClass().getName().startsWith("com.oracle.truffle") && !this.getClass().getName().startsWith("com.oracle.truffle.tck")) {
            throw new IllegalStateException();
        }
        String simpleName = this.getClass().getSimpleName();
        if (simpleName.endsWith("API")) {
            if (API != null) {
                throw new IllegalStateException();
            }
            API = this.languageSupport();
        } else if (simpleName.endsWith("Nodes")) {
            if (NODES != null) {
                throw new IllegalStateException();
            }
            NODES = this.nodes();
        } else if (simpleName.endsWith("InstrumentHandler")) {
            if (INSTRUMENTHANDLER != null) {
                throw new IllegalStateException();
            }
            INSTRUMENTHANDLER = this.instrumentSupport();
        } else if (simpleName.endsWith("Frames")) {
            if (FRAMES != null) {
                throw new IllegalStateException();
            }
            FRAMES = this.framesSupport();
        } else if (simpleName.endsWith("SourceAccessor")) {
            SOURCE = this.sourceSupport();
        } else if (simpleName.endsWith("DumpAccessor")) {
            DUMP = this.dumpSupport();
        } else if (simpleName.endsWith("InteropAccessor")) {
            INTEROP = this.interopSupport();
        } else if (!(simpleName.endsWith("ScopeAccessor") || simpleName.endsWith("AccessorDebug") || simpleName.endsWith("TruffleTCKAccessor") || simpleName.endsWith("TestAccessor"))) {
            assert (simpleName.endsWith("VMAccessor"));
            SPI = this.engineSupport();
        }
    }

    protected Nodes nodes() {
        return NODES;
    }

    protected LanguageSupport languageSupport() {
        return API;
    }

    protected DumpSupport dumpSupport() {
        return DUMP;
    }

    protected EngineSupport engineSupport() {
        return SPI;
    }

    protected InstrumentSupport instrumentSupport() {
        return INSTRUMENTHANDLER;
    }

    protected InteropSupport interopSupport() {
        return INTEROP;
    }

    protected SourceSupport sourceSupport() {
        return SOURCE;
    }

    static InstrumentSupport instrumentAccess() {
        return INSTRUMENTHANDLER;
    }

    static LanguageSupport languageAccess() {
        return API;
    }

    static EngineSupport engineAccess() {
        return SPI;
    }

    static Nodes nodesAccess() {
        return NODES;
    }

    protected Frames framesSupport() {
        return FRAMES;
    }

    static Frames framesAccess() {
        return FRAMES;
    }

    public static void main(String ... args) {
        throw new IllegalStateException();
    }

    protected OptionDescriptors getCompilerOptions() {
        if (SUPPORT == null) {
            return OptionDescriptors.EMPTY;
        }
        return SUPPORT.getCompilerOptionDescriptors();
    }

    protected boolean isGuestCallStackElement(StackTraceElement element) {
        if (SUPPORT == null) {
            return false;
        }
        return SUPPORT.isGuestCallStackFrame(element);
    }

    protected void initializeProfile(CallTarget target, Class<?>[] argmentTypes) {
        SUPPORT.initializeProfile(target, argmentTypes);
    }

    protected Object callProfiled(CallTarget target, Object ... args) {
        return SUPPORT.callProfiled(target, args);
    }

    protected void onLoopCount(Node source, int iterations) {
        if (SUPPORT != null) {
            SUPPORT.onLoopCount(source, iterations);
        } else {
            RootCallTarget target;
            RootNode root = source.getRootNode();
            if (root != null && (target = root.getCallTarget()) instanceof LoopCountReceiver) {
                ((LoopCountReceiver)((Object)target)).reportLoopCount(iterations);
            }
        }
    }

    static <T extends TruffleLanguage<?>> T findLanguageByClass(Object vm, Class<T> languageClass) {
        TruffleLanguage.Env env = SPI.findEnv(vm, languageClass, true);
        TruffleLanguage<?> language = API.getLanguage(env);
        return (T)((TruffleLanguage)languageClass.cast(language));
    }

    static {
        TruffleLanguage<Object> lng = new TruffleLanguage<Object>(){

            @Override
            protected boolean isObjectOfLanguage(Object object) {
                return false;
            }

            @Override
            protected Object createContext(TruffleLanguage.Env env) {
                return null;
            }
        };
        lng.hashCode();
        new Node(){}.getRootNode();
        Accessor.conditionallyInitDebugger();
        Accessor.conditionallyInitInterop();
        Accessor.conditionallyInitInstrumentation();
        Accessor.conditionallyInitSourceAccessor();
        if (TruffleOptions.TraceASTJSON) {
            try {
                Class.forName("com.oracle.truffle.api.utilities.JSONHelper", true, Accessor.class.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
        }
        SUPPORT = Truffle.getRuntime().getCapability(TVMCI.class);
    }

    public static abstract class Frames {
        protected abstract void markMaterializeCalled(FrameDescriptor var1);

        protected abstract boolean getMaterializeCalled(FrameDescriptor var1);
    }

    public static abstract class InstrumentSupport {
        public abstract void initializeInstrument(Object var1, Object var2, Class<?> var3);

        public abstract void createInstrument(Object var1, Object var2, String[] var3, OptionValues var4);

        public abstract void finalizeInstrument(Object var1, Object var2);

        public abstract void disposeInstrument(Object var1, Object var2, boolean var3);

        public abstract <T> T getInstrumentationHandlerService(Object var1, Object var2, Class<T> var3);

        public abstract Object createInstrumentationHandler(Object var1, DispatchOutputStream var2, DispatchOutputStream var3, InputStream var4);

        public abstract void collectEnvServices(Set<Object> var1, Object var2, TruffleLanguage<?> var3);

        public abstract void onFirstExecution(RootNode var1);

        public abstract void onLoad(RootNode var1);

        public abstract Iterable<?> findTopScopes(TruffleLanguage.Env var1);

        public final DispatchOutputStream createDispatchOutput(OutputStream out) {
            if (out instanceof DispatchOutputStream) {
                return (DispatchOutputStream)out;
            }
            return new DispatchOutputStream(out);
        }

        public final DelegatingOutputStream createDelegatingOutput(OutputStream out, DispatchOutputStream delegate) {
            return new DelegatingOutputStream(out, delegate);
        }

        public final OutputStream getOut(DispatchOutputStream out) {
            return out.getOut();
        }

        public abstract OptionDescriptors describeOptions(Object var1, Object var2, String var3);

        public abstract Object getEngineInstrumenter(Object var1);

        public abstract void onNodeInserted(RootNode var1, Node var2);

        public abstract void notifyContextCreated(Object var1, TruffleContext var2);

        public abstract void notifyContextClosed(Object var1, TruffleContext var2);

        public abstract void notifyLanguageContextCreated(Object var1, TruffleContext var2, LanguageInfo var3);

        public abstract void notifyLanguageContextInitialized(Object var1, TruffleContext var2, LanguageInfo var3);

        public abstract void notifyLanguageContextFinalized(Object var1, TruffleContext var2, LanguageInfo var3);

        public abstract void notifyLanguageContextDisposed(Object var1, TruffleContext var2, LanguageInfo var3);

        public abstract void notifyThreadStarted(Object var1, TruffleContext var2, Thread var3);

        public abstract void notifyThreadFinished(Object var1, TruffleContext var2, Thread var3);

        public abstract org.graalvm.polyglot.SourceSection createSourceSection(Object var1, org.graalvm.polyglot.Source var2, SourceSection var3);

        public abstract void patchInstrumentationHandler(Object var1, DispatchOutputStream var2, DispatchOutputStream var3, InputStream var4);

        public abstract boolean isInputValueSlotIdentifier(Object var1);
    }

    public static abstract class LanguageSupport {
        public abstract void initializeLanguage(TruffleLanguage<?> var1, LanguageInfo var2, Object var3);

        public abstract TruffleLanguage.Env createEnv(Object var1, TruffleLanguage<?> var2, OutputStream var3, OutputStream var4, InputStream var5, Map<String, Object> var6, OptionValues var7, String[] var8, FileSystem var9);

        public abstract boolean areOptionsCompatible(TruffleLanguage<?> var1, OptionValues var2, OptionValues var3);

        public abstract Object createEnvContext(TruffleLanguage.Env var1);

        public abstract TruffleContext createTruffleContext(Object var1);

        public abstract void postInitEnv(TruffleLanguage.Env var1);

        public abstract Object evalInContext(Source var1, Node var2, MaterializedFrame var3);

        public abstract Object findExportedSymbol(TruffleLanguage.Env var1, String var2, boolean var3);

        public abstract Object languageGlobal(TruffleLanguage.Env var1);

        public abstract void dispose(TruffleLanguage.Env var1);

        public abstract LanguageInfo getLanguageInfo(TruffleLanguage.Env var1);

        public abstract LanguageInfo getLanguageInfo(TruffleLanguage<?> var1);

        public abstract LanguageInfo getLegacyLanguageInfo(Object var1, Class<? extends TruffleLanguage> var2);

        public abstract CallTarget parse(TruffleLanguage.Env var1, Source var2, Node var3, String ... var4);

        public abstract ExecutableNode parseInline(TruffleLanguage.Env var1, Source var2, Node var3, MaterializedFrame var4);

        public abstract String toStringIfVisible(TruffleLanguage.Env var1, Object var2, boolean var3);

        public abstract Object findMetaObject(TruffleLanguage.Env var1, Object var2);

        public abstract SourceSection findSourceLocation(TruffleLanguage.Env var1, Object var2);

        public abstract boolean isObjectOfLanguage(TruffleLanguage.Env var1, Object var2);

        public abstract Object getContext(TruffleLanguage.Env var1);

        public abstract TruffleLanguage<?> getSPI(TruffleLanguage.Env var1);

        public abstract InstrumentInfo createInstrument(Object var1, String var2, String var3, String var4);

        public abstract Object getVMObject(InstrumentInfo var1);

        public abstract <S> S lookup(TruffleLanguage<?> var1, Class<S> var2);

        public abstract boolean isContextInitialized(TruffleLanguage.Env var1);

        public abstract OptionDescriptors describeOptions(TruffleLanguage<?> var1, String var2);

        public abstract void onThrowable(Node var1, RootCallTarget var2, Throwable var3, Frame var4);

        public abstract boolean isThreadAccessAllowed(TruffleLanguage.Env var1, Thread var2, boolean var3);

        public abstract void initializeThread(TruffleLanguage.Env var1, Thread var2);

        public abstract void initializeMultiThreading(TruffleLanguage.Env var1);

        public abstract void disposeThread(TruffleLanguage.Env var1, Thread var2);

        public abstract void finalizeContext(TruffleLanguage.Env var1);

        public abstract Iterable<Scope> findLocalScopes(TruffleLanguage.Env var1, Node var2, Frame var3);

        public abstract Iterable<Scope> findTopScopes(TruffleLanguage.Env var1);

        public abstract TruffleLanguage.Env patchEnvContext(TruffleLanguage.Env var1, OutputStream var2, OutputStream var3, InputStream var4, Map<String, Object> var5, OptionValues var6, String[] var7, FileSystem var8);

        public abstract boolean initializeMultiContext(TruffleLanguage<?> var1);

        public abstract boolean isTruffleStackTrace(Throwable var1);

        public abstract StackTraceElement[] getInternalStackTraceElements(Throwable var1);

        public abstract void materializeHostFrames(Throwable var1);

        public abstract boolean checkTruffleFile(File var1);

        public abstract byte[] truffleFileContent(File var1) throws IOException;

        public abstract void configureLoggers(Object var1, Map<String, Level> var2);

        public abstract TruffleLanguage<?> getLanguage(TruffleLanguage.Env var1);

        public abstract File asFile(TruffleFile var1);
    }

    public static abstract class EngineSupport {
        public static final int EXECUTION_EVENT = 1;
        public static final int SUSPENDED_EVENT = 2;

        public abstract TruffleLanguage.Env findEnv(Object var1, Class<? extends TruffleLanguage> var2, boolean var3);

        public abstract Object getInstrumentationHandler(Object var1);

        public abstract void exportSymbol(Object var1, String var2, Object var3);

        public abstract Map<String, ? extends Object> getExportedSymbols(Object var1);

        public abstract Object importSymbol(Object var1, TruffleLanguage.Env var2, String var3);

        public abstract boolean isMimeTypeSupported(Object var1, String var2);

        public abstract void registerDebugger(Object var1, Object var2);

        public abstract boolean isEvalRoot(RootNode var1);

        public abstract <T> T lookupJavaInteropCodeCache(Object var1, Object var2, Class<T> var3);

        public abstract <T> T installJavaInteropCodeCache(Object var1, Object var2, T var3, Class<T> var4);

        public final void attachOutputConsumer(DispatchOutputStream dos, OutputStream out) {
            dos.attach(out);
        }

        public final void detachOutputConsumer(DispatchOutputStream dos, OutputStream out) {
            dos.detach(out);
        }

        public abstract Object getCurrentVM();

        public abstract CallTarget parseForLanguage(Object var1, Source var2, String[] var3);

        public abstract TruffleLanguage.Env getEnvForInstrument(Object var1, String var2, String var3);

        public abstract TruffleLanguage.Env getEnvForInstrument(LanguageInfo var1);

        public abstract TruffleLanguage.Env getExistingEnvForInstrument(LanguageInfo var1);

        public abstract LanguageInfo getObjectLanguage(Object var1, Object var2);

        public abstract Object getCurrentContext(Object var1);

        public abstract boolean isDisposed(Object var1);

        public abstract Map<String, LanguageInfo> getLanguages(Object var1);

        public abstract Map<String, InstrumentInfo> getInstruments(Object var1);

        public abstract org.graalvm.polyglot.SourceSection createSourceSection(Object var1, org.graalvm.polyglot.Source var2, SourceSection var3);

        public abstract <T> T lookup(InstrumentInfo var1, Class<T> var2);

        public abstract <S> S lookup(LanguageInfo var1, Class<S> var2);

        public abstract <T extends TruffleLanguage<?>> T getCurrentLanguage(Class<T> var1);

        public abstract <C, T extends TruffleLanguage<C>> C getCurrentContext(Class<T> var1);

        public abstract TruffleContext getPolyglotContext(Object var1);

        public abstract Object toGuestValue(Object var1, Object var2);

        public abstract Object getVMFromLanguageObject(Object var1);

        public abstract OptionValues getCompilerOptionValues(RootNode var1);

        public abstract Object lookupHostSymbol(Object var1, TruffleLanguage.Env var2, String var3);

        public abstract Object asHostSymbol(Object var1, Class<?> var2);

        public abstract boolean isHostAccessAllowed(Object var1, TruffleLanguage.Env var2);

        public abstract boolean isNativeAccessAllowed(Object var1, TruffleLanguage.Env var2);

        public abstract Object createInternalContext(Object var1, Map<String, Object> var2, TruffleContext var3);

        public abstract void initializeInternalContext(Object var1, Object var2);

        public abstract Object enterInternalContext(Object var1);

        public abstract void leaveInternalContext(Object var1, Object var2);

        public abstract void closeInternalContext(Object var1);

        public abstract void reportAllLanguageContexts(Object var1, Object var2);

        public abstract void reportAllContextThreads(Object var1, Object var2);

        public abstract TruffleContext getParentContext(Object var1);

        public abstract boolean isCreateThreadAllowed(Object var1);

        public abstract Thread createThread(Object var1, Runnable var2, Object var3);

        public abstract Iterable<Scope> createDefaultLexicalScope(Node var1, Frame var2);

        public abstract Iterable<Scope> createDefaultTopScope(Object var1);

        public abstract RuntimeException wrapHostException(Object var1, Throwable var2);

        public abstract boolean isHostException(Throwable var1);

        public abstract Throwable asHostException(Throwable var1);

        public abstract Object getCurrentHostContext();

        public abstract PolyglotException wrapGuestException(String var1, Throwable var2);

        public abstract Object legacyTckEnter(Object var1);

        public abstract void legacyTckLeave(Object var1, Object var2);

        public abstract <T> T getOrCreateRuntimeData(Object var1, Supplier<T> var2);

        public abstract Class<? extends TruffleLanguage<?>> getLanguageClass(LanguageInfo var1);

        public abstract Object getPolyglotBindingsForLanguage(Object var1);

        public abstract Object findMetaObjectForLanguage(Object var1, Object var2);

        public abstract boolean isDefaultFileSystem(FileSystem var1);

        public abstract String getLanguageHome(Object var1);

        public abstract void addToHostClassPath(Object var1, TruffleFile var2);

        public abstract boolean isInstrumentExceptionsAreThrown(Object var1);

        public abstract Object asBoxedGuestValue(Object var1, Object var2);

        public abstract Handler getLogHandler();

        public abstract Map<String, Level> getLogLevels(Object var1);

        public abstract LogRecord createLogRecord(Level var1, String var2, String var3, String var4, String var5, Object[] var6, Throwable var7);

        public abstract Object getCurrentOuterContext();

        public abstract TruffleLanguage.Env getLanguageEnv(Object var1, LanguageInfo var2);

        public abstract boolean isCharacterBasedSource(String var1, String var2);

        public abstract Set<String> getValidMimeTypes(String var1);

        public abstract Object asHostObject(Object var1);

        public abstract boolean isHostObject(Object var1);

        public abstract boolean isHostFunction(Object var1);

        public abstract boolean isHostSymbol(Object var1);
    }

    public static abstract class InteropSupport {
        public abstract boolean canHandle(Object var1, Object var2);

        public abstract CallTarget canHandleTarget(Object var1);

        public abstract boolean isTruffleObject(Object var1);

        public abstract void checkInteropType(Object var1);

        public abstract Object createDefaultNodeObject(Node var1);

        public abstract boolean isValidNodeObject(Object var1);
    }

    public static abstract class DumpSupport {
        public abstract void dump(Node var1, Node var2, CharSequence var3);
    }

    public static abstract class SourceSupport {
        public abstract Object getSourceIdentifier(Source var1);

        public abstract Source copySource(Source var1);

        public abstract void setPolyglotSource(Source var1, org.graalvm.polyglot.Source var2);

        public abstract org.graalvm.polyglot.Source getPolyglotSource(Source var1);

        public abstract String findMimeType(File var1) throws IOException;

        public abstract String findMimeType(URL var1) throws IOException;

        public abstract boolean isLegacySource(Source var1);

        public abstract Source.SourceBuilder newBuilder(String var1, File var2);
    }

    public static abstract class Nodes {
        public abstract boolean isInstrumentable(RootNode var1);

        public abstract boolean isTaggedWith(Node var1, Class<?> var2);

        public abstract boolean isCloneUninitializedSupported(RootNode var1);

        public abstract RootNode cloneUninitialized(RootNode var1);

        public abstract int adoptChildrenAndCount(RootNode var1);

        public abstract Object getEngineObject(LanguageInfo var1);

        public abstract TruffleLanguage<?> getLanguage(RootNode var1);

        public abstract LanguageInfo createLanguage(Object var1, String var2, String var3, String var4, String var5, Set<String> var6, boolean var7, boolean var8);

        public abstract Object getSourceVM(RootNode var1);

        public abstract int getRootNodeBits(RootNode var1);

        public abstract void setRootNodeBits(RootNode var1, int var2);

        public abstract Lock getLock(Node var1);

        public void reportPolymorphicSpecialize(Node node) {
            SUPPORT.reportPolymorphicSpecialize(node);
        }
    }
}

