/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.nodes.LanguageInfo;
import java.util.AbstractList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

final class ValueInteropList
extends AbstractList<DebugValue> {
    private final Debugger debugger;
    private final LanguageInfo language;
    private final List<Object> list;

    ValueInteropList(Debugger debugger, LanguageInfo language, List<Object> list) {
        this.debugger = debugger;
        this.language = language;
        this.list = list;
    }

    @Override
    public DebugValue get(final int index) {
        AtomicReference<Object> objRef;
        try {
            objRef = new AtomicReference<Object>(this.list.get(index));
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            throw new DebugException(this.debugger, ex, this.language, null, true, null);
        }
        final String name = Integer.toString(index);
        Map.Entry<Object, Object> elementEntry = new Map.Entry<Object, Object>(){

            @Override
            public String getKey() {
                return name;
            }

            @Override
            public Object getValue() {
                return objRef.get();
            }

            @Override
            public Object setValue(Object value) {
                ValueInteropList.this.list.set(index, value);
                return objRef.getAndSet(value);
            }
        };
        DebugValue.PropertyValue dv = new DebugValue.PropertyValue(this.debugger, this.language, 6, elementEntry, null);
        return dv;
    }

    @Override
    public DebugValue set(int index, DebugValue value) {
        DebugValue old = this.get(index);
        try {
            this.list.set(index, value.get());
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            throw new DebugException(this.debugger, ex, this.language, null, true, null);
        }
        return old;
    }

    @Override
    public int size() {
        return this.list.size();
    }
}

