/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.debug.SourceElement;
import com.oracle.truffle.api.debug.SuspendAnchor;
import com.oracle.truffle.api.instrumentation.EventContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class StepConfig {
    private static final StepConfig EMPTY = new StepConfig(null, 0);
    private final Set<SourceElement> sourceElements;
    private final int stepCount;

    StepConfig(Set<SourceElement> sourceElements, int count) {
        this.sourceElements = sourceElements;
        this.stepCount = count;
    }

    public static Builder newBuilder() {
        StepConfig stepConfig = EMPTY;
        stepConfig.getClass();
        return stepConfig.new Builder();
    }

    Set<SourceElement> getSourceElements() {
        return this.sourceElements;
    }

    private static boolean preferredAnchorMatches(SourceElement element, SuspendAnchor anchor) {
        switch (element) {
            case STATEMENT: {
                return SuspendAnchor.BEFORE == anchor;
            }
            case EXPRESSION: {
                return true;
            }
        }
        throw new IllegalStateException(element.name());
    }

    boolean matches(DebuggerSession session, EventContext context, SuspendAnchor anchor) {
        Set<SourceElement> elements = this.sourceElements;
        if (elements == null) {
            elements = session.getSourceElements();
        }
        for (SourceElement se : elements) {
            if (!context.hasTag(se.getTag()) || !StepConfig.preferredAnchorMatches(se, anchor)) continue;
            return true;
        }
        return false;
    }

    boolean containsSourceElement(DebuggerSession session, SourceElement sourceElement) {
        Set<SourceElement> elements = this.sourceElements;
        if (elements == null) {
            elements = session.getSourceElements();
        }
        return elements.contains((Object)sourceElement);
    }

    int getCount() {
        return this.stepCount;
    }

    public final class Builder {
        private Set<SourceElement> stepElements;
        private int stepCount = -1;

        private Builder() {
        }

        public Builder sourceElements(SourceElement ... elements) {
            if (this.stepElements != null) {
                throw new IllegalStateException("Step source elements can only be set once per the builder.");
            }
            if (elements.length == 0) {
                throw new IllegalArgumentException("At least one source element needs to be provided.");
            }
            this.stepElements = elements.length == 1 ? Collections.singleton(elements[0]) : Collections.unmodifiableSet(new HashSet<SourceElement>(Arrays.asList(elements)));
            return this;
        }

        public Builder count(int count) {
            if (count <= 0) {
                throw new IllegalArgumentException("Step count must be > 0");
            }
            if (this.stepCount > 0) {
                throw new IllegalStateException("Step count can only be set once per the builder.");
            }
            this.stepCount = count;
            return this;
        }

        public StepConfig build() {
            if (this.stepCount < 0) {
                this.stepCount = 1;
            }
            return new StepConfig(this.stepElements, this.stepCount);
        }
    }
}

