/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ObjectStructures {
    ObjectStructures() {
    }

    static Map<Object, Object> asMap(MessageNodes nodes, TruffleObject object) {
        TruffleObject keys;
        try {
            keys = ForeignAccess.sendKeys(nodes.keys, object, true);
            boolean hasSize = ForeignAccess.sendHasSize(nodes.hasSize, keys);
            if (!hasSize) {
                return null;
            }
        }
        catch (UnsupportedMessageException ex) {
            return null;
        }
        return new ObjectMap(nodes, object, keys);
    }

    static boolean isArray(MessageNodes nodes, TruffleObject object) {
        return ForeignAccess.sendHasSize(nodes.hasSize, object);
    }

    static List<Object> asList(MessageNodes nodes, TruffleObject object) {
        if (!ForeignAccess.sendHasSize(nodes.hasSize, object)) {
            return null;
        }
        return new ObjectList(nodes, object);
    }

    static boolean canExecute(MessageNodes nodes, TruffleObject object) {
        return ForeignAccess.sendIsExecutable(nodes.isExecutable, object);
    }

    static class MessageNodes {
        final Node keyInfo = Message.KEY_INFO.createNode();
        final Node keys = Message.KEYS.createNode();
        final Node hasSize = Message.HAS_SIZE.createNode();
        final Node getSize = Message.GET_SIZE.createNode();
        final Node read = Message.READ.createNode();
        final Node write = Message.WRITE.createNode();
        final Node isBoxed = Message.IS_BOXED.createNode();
        final Node unbox = Message.UNBOX.createNode();
        final Node isExecutable = Message.IS_EXECUTABLE.createNode();
        final Node invoke1 = Message.INVOKE.createNode();

        MessageNodes() {
        }
    }

    private static class ObjectList
    extends AbstractList<Object> {
        private final MessageNodes nodes;
        protected final TruffleObject object;

        ObjectList(MessageNodes nodes, TruffleObject object) {
            this.nodes = nodes;
            this.object = object;
        }

        @Override
        public Object get(int index) {
            try {
                return ForeignAccess.sendRead(this.nodes.read, this.object, index);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException ex) {
                throw ex.raise();
            }
        }

        @Override
        public Object set(int index, Object element) {
            Object prev = this.get(index);
            try {
                ForeignAccess.sendWrite(this.nodes.write, this.object, index, element);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException ex) {
                throw ex.raise();
            }
            return prev;
        }

        @Override
        public int size() {
            try {
                Number size = (Number)ForeignAccess.sendGetSize(this.nodes.getSize, this.object);
                return size.intValue();
            }
            catch (UnsupportedMessageException ex) {
                return 0;
            }
        }
    }

    static final class TruffleEntry
    implements Map.Entry<Object, Object> {
        private final MessageNodes nodes;
        private final TruffleObject object;
        private final Object key;

        TruffleEntry(MessageNodes nodes, TruffleObject object, Object key) {
            this.nodes = nodes;
            this.object = object;
            this.key = key;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            try {
                return ForeignAccess.sendRead(this.nodes.read, this.object, this.key);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException ex) {
                throw ex.raise();
            }
        }

        @Override
        public Object setValue(Object value) {
            Object prev = this.getValue();
            try {
                ForeignAccess.sendWrite(this.nodes.write, this.object, this.key, value);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException ex) {
                throw ex.raise();
            }
            return prev;
        }
    }

    private static class ObjectMap
    extends AbstractMap<Object, Object> {
        private final MessageNodes nodes;
        private final TruffleObject object;
        private final TruffleObject keys;

        ObjectMap(MessageNodes nodes, TruffleObject object, TruffleObject keys) {
            this.nodes = nodes;
            this.object = object;
            this.keys = keys;
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            try {
                Number size = (Number)ForeignAccess.sendGetSize(this.nodes.getSize, this.keys);
                return new LazyEntries(this.keys, size.intValue());
            }
            catch (UnsupportedMessageException ex) {
                return Collections.emptySet();
            }
        }

        @Override
        public Object get(Object key) {
            try {
                return ForeignAccess.sendRead(this.nodes.read, this.object, key);
            }
            catch (UnknownIdentifierException ex) {
                return null;
            }
            catch (UnsupportedMessageException ex) {
                throw ex.raise();
            }
        }

        @Override
        public Object put(Object key, Object value) {
            Object prev = this.get(key);
            try {
                ForeignAccess.sendWrite(this.nodes.write, this.object, key, value);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException ex) {
                throw ex.raise();
            }
            return prev;
        }

        private final class LazyEntries
        extends AbstractSet<Map.Entry<Object, Object>> {
            private final TruffleObject props;
            private final int size;

            LazyEntries(TruffleObject props, int size) {
                this.props = props;
                this.size = size;
            }

            @Override
            public Iterator<Map.Entry<Object, Object>> iterator() {
                return new LazyIterator();
            }

            @Override
            public int size() {
                return this.size;
            }

            private final class LazyIterator
            implements Iterator<Map.Entry<Object, Object>> {
                private int index = 0;

                LazyIterator() {
                }

                @Override
                public boolean hasNext() {
                    return this.index < LazyEntries.this.size;
                }

                @Override
                public Map.Entry<Object, Object> next() {
                    Object key;
                    try {
                        key = ForeignAccess.sendRead(((ObjectMap)ObjectMap.this).nodes.read, LazyEntries.this.props, this.index++);
                    }
                    catch (UnknownIdentifierException | UnsupportedMessageException ex) {
                        throw ex.raise();
                    }
                    return new TruffleEntry(ObjectMap.this.nodes, ObjectMap.this.object, key);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove not supported.");
                }
            }
        }
    }
}

