/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugScope;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.ObjectStructures;
import com.oracle.truffle.api.debug.ValueInteropList;
import com.oracle.truffle.api.debug.ValuePropertiesCollection;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.KeyInfo;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class DebugValue {
    final LanguageInfo preferredLanguage;

    abstract Object get() throws DebugException;

    DebugValue(LanguageInfo preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    public abstract void set(DebugValue var1) throws DebugException;

    public abstract void set(Object var1) throws DebugException;

    public abstract <T> T as(Class<T> var1) throws DebugException;

    public abstract String getName();

    public abstract boolean isReadable();

    @Deprecated
    public final boolean isWriteable() {
        return this.isWritable();
    }

    public abstract boolean isWritable();

    public abstract boolean isInternal();

    public DebugScope getScope() {
        return null;
    }

    public final Collection<DebugValue> getProperties() throws DebugException {
        if (!this.isReadable()) {
            throw new IllegalStateException("Value is not readable");
        }
        Object value = this.get();
        try {
            return DebugValue.getProperties(value, this.getDebugger(), this.resolveLanguage(), null);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            throw new DebugException(this.getDebugger(), ex, this.resolveLanguage(), null, true, null);
        }
    }

    static ValuePropertiesCollection getProperties(Object value, Debugger debugger, LanguageInfo language, DebugScope scope) {
        ValuePropertiesCollection properties = null;
        if (value instanceof TruffleObject) {
            TruffleObject object = (TruffleObject)value;
            Map<Object, Object> map = ObjectStructures.asMap(debugger.getMessageNodes(), object);
            if (map != null) {
                properties = new ValuePropertiesCollection(debugger, language, object, map, map.entrySet(), scope);
            }
        }
        return properties;
    }

    public final DebugValue getProperty(String name) throws DebugException {
        if (!this.isReadable()) {
            throw new IllegalStateException("Value is not readable");
        }
        Object value = this.get();
        if (value instanceof TruffleObject) {
            TruffleObject object = (TruffleObject)value;
            try {
                int keyInfo = ForeignAccess.sendKeyInfo(this.getDebugger().getMessageNodes().keyInfo, object, name);
                if (!KeyInfo.isExisting(keyInfo)) {
                    return null;
                }
                ObjectStructures.TruffleEntry entry = new ObjectStructures.TruffleEntry(this.getDebugger().getMessageNodes(), object, name);
                return new PropertyValue(this.getDebugger(), this.resolveLanguage(), keyInfo, (Map.Entry<Object, Object>)entry, null);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(this.getDebugger(), ex, this.resolveLanguage(), null, true, null);
            }
        }
        return null;
    }

    public final boolean isArray() throws DebugException {
        if (!this.isReadable()) {
            return false;
        }
        Object value = this.get();
        if (value instanceof TruffleObject) {
            TruffleObject to = (TruffleObject)value;
            return ObjectStructures.isArray(this.getDebugger().getMessageNodes(), to);
        }
        return false;
    }

    public final List<DebugValue> getArray() throws DebugException {
        if (!this.isReadable()) {
            return null;
        }
        ValueInteropList arrayList = null;
        Object value = this.get();
        if (value instanceof TruffleObject) {
            TruffleObject to = (TruffleObject)value;
            List<Object> array = ObjectStructures.asList(this.getDebugger().getMessageNodes(), to);
            if (array != null) {
                arrayList = new ValueInteropList(this.getDebugger(), this.resolveLanguage(), array);
            }
        }
        return arrayList;
    }

    final LanguageInfo resolveLanguage() {
        LanguageInfo languageInfo = this.preferredLanguage != null ? this.preferredLanguage : (this.getScope() != null && this.getScope().getLanguage() != null ? this.getScope().getLanguage() : this.getOriginalLanguage());
        return languageInfo;
    }

    public final DebugValue getMetaObject() throws DebugException {
        if (!this.isReadable()) {
            return null;
        }
        Object obj = this.get();
        if (obj == null) {
            return null;
        }
        TruffleInstrument.Env env = this.getDebugger().getEnv();
        LanguageInfo languageInfo = this.resolveLanguage();
        if (languageInfo != null) {
            try {
                obj = env.findMetaObject(languageInfo, obj);
                if (obj != null) {
                    return new HeapValue(this.getDebugger(), languageInfo, null, obj);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(this.getDebugger(), ex, languageInfo, null, true, null);
            }
        }
        return null;
    }

    public final SourceSection getSourceLocation() throws DebugException {
        if (!this.isReadable()) {
            return null;
        }
        Object obj = this.get();
        if (obj == null) {
            return null;
        }
        TruffleInstrument.Env env = this.getDebugger().getEnv();
        LanguageInfo languageInfo = this.resolveLanguage();
        if (languageInfo != null) {
            try {
                return env.findSourceLocation(languageInfo, obj);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(this.getDebugger(), ex, languageInfo, null, true, null);
            }
        }
        return null;
    }

    public final boolean canExecute() throws DebugException {
        Object value = this.get();
        if (value instanceof TruffleObject) {
            TruffleObject to = (TruffleObject)value;
            try {
                return ObjectStructures.canExecute(this.getDebugger().getMessageNodes(), to);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(this.getDebugger(), ex, this.resolveLanguage(), null, true, null);
            }
        }
        return false;
    }

    public final LanguageInfo getOriginalLanguage() throws DebugException {
        if (!this.isReadable()) {
            return null;
        }
        Object obj = this.get();
        if (obj == null) {
            return null;
        }
        return this.getDebugger().getEnv().findLanguage(obj);
    }

    public final DebugValue asInLanguage(LanguageInfo language) {
        if (this.preferredLanguage == language) {
            return this;
        }
        return this.createAsInLanguage(language);
    }

    abstract DebugValue createAsInLanguage(LanguageInfo var1);

    abstract Debugger getDebugger();

    public String toString() {
        return "DebugValue(name=" + this.getName() + ", value = " + this.as(String.class) + ")";
    }

    private static void checkPrimitive(Object value) {
        Class<?> clazz;
        if (value == null || (clazz = value.getClass()) != Byte.class && clazz != Short.class && clazz != Integer.class && clazz != Long.class && clazz != Float.class && clazz != Double.class && clazz != Character.class && clazz != Boolean.class && clazz != String.class) {
            throw new IllegalArgumentException(value + " is not primitive.");
        }
    }

    static final class PropertyNamedValue
    extends HeapValue {
        private final int keyInfo;
        private final Map<Object, Object> map;
        private final DebugScope scope;

        PropertyNamedValue(Debugger debugger, LanguageInfo language, TruffleObject object, Map<Object, Object> map, String name, DebugScope scope) {
            this(debugger, language, ForeignAccess.sendKeyInfo(Message.KEY_INFO.createNode(), object, name), map, name, scope);
        }

        private PropertyNamedValue(Debugger debugger, LanguageInfo preferredLanguage, int keyInfo, Map<Object, Object> map, String name, DebugScope scope) {
            super(debugger, preferredLanguage, name, null);
            this.keyInfo = keyInfo;
            this.map = map;
            this.scope = scope;
        }

        @Override
        Object get() {
            this.checkValid();
            try {
                return this.map.get(this.getName());
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(this.getDebugger(), ex, this.resolveLanguage(), null, true, null);
            }
        }

        @Override
        public DebugScope getScope() {
            this.checkValid();
            return this.scope;
        }

        @Override
        public boolean isReadable() {
            this.checkValid();
            return KeyInfo.isReadable(this.keyInfo);
        }

        @Override
        public boolean isWritable() {
            this.checkValid();
            return KeyInfo.isWritable(this.keyInfo);
        }

        @Override
        public boolean isInternal() {
            this.checkValid();
            return KeyInfo.isInternal(this.keyInfo);
        }

        @Override
        public void set(DebugValue value) {
            this.checkValid();
            try {
                this.map.put(this.getName(), value.get());
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(this.getDebugger(), ex, this.resolveLanguage(), null, true, null);
            }
        }

        @Override
        public void set(Object primitiveValue) {
            this.checkValid();
            DebugValue.checkPrimitive(primitiveValue);
            try {
                this.map.put(this.getName(), primitiveValue);
            }
            catch (Throwable ex) {
                throw new DebugException(this.getDebugger(), ex, this.resolveLanguage(), null, true, null);
            }
        }

        @Override
        DebugValue createAsInLanguage(LanguageInfo language) {
            return new PropertyNamedValue(this.getDebugger(), language, this.keyInfo, this.map, this.getName(), this.scope);
        }

        private void checkValid() {
            if (this.scope != null) {
                this.scope.verifyValidState();
            }
        }
    }

    static final class PropertyValue
    extends HeapValue {
        private final int keyInfo;
        private final Map.Entry<Object, Object> property;
        private final DebugScope scope;

        PropertyValue(Debugger debugger, LanguageInfo language, TruffleObject object, Map.Entry<Object, Object> property, DebugScope scope) {
            this(debugger, language, ForeignAccess.sendKeyInfo(Message.KEY_INFO.createNode(), object, property.getKey()), property, scope);
        }

        PropertyValue(Debugger debugger, LanguageInfo preferredLanguage, int keyInfo, Map.Entry<Object, Object> property, DebugScope scope) {
            super(debugger, preferredLanguage, property.getKey() instanceof String ? (String)property.getKey() : null, null);
            this.keyInfo = keyInfo;
            this.property = property;
            this.scope = scope;
        }

        @Override
        Object get() {
            this.checkValid();
            try {
                return this.property.getValue();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(this.getDebugger(), ex, this.resolveLanguage(), null, true, null);
            }
        }

        @Override
        public String getName() {
            String name = super.getName();
            if (name != null) {
                return name;
            }
            this.checkValid();
            Object propertyKey = this.property.getKey();
            LanguageInfo languageInfo = this.resolveLanguage();
            name = languageInfo != null ? this.getDebugger().getEnv().toString(languageInfo, propertyKey) : Objects.toString(propertyKey);
            return name;
        }

        @Override
        public boolean isReadable() {
            this.checkValid();
            return KeyInfo.isReadable(this.keyInfo);
        }

        @Override
        public boolean isWritable() {
            this.checkValid();
            return KeyInfo.isWritable(this.keyInfo);
        }

        @Override
        public boolean isInternal() {
            this.checkValid();
            return KeyInfo.isInternal(this.keyInfo);
        }

        @Override
        public DebugScope getScope() {
            this.checkValid();
            return this.scope;
        }

        @Override
        public void set(DebugValue value) {
            this.checkValid();
            try {
                this.property.setValue(value.get());
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(this.getDebugger(), ex, this.resolveLanguage(), null, true, null);
            }
        }

        @Override
        public void set(Object primitiveValue) {
            this.checkValid();
            DebugValue.checkPrimitive(primitiveValue);
            try {
                this.property.setValue(primitiveValue);
            }
            catch (Throwable ex) {
                throw new DebugException(this.getDebugger(), ex, this.resolveLanguage(), null, true, null);
            }
        }

        @Override
        DebugValue createAsInLanguage(LanguageInfo language) {
            return new PropertyValue(this.getDebugger(), language, this.keyInfo, this.property, this.scope);
        }

        private void checkValid() {
            if (this.scope != null) {
                this.scope.verifyValidState();
            }
        }
    }

    static class HeapValue
    extends DebugValue {
        private final Debugger debugger;
        private final String name;
        private final Object value;

        HeapValue(Debugger debugger, String name, Object value) {
            this(debugger, null, name, value);
        }

        HeapValue(Debugger debugger, LanguageInfo preferredLanguage, String name, Object value) {
            super(preferredLanguage);
            this.debugger = debugger;
            this.name = name;
            this.value = value;
        }

        @Override
        public <T> T as(Class<T> clazz) throws DebugException {
            if (!this.isReadable()) {
                throw new IllegalStateException("Value is not readable");
            }
            try {
                if (clazz == String.class) {
                    Object val = this.get();
                    LanguageInfo languageInfo = this.resolveLanguage();
                    String stringValue = languageInfo == null ? val.toString() : this.debugger.getEnv().toString(languageInfo, val);
                    return clazz.cast(stringValue);
                }
                if (clazz == Number.class || clazz == Boolean.class) {
                    return this.convertToPrimitive(clazz);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(this.getDebugger(), ex, this.resolveLanguage(), null, true, null);
            }
            throw new UnsupportedOperationException();
        }

        private <T> T convertToPrimitive(Class<T> clazz) {
            TruffleObject receiver;
            Object val = this.get();
            if (clazz.isInstance(val)) {
                return clazz.cast(val);
            }
            if (val instanceof TruffleObject && ForeignAccess.sendIsBoxed(this.debugger.msgNodes.isBoxed, receiver = (TruffleObject)val)) {
                try {
                    Object unboxed = ForeignAccess.sendUnbox(this.debugger.msgNodes.unbox, receiver);
                    if (clazz.isInstance(unboxed)) {
                        return clazz.cast(unboxed);
                    }
                }
                catch (UnsupportedMessageException e) {
                    throw new AssertionError((Object)"isBoxed returned true but unbox threw unsupported error.");
                }
            }
            return null;
        }

        @Override
        Object get() {
            return this.value;
        }

        @Override
        public void set(DebugValue expression) {
            throw new IllegalStateException("Value is not writable");
        }

        @Override
        public void set(Object primitiveValue) {
            throw new IllegalStateException("Value is not writable");
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public boolean isInternal() {
            return false;
        }

        @Override
        DebugValue createAsInLanguage(LanguageInfo language) {
            return new HeapValue(this.debugger, language, this.name, this.value);
        }

        @Override
        Debugger getDebugger() {
            return this.debugger;
        }
    }
}

