/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.debug.DebuggerTags;
import com.oracle.truffle.api.debug.SourceElement;
import com.oracle.truffle.api.debug.SuspendAnchor;
import com.oracle.truffle.api.debug.SuspendableLocationFinder;
import com.oracle.truffle.api.debug.SuspensionFilter;
import com.oracle.truffle.api.instrumentation.SourceFilter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.net.URI;
import java.util.function.Predicate;

abstract class BreakpointLocation {
    static final BreakpointLocation ANY = new BreakpointSourceLocation();

    BreakpointLocation() {
    }

    static BreakpointLocation create(Object key, SourceElement[] sourceElements, SourceSection sourceSection) {
        return new BreakpointSourceLocation(key, sourceElements, sourceSection);
    }

    static BreakpointLocation create(Object key, SourceElement[] sourceElements, int line, int column) {
        return new BreakpointSourceLocation(key, sourceElements, line, column);
    }

    static BreakpointLocation create(SourceElement[] sourceElements, SuspensionFilter filter) {
        return new BreakpointFilteredLocation(sourceElements, filter);
    }

    abstract SourceFilter createSourceFilter();

    abstract SourceSection adjustLocation(Source var1, TruffleInstrument.Env var2, SuspendAnchor var3);

    abstract SourceSectionFilter createLocationFilter(Source var1, SuspendAnchor var2);

    private static void setTags(SourceSectionFilter.Builder f, SourceElement[] sourceElements) {
        Class[] elementTags = new Class[sourceElements.length];
        for (int i = 0; i < elementTags.length; ++i) {
            elementTags[i] = sourceElements[i].getTag();
        }
        f.tagIs(elementTags);
    }

    private static final class BreakpointFilteredLocation
    extends BreakpointLocation {
        private final SuspensionFilter filter;
        private final SourceElement[] sourceElements;

        BreakpointFilteredLocation(SourceElement[] sourceElements, SuspensionFilter filter) {
            this.filter = filter;
            this.sourceElements = sourceElements;
        }

        @Override
        SourceFilter createSourceFilter() {
            return null;
        }

        @Override
        SourceSection adjustLocation(Source source, TruffleInstrument.Env env, SuspendAnchor suspendAnchor) {
            return null;
        }

        @Override
        SourceSectionFilter createLocationFilter(Source source, SuspendAnchor suspendAnchor) {
            SourceSectionFilter.Builder f = SourceSectionFilter.newBuilder();
            SourceFilter.Builder sourceFilterBuilder = SourceFilter.newBuilder();
            if (this.filter != null) {
                Predicate<Source> sourcePredicate = this.filter.getSourcePredicate();
                if (sourcePredicate != null) {
                    sourceFilterBuilder.sourceIs(sourcePredicate);
                }
                sourceFilterBuilder.includeInternal(this.filter.isInternalIncluded());
            }
            SourceFilter sourceFilter = sourceFilterBuilder.build();
            f.sourceFilter(sourceFilter);
            BreakpointLocation.setTags(f, this.sourceElements);
            return f.build();
        }
    }

    private static final class BreakpointSourceLocation
    extends BreakpointLocation {
        private final Object key;
        private final SourceElement[] sourceElements;
        private final SourceSection sourceSection;
        private int line;
        private int column;

        BreakpointSourceLocation(Object key, SourceElement[] sourceElements, SourceSection sourceSection) {
            assert (key instanceof Source || key instanceof URI);
            this.key = key;
            this.sourceElements = sourceElements;
            this.sourceSection = sourceSection;
            this.line = -1;
            this.column = -1;
        }

        BreakpointSourceLocation(Object key, SourceElement[] sourceElements, int line, int column) {
            assert (key instanceof Source || key instanceof URI);
            assert (line > 0);
            assert (column > 0 || column == -1);
            this.key = key;
            this.sourceElements = sourceElements;
            this.line = line;
            this.column = column;
            this.sourceSection = null;
        }

        private BreakpointSourceLocation() {
            this.key = null;
            this.sourceElements = null;
            this.line = -1;
            this.column = -1;
            this.sourceSection = null;
        }

        @Override
        SourceFilter createSourceFilter() {
            if (this.key == null) {
                return SourceFilter.ANY;
            }
            SourceFilter.Builder f = SourceFilter.newBuilder();
            if (this.key instanceof URI) {
                final URI sourceUri = (URI)this.key;
                f.sourceIs(new Predicate<Source>(){

                    @Override
                    public boolean test(Source s) {
                        URI uri = s.getURI();
                        return sourceUri.equals(uri);
                    }

                    public String toString() {
                        return "URI equals " + sourceUri;
                    }
                });
            } else {
                assert (this.key instanceof Source);
                Source s = (Source)this.key;
                f.sourceIs(s);
            }
            return f.build();
        }

        @Override
        SourceSection adjustLocation(Source source, TruffleInstrument.Env env, SuspendAnchor suspendAnchor) {
            if (this.sourceSection != null) {
                return this.sourceSection;
            }
            if (this.key == null) {
                return null;
            }
            boolean hasColumn = this.column > 0;
            SourceSection location = SuspendableLocationFinder.findNearest(source, this.sourceElements, this.line, this.column, suspendAnchor, env);
            if (location != null) {
                switch (suspendAnchor) {
                    case BEFORE: {
                        this.line = location.getStartLine();
                        if (!hasColumn) break;
                        this.column = location.getStartColumn();
                        break;
                    }
                    case AFTER: {
                        this.line = location.getEndLine();
                        if (!hasColumn) break;
                        this.column = location.getEndColumn();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown suspend anchor: " + (Object)((Object)suspendAnchor));
                    }
                }
            }
            return location;
        }

        @Override
        SourceSectionFilter createLocationFilter(Source source, SuspendAnchor suspendAnchor) {
            SourceSectionFilter.Builder f = SourceSectionFilter.newBuilder();
            if (this.key == null) {
                return f.tagIs(DebuggerTags.AlwaysHalt.class).build();
            }
            if (source != null) {
                f.sourceIs(source);
            } else {
                f.sourceFilter(this.createSourceFilter());
            }
            if (this.line != -1) {
                switch (suspendAnchor) {
                    case BEFORE: {
                        f.lineStartsIn(SourceSectionFilter.IndexRange.byLength(this.line, 1));
                        if (this.column == -1) break;
                        f.columnStartsIn(SourceSectionFilter.IndexRange.byLength(this.column, 1));
                        break;
                    }
                    case AFTER: {
                        f.lineEndsIn(SourceSectionFilter.IndexRange.byLength(this.line, 1));
                        if (this.column == -1) break;
                        f.columnEndsIn(SourceSectionFilter.IndexRange.byLength(this.column, 1));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(suspendAnchor.name());
                    }
                }
            }
            if (this.sourceSection != null) {
                f.sourceSectionEquals(this.sourceSection);
            }
            BreakpointLocation.setTags(f, this.sourceElements);
            return f.build();
        }

        public String toString() {
            String keyDescription = this.key == null ? "AlwaysHalt" : (this.key instanceof Source ? "sourceName=" + ((Source)this.key).getName() : (this.key instanceof URI ? "uri=" + ((URI)this.key).toString() : this.key.toString()));
            return keyDescription + ", line=" + this.line + ", column=" + this.column;
        }
    }
}

