/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.graalvm.polyglot.io.FileSystem;

public final class TruffleFile {
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    private static final int BUFFER_SIZE = 8192;
    private final FileSystem fileSystem;
    private final Path path;
    private final Path normalizedPath;

    TruffleFile(FileSystem fileSystem, Path path) {
        this(fileSystem, path, path.normalize());
    }

    TruffleFile(FileSystem fileSystem, Path path, Path normalizedPath) {
        Objects.requireNonNull(fileSystem, "FileSystem must not be null.");
        Objects.requireNonNull(path, "Path must not be null.");
        Objects.requireNonNull(normalizedPath, "NormalizedPath must not be null.");
        this.fileSystem = fileSystem;
        this.path = path;
        this.normalizedPath = normalizedPath;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean exists(LinkOption ... options) {
        try {
            return this.checkAccess(EnumSet.noneOf(AccessMode.class), options);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isReadable() {
        try {
            return this.checkAccess(AccessMode.READ);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isWritable() {
        try {
            return this.checkAccess(AccessMode.WRITE);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isExecutable() {
        try {
            return this.checkAccess(AccessMode.EXECUTE);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isDirectory(LinkOption ... options) {
        try {
            return this.getAttributeImpl("isDirectory", Boolean.class, options);
        }
        catch (IOException ioe) {
            return false;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isRegularFile(LinkOption ... options) {
        try {
            return this.getAttributeImpl("isRegularFile", Boolean.class, options);
        }
        catch (IOException ioe) {
            return false;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isSymbolicLink() {
        try {
            return this.getAttributeImpl("isSymbolicLink", Boolean.class, new LinkOption[0]);
        }
        catch (IOException ioe) {
            return false;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isAbsolute() {
        try {
            return this.path.isAbsolute();
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public String getName() {
        try {
            return this.path.getFileName().toString();
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public String getPath() {
        try {
            return this.path.toString();
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public URI toUri() {
        try {
            Path absolutePath = this.path.isAbsolute() ? this.path : this.toAbsolutePathImpl()[0];
            return absolutePath.toUri();
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleFile getAbsoluteFile() {
        if (this.path.isAbsolute()) {
            return this;
        }
        try {
            Path[] absolutePaths = this.toAbsolutePathImpl();
            return new TruffleFile(this.fileSystem, absolutePaths[0], absolutePaths[1]);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleFile getCanonicalFile(LinkOption ... options) throws IOException {
        try {
            return new TruffleFile(this.fileSystem, this.fileSystem.toRealPath(this.path, options));
        }
        catch (IOException | SecurityException e) {
            throw e;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleFile getParent() {
        try {
            Path parent = this.path.getParent();
            return parent == null ? null : new TruffleFile(this.fileSystem, parent);
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleFile resolve(String name) {
        try {
            return new TruffleFile(this.fileSystem, this.path.resolve(name));
        }
        catch (InvalidPathException ip) {
            throw ip;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleFile resolveSibling(String name) {
        try {
            return new TruffleFile(this.fileSystem, this.path.resolveSibling(name));
        }
        catch (InvalidPathException ip) {
            throw ip;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public long size(LinkOption ... options) throws IOException {
        try {
            return this.getAttributeImpl("size", Long.class, options);
        }
        catch (IOException | SecurityException e) {
            throw e;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public FileTime getLastModifiedTime(LinkOption ... options) throws IOException {
        try {
            return this.getAttributeImpl("lastModifiedTime", FileTime.class, options);
        }
        catch (IOException | SecurityException e) {
            throw e;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void setLastModifiedTime(FileTime time, LinkOption ... options) throws IOException {
        try {
            this.fileSystem.setAttribute(this.normalizedPath, "lastModifiedTime", (Object)time, options);
        }
        catch (IOException | SecurityException e) {
            throw e;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public FileTime getLastAccessTime(LinkOption ... options) throws IOException {
        try {
            return this.getAttributeImpl("lastAccessTime", FileTime.class, options);
        }
        catch (IOException | SecurityException e) {
            throw e;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void setLastAccessTime(FileTime time, LinkOption ... options) throws IOException {
        try {
            this.fileSystem.setAttribute(this.normalizedPath, "lastAccessTime", (Object)time, options);
        }
        catch (IOException | SecurityException e) {
            throw e;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public FileTime getCreationTime(LinkOption ... options) throws IOException {
        try {
            return this.getAttributeImpl("creationTime", FileTime.class, options);
        }
        catch (IOException | SecurityException e) {
            throw e;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void setCreationTime(FileTime time, LinkOption ... options) throws IOException {
        try {
            this.fileSystem.setAttribute(this.normalizedPath, "creationTime", (Object)time, options);
        }
        catch (IOException | SecurityException e) {
            throw e;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Collection<TruffleFile> list() throws IOException {
        try {
            ArrayList<TruffleFile> result = new ArrayList<TruffleFile>();
            boolean normalized = this.isNormalized();
            try (DirectoryStream stream = this.fileSystem.newDirectoryStream(this.normalizedPath, AllFiles.INSTANCE);){
                for (Path p : stream) {
                    result.add(new TruffleFile(this.fileSystem, normalized ? p : this.path.resolve(p.getFileName()), p));
                }
            }
            return result;
        }
        catch (IOException | SecurityException e) {
            throw e;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public SeekableByteChannel newByteChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attributes) throws IOException {
        try {
            return ByteChannelDecorator.create(this.fileSystem.newByteChannel(this.normalizedPath, options, (FileAttribute[])attributes));
        }
        catch (IOException | IllegalArgumentException | SecurityException | UnsupportedOperationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public InputStream newInputStream(OpenOption ... options) throws IOException {
        HashSet<OpenOption> openOptions = new HashSet<OpenOption>();
        if (options.length > 0) {
            for (OpenOption option : options) {
                if (option == StandardOpenOption.APPEND || option == StandardOpenOption.WRITE) {
                    throw new IllegalArgumentException(String.format("Option %s is not allowed.", option));
                }
                openOptions.add(option);
            }
        }
        return Channels.newInputStream(this.newByteChannel(openOptions, new FileAttribute[0]));
    }

    @CompilerDirectives.TruffleBoundary
    public BufferedReader newBufferedReader(Charset charset) throws IOException {
        return new BufferedReader(new InputStreamReader(this.newInputStream(new OpenOption[0]), charset));
    }

    @CompilerDirectives.TruffleBoundary
    public BufferedReader newBufferedReader() throws IOException {
        return this.newBufferedReader(StandardCharsets.UTF_8);
    }

    /*
     * Exception decompiling
     */
    @CompilerDirectives.TruffleBoundary
    public byte[] readAllBytes() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @CompilerDirectives.TruffleBoundary
    public OutputStream newOutputStream(OpenOption ... options) throws IOException {
        HashSet<OpenOption> openOptions = new HashSet<OpenOption>(Math.max(options.length, 2) + 1);
        openOptions.add(StandardOpenOption.WRITE);
        if (options.length == 0) {
            openOptions.add(StandardOpenOption.CREATE);
            openOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
        } else {
            for (OpenOption option : options) {
                if (option == StandardOpenOption.READ) {
                    throw new IllegalArgumentException(String.format("Option %s is not allowed.", option));
                }
                openOptions.add(option);
            }
        }
        return Channels.newOutputStream(this.newByteChannel(openOptions, new FileAttribute[0]));
    }

    @CompilerDirectives.TruffleBoundary
    public BufferedWriter newBufferedWriter(Charset charset, OpenOption ... options) throws IOException {
        return new BufferedWriter(new OutputStreamWriter(this.newOutputStream(options), charset));
    }

    @CompilerDirectives.TruffleBoundary
    public BufferedWriter newBufferedWriter(OpenOption ... options) throws IOException {
        return this.newBufferedWriter(StandardCharsets.UTF_8, options);
    }

    @CompilerDirectives.TruffleBoundary
    public void createFile(FileAttribute<?> ... attributes) throws IOException {
        this.newByteChannel(EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW), attributes).close();
    }

    @CompilerDirectives.TruffleBoundary
    public void createDirectory(FileAttribute<?> ... attributes) throws IOException {
        try {
            this.createDirectoryImpl(this.normalizedPath, attributes);
        }
        catch (IOException | SecurityException | UnsupportedOperationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    /*
     * Exception decompiling
     */
    @CompilerDirectives.TruffleBoundary
    public void createDirectories(FileAttribute<?> ... attributes) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @CompilerDirectives.TruffleBoundary
    public void delete() throws IOException {
        try {
            this.fileSystem.delete(this.normalizedPath);
        }
        catch (IOException | SecurityException e) {
            throw e;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void move(TruffleFile target, CopyOption ... options) throws IOException {
        try {
            this.fileSystem.move(this.normalizedPath, target.normalizedPath, options);
        }
        catch (IOException | SecurityException | UnsupportedOperationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Set<PosixFilePermission> getPosixPermissions(LinkOption ... linkOptions) throws IOException {
        try {
            return (Set)this.getAttributeImpl(this.normalizedPath, "posix:permissions", linkOptions);
        }
        catch (IOException | SecurityException | UnsupportedOperationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void setPosixPermissions(Set<? extends PosixFilePermission> permissions, LinkOption ... linkOptions) throws IOException {
        try {
            this.fileSystem.setAttribute(this.normalizedPath, "posix:permissions", permissions, linkOptions);
        }
        catch (IOException | SecurityException | UnsupportedOperationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw this.wrapHostException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.path.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public int hashCode() {
        int res = 17;
        res = res * 31 + this.fileSystem.hashCode();
        res = res * 31 + this.path.hashCode();
        return res;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != TruffleFile.class) {
            return false;
        }
        TruffleFile otherFile = (TruffleFile)other;
        return this.path.equals(otherFile.path) && this.fileSystem.equals(otherFile.fileSystem);
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleFile normalize() {
        if (this.isNormalized()) {
            return this;
        }
        return new TruffleFile(this.fileSystem, this.normalizedPath, this.normalizedPath);
    }

    private boolean isNormalized() {
        return this.path == this.normalizedPath || this.path.equals(this.normalizedPath);
    }

    private Path[] toAbsolutePathImpl() {
        Path normalizedAbsolute = this.fileSystem.toAbsolutePath(this.normalizedPath);
        if (this.isNormalized()) {
            return new Path[]{normalizedAbsolute, normalizedAbsolute};
        }
        Path root = this.fileSystem.parsePath("/");
        boolean emptyPath = this.normalizedPath.getFileName().getNameCount() == 1 && this.normalizedPath.getFileName().toString().isEmpty();
        Path absolute = root.resolve(normalizedAbsolute.subpath(0, normalizedAbsolute.getNameCount() - (emptyPath ? 0 : this.normalizedPath.getNameCount()))).resolve(this.path);
        return new Path[]{absolute, normalizedAbsolute};
    }

    private boolean checkAccess(AccessMode ... modes) {
        EnumSet<AccessMode> modesSet = EnumSet.noneOf(AccessMode.class);
        Collections.addAll(modesSet, modes);
        return this.checkAccess(modesSet, new LinkOption[0]);
    }

    private boolean checkAccess(Set<? extends AccessMode> modes, LinkOption ... linkOptions) {
        try {
            this.fileSystem.checkAccess(this.normalizedPath, modes, linkOptions);
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private <T> T getAttributeImpl(String attribute, Class<T> type, LinkOption ... options) throws IOException {
        return this.getAttributeImpl(this.normalizedPath, attribute, type, options);
    }

    private <T> T getAttributeImpl(Path forPath, String attribute, Class<T> type, LinkOption ... options) throws IOException {
        Object value = this.getAttributeImpl(forPath, attribute, options);
        return value == null ? null : (T)type.cast(value);
    }

    private Object getAttributeImpl(Path forPath, String attribute, LinkOption ... options) throws IOException {
        Map map = this.fileSystem.readAttributes(forPath, attribute, options);
        int index = attribute.indexOf(58);
        String key = index < 0 ? attribute : attribute.substring(index + 1);
        return map.get(key);
    }

    private Path createDirectoryImpl(Path dir, FileAttribute<?> ... attrs) throws IOException {
        this.fileSystem.createDirectory(dir, (FileAttribute[])attrs);
        return dir;
    }

    private Path createDirAndCheck(Path dir, FileAttribute<?> ... attrs) throws IOException {
        try {
            return this.createDirectoryImpl(dir, attrs);
        }
        catch (FileAlreadyExistsException faee) {
            try {
                if (this.getAttributeImpl(dir, "isDirectory", Boolean.class, LinkOption.NOFOLLOW_LINKS).booleanValue()) {
                    return dir;
                }
                throw faee;
            }
            catch (IOException ioe) {
                throw faee;
            }
        }
    }

    private Path findExisting(Path forPath) throws IOException {
        EnumSet<AccessMode> mode = EnumSet.noneOf(AccessMode.class);
        for (Path p = forPath.getParent(); p != null; p = p.getParent()) {
            try {
                this.fileSystem.checkAccess(p, mode, new LinkOption[0]);
                return p;
            }
            catch (NoSuchFileException noSuchFileException) {
                continue;
            }
        }
        return null;
    }

    private <T extends Throwable> RuntimeException wrapHostException(T t) {
        if (TruffleLanguage.AccessAPI.engineAccess().isDefaultFileSystem(this.fileSystem)) {
            throw TruffleFile.sthrow(t);
        }
        throw TruffleLanguage.AccessAPI.engineAccess().wrapHostException(null, t);
    }

    private static <T extends RuntimeException> T sthrow(Throwable t) throws T {
        throw (RuntimeException)t;
    }

    static final class FileAdapter
    extends File {
        private final TruffleFile truffleFile;

        FileAdapter(TruffleFile truffleFile) {
            super(truffleFile.getPath());
            this.truffleFile = truffleFile;
        }

        TruffleFile getTruffleFile() {
            return this.truffleFile;
        }

        @Override
        public String getName() {
            return this.truffleFile.getName();
        }

        @Override
        public String getPath() {
            return this.truffleFile.getPath();
        }

        @Override
        public File getAbsoluteFile() {
            return new FileAdapter(this.truffleFile.getAbsoluteFile());
        }

        @Override
        public File getCanonicalFile() throws IOException {
            return new FileAdapter(this.truffleFile.getCanonicalFile(new LinkOption[0]));
        }

        @Override
        public URI toURI() {
            return this.truffleFile.toUri();
        }
    }

    private static final class ByteChannelDecorator
    implements SeekableByteChannel {
        private final SeekableByteChannel delegate;

        ByteChannelDecorator(SeekableByteChannel delegate) {
            this.delegate = delegate;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return this.delegate.read(dst);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.delegate.write(src);
        }

        @Override
        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public long position() throws IOException {
            return this.delegate.position();
        }

        @Override
        public SeekableByteChannel position(long newPosition) throws IOException {
            this.delegate.position(newPosition);
            return this;
        }

        @Override
        public long size() throws IOException {
            return this.delegate.size();
        }

        @Override
        public SeekableByteChannel truncate(long size) throws IOException {
            this.delegate.truncate(size);
            return this;
        }

        static SeekableByteChannel create(SeekableByteChannel delegate) {
            Objects.requireNonNull(delegate, "Delegate must be non null.");
            return new ByteChannelDecorator(delegate);
        }
    }

    private static final class AllFiles
    implements DirectoryStream.Filter<Path> {
        static final DirectoryStream.Filter<Path> INSTANCE = new AllFiles();

        private AllFiles() {
        }

        @Override
        public boolean accept(Path entry) throws IOException {
            return true;
        }
    }
}

