/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;

public interface TruffleException {
    public Node getLocation();

    default public Object getExceptionObject() {
        return null;
    }

    default public boolean isSyntaxError() {
        return false;
    }

    default public boolean isIncompleteSource() {
        return false;
    }

    default public boolean isInternalError() {
        return false;
    }

    default public boolean isCancelled() {
        return false;
    }

    @Deprecated
    default public boolean isTimeout() {
        return this.isCancelled();
    }

    default public boolean isExit() {
        return false;
    }

    default public int getExitStatus() {
        return 0;
    }

    default public int getStackTraceElementLimit() {
        return -1;
    }

    default public SourceSection getSourceLocation() {
        Node node = this.getLocation();
        return node == null ? null : node.getEncapsulatingSourceSection();
    }
}

