/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TruffleContext
implements AutoCloseable {
    static final TruffleContext EMPTY = new TruffleContext();
    private static ThreadLocal<List<Object>> assertStack;
    final Object impl;
    final boolean closeable;

    TruffleContext(Object impl) {
        this.impl = impl;
        this.closeable = false;
    }

    private TruffleContext(TruffleLanguage.Env env, Map<String, Object> config) {
        this.impl = TruffleLanguage.AccessAPI.engineAccess().createInternalContext(env.getVMObject(), config, this);
        this.closeable = false;
        TruffleLanguage.AccessAPI.engineAccess().initializeInternalContext(env.getVMObject(), this.impl);
    }

    private TruffleContext(Object impl, boolean closeable) {
        this.impl = impl;
        this.closeable = closeable;
    }

    private TruffleContext() {
        this.impl = null;
        this.closeable = false;
    }

    private static boolean initializeAssertStack() {
        assertStack = new ThreadLocal<List<Object>>(){

            @Override
            protected List<Object> initialValue() {
                return new ArrayList<Object>();
            }
        };
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleContext getParent() {
        return TruffleLanguage.AccessAPI.engineAccess().getParentContext(this.impl);
    }

    public Object enter() {
        Object prev = TruffleLanguage.AccessAPI.engineAccess().enterInternalContext(this.impl);
        assert (TruffleContext.verifyEnter(prev));
        return prev;
    }

    public void leave(Object prev) {
        assert (TruffleContext.verifyLeave(prev));
        TruffleLanguage.AccessAPI.engineAccess().leaveInternalContext(this.impl, prev);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void close() {
        if (!this.closeable) {
            throw new UnsupportedOperationException("It's not possible to close a foreign context.");
        }
        TruffleLanguage.AccessAPI.engineAccess().closeInternalContext(this.impl);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean verifyEnter(Object prev) {
        assertStack.get().add(prev);
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean verifyLeave(Object prev) {
        List<Object> list = assertStack.get();
        assert (list.size() > 0) : "Assert stack is empty.";
        Object expectedPrev = list.get(list.size() - 1);
        assert (prev == expectedPrev) : "Invalid prev argument provided in TruffleContext.leave(Object).";
        list.remove(list.size() - 1);
        return true;
    }

    static {
        assert (TruffleContext.initializeAssertStack());
    }

    public final class Builder {
        private final TruffleLanguage.Env sourceEnvironment;
        private Map<String, Object> config;

        Builder(TruffleLanguage.Env env) {
            this.sourceEnvironment = env;
        }

        @CompilerDirectives.TruffleBoundary
        public Builder config(String key, Object value) {
            if (this.config == null) {
                this.config = new HashMap<String, Object>();
            }
            this.config.put(key, value);
            return this;
        }

        @CompilerDirectives.TruffleBoundary
        public TruffleContext build() {
            TruffleContext context = new TruffleContext(this.sourceEnvironment, this.config);
            return new TruffleContext(context.impl, true);
        }
    }
}

