/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.TruffleRuntime;
import com.oracle.truffle.api.TruffleRuntimeAccess;
import com.oracle.truffle.api.impl.DefaultTruffleRuntime;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ServiceLoader;

public class Truffle {
    private static final TruffleRuntime RUNTIME = Truffle.initRuntime();

    @Deprecated
    public Truffle() {
    }

    public static TruffleRuntime getRuntime() {
        return RUNTIME;
    }

    @SafeVarargs
    private static TruffleRuntimeAccess selectTruffleRuntimeAccess(Iterable<TruffleRuntimeAccess> ... lookups) {
        TruffleRuntimeAccess selectedAccess = null;
        for (Iterable<TruffleRuntimeAccess> lookup : lookups) {
            if (lookup == null) continue;
            for (TruffleRuntimeAccess access : lookup) {
                if (selectedAccess == null) {
                    selectedAccess = access;
                    continue;
                }
                if (selectedAccess == access || selectedAccess.getClass() == access.getClass()) continue;
                if (selectedAccess.getPriority() == access.getPriority()) {
                    throw new InternalError(String.format("Providers for %s with same priority %d: %s (loader: %s) vs. %s (loader: %s)", TruffleRuntimeAccess.class.getName(), access.getPriority(), selectedAccess, selectedAccess.getClass().getClassLoader(), access, access.getClass().getClassLoader()));
                }
                if (selectedAccess.getPriority() >= access.getPriority()) continue;
                selectedAccess = access;
            }
        }
        return selectedAccess;
    }

    private static Iterable<TruffleRuntimeAccess> reflectiveServiceLoaderLoad(Class<?> servicesClass) {
        try {
            Method m = servicesClass.getDeclaredMethod("load", Class.class);
            return (Iterable)m.invoke(null, TruffleRuntimeAccess.class);
        }
        catch (Throwable e) {
            throw (InternalError)new InternalError().initCause(e);
        }
    }

    private static Iterable<TruffleRuntimeAccess> getJVMCIProviders() {
        String[] serviceClassNames;
        ClassLoader scl = ClassLoader.getSystemClassLoader();
        for (ClassLoader cl = Truffle.class.getClassLoader(); cl != null; cl = cl.getParent()) {
            if (cl != scl) continue;
            return null;
        }
        for (String serviceClassName : serviceClassNames = new String[]{"jdk.vm.ci.services.Services", "jdk.vm.ci.service.Services", "jdk.internal.jvmci.service.Services", "com.oracle.jvmci.service.Services"}) {
            try {
                return Truffle.reflectiveServiceLoaderLoad(Class.forName(serviceClassName));
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    private static TruffleRuntime initRuntime() {
        return AccessController.doPrivileged(new PrivilegedAction<TruffleRuntime>(){

            @Override
            public TruffleRuntime run() {
                TruffleRuntimeAccess access;
                boolean jdk8OrEarlier;
                String runtimeClassName = System.getProperty("truffle.TruffleRuntime");
                if (runtimeClassName != null) {
                    try {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        Class<?> runtimeClass = Class.forName(runtimeClassName, false, cl);
                        return (TruffleRuntime)runtimeClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Throwable e) {
                        throw (InternalError)new InternalError().initCause(e);
                    }
                }
                boolean bl = jdk8OrEarlier = System.getProperty("java.specification.version").compareTo("1.9") < 0;
                if (!jdk8OrEarlier) {
                    ServiceLoader<TruffleRuntimeAccess> standardProviders = ServiceLoader.load(TruffleRuntimeAccess.class);
                    access = Truffle.selectTruffleRuntimeAccess(new Iterable[]{standardProviders});
                } else {
                    Iterable jvmciProviders = Truffle.getJVMCIProviders();
                    if (Boolean.getBoolean("truffle.TrustAllTruffleRuntimeProviders")) {
                        ServiceLoader<TruffleRuntimeAccess> standardProviders = ServiceLoader.load(TruffleRuntimeAccess.class);
                        access = Truffle.selectTruffleRuntimeAccess(new Iterable[]{jvmciProviders, standardProviders});
                    } else {
                        access = Truffle.selectTruffleRuntimeAccess(new Iterable[]{jvmciProviders});
                    }
                }
                if (access != null) {
                    return access.getRuntime();
                }
                return new DefaultTruffleRuntime();
            }
        });
    }
}

