/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.Node;
import java.util.Objects;

public final class Scope {
    private static final Scope EMPTY = new Scope();
    private final String name;
    private final Node node;
    private final Object arguments;
    private final Object variables;

    private Scope() {
        this.name = null;
        this.node = null;
        this.arguments = null;
        this.variables = null;
    }

    Scope(String name, Node node, Object arguments, Object variables) {
        this.name = name;
        this.node = node;
        assert (arguments == null || TruffleLanguage.AccessAPI.interopAccess().isTruffleObject(arguments)) : Objects.toString(arguments);
        this.arguments = arguments;
        assert (TruffleLanguage.AccessAPI.interopAccess().isTruffleObject(variables)) : Objects.toString(variables);
        this.variables = variables;
    }

    public static Builder newBuilder(String name, Object variables) {
        Scope scope = EMPTY;
        scope.getClass();
        return scope.new Builder(name, variables);
    }

    public String getName() {
        return this.name;
    }

    public Node getNode() {
        return this.node;
    }

    public Object getVariables() {
        return this.variables;
    }

    public Object getArguments() {
        return this.arguments;
    }

    public final class Builder {
        private final String name;
        private Node node;
        private Object arguments;
        private final Object variables;

        Builder(String name, Object variables) {
            assert (name != null);
            assert (TruffleLanguage.AccessAPI.interopAccess().isTruffleObject(variables)) : Objects.toString(variables);
            this.name = name;
            this.variables = variables;
        }

        public Builder node(Node node) {
            this.node = node;
            return this;
        }

        public Builder arguments(Object arguments) {
            assert (arguments == null || TruffleLanguage.AccessAPI.interopAccess().isTruffleObject(arguments)) : Objects.toString(arguments);
            this.arguments = arguments;
            return this;
        }

        public Scope build() {
            return new Scope(this.name, this.node, this.arguments, this.variables);
        }
    }
}

