package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.ForeignAccess.Factory;
import com.oracle.truffle.api.interop.ForeignAccess.StandardFactory;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.RootNode;

/**
 * This foreign access factory is generated by {@link com.oracle.truffle.polyglot.DefaultScope.NullValue}.
 * You are supposed to use it for the receiver object {@link com.oracle.truffle.polyglot.DefaultScope.NullValue}.
 */
final class NullValueForeign implements StandardFactory, Factory {
    public static final ForeignAccess ACCESS = ForeignAccess.create(new NullValueForeign(), null);
    @Deprecated public static ForeignAccess createAccess() { return ForeignAccess.create(new NullValueForeign(), null); }

    private NullValueForeign() { }

    @Override
    public boolean canHandle(TruffleObject obj) {
        return com.oracle.truffle.polyglot.DefaultScope.NullValue.isInstance(obj);
    }

    @Override
    public CallTarget accessIsNull() {
      return Truffle.getRuntime().createCallTarget(IsNullSubNode.createRoot());
    }
    @Override
    public CallTarget accessIsExecutable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsInstantiable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsBoxed() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasKeys() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasSize() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessGetSize() {
      return null;
    }
    @Override
    public CallTarget accessUnbox() {
      return null;
    }
    @Override
    public CallTarget accessRead() {
      return null;
    }
    @Override
    public CallTarget accessWrite() {
      return null;
    }
    @Override
    public CallTarget accessRemove() {
      return null;
    }
    @Override
    public CallTarget accessExecute(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessInvoke(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessNew(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessKeyInfo() {
      return null;
    }
    @Override
    public CallTarget accessKeys() {
      return null;
    }
    @Override
    public CallTarget accessIsPointer() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessAsPointer() {
      return null;
    }
    @Override
    public CallTarget accessToNative() {
      return null;
    }
    @Override
    public CallTarget accessMessage(Message unknown) {
      return null;
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.DefaultScope.NullValue.IsNull}.
     */
    abstract static class IsNullSubNode extends com.oracle.truffle.polyglot.DefaultScope.NullValue.IsNull {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.DefaultScope.NullValue receiver) {
            return access(receiver);
        }
        private static final class IS_NULLRootNode extends RootNode {
            protected IS_NULLRootNode() {
                super(null);
            }

            @Child private IsNullSubNode node = com.oracle.truffle.polyglot.NullValueForeignFactory.IsNullSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::IS_NULL::" + com.oracle.truffle.polyglot.DefaultScope.NullValue.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof IsNullSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new IS_NULLRootNode();
        }
    }
}
