/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.exceptions.EJBQLException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.SelectGenerationContext;
import oracle.toplink.essentials.internal.parsing.SortDirectionNode;
import oracle.toplink.essentials.internal.parsing.TypeHelper;

public class OrderByItemNode
extends Node {
    private SortDirectionNode direction = null;
    private Node orderByItem = null;

    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        if (this.orderByItem != null) {
            this.orderByItem.validate(context);
            Object type = this.orderByItem.getType();
            this.setType(type);
            if (!typeHelper.isOrderableType(type)) {
                throw EJBQLException.expectedOrderableOrderByItem(context.getQueryInfo(), this.orderByItem.getLine(), this.orderByItem.getColumn(), this.orderByItem.getAsString(), typeHelper.getTypeName(type));
            }
        }
    }

    public Expression generateExpression(GenerationContext context) {
        boolean oldCheckState = context.shouldCheckSelectNodeBeforeResolving();
        ((SelectGenerationContext)context).checkSelectNodeBeforeResolving(true);
        Expression orderByExpression = this.getOrderByItem().generateExpression(context);
        orderByExpression = this.getDirection().addToExpression(orderByExpression, context);
        ((SelectGenerationContext)context).checkSelectNodeBeforeResolving(oldCheckState);
        return orderByExpression;
    }

    public SortDirectionNode getDirection() {
        if (this.direction == null) {
            this.setDirection(new SortDirectionNode());
        }
        return this.direction;
    }

    public Node getOrderByItem() {
        return this.orderByItem;
    }

    public void setDirection(SortDirectionNode direction) {
        this.direction = direction;
    }

    public void setOrderByItem(Node orderByItem) {
        this.orderByItem = orderByItem;
    }
}

