/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.util.UserError;
import java.util.concurrent.TimeUnit;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Threading;
import org.graalvm.nativeimage.impl.ThreadingSupport;

public class ThreadingSupportImpl
implements ThreadingSupport {
    private static final FastThreadLocalObject<RecurringCallbackTimer> activeTimer = FastThreadLocalFactory.createObject(RecurringCallbackTimer.class);
    private static final FastThreadLocalInt currentPauseDepth = FastThreadLocalFactory.createInt();

    static void initialize() {
        ImageSingletons.add(ThreadingSupport.class, (Object)new ThreadingSupportImpl());
    }

    @Fold
    static ThreadingSupportImpl singleton() {
        return (ThreadingSupportImpl)ImageSingletons.lookup(ThreadingSupport.class);
    }

    public void registerRecurringCallback(long interval, TimeUnit unit, Threading.RecurringCallback callback) {
        if (callback != null) {
            UserError.guarantee(SubstrateOptions.MultiThreaded.getValue(), "Recurring callbacks are only supported in multi-threaded mode.", new Object[0]);
            long intervalNanos = unit.toNanos(interval);
            if (intervalNanos < 1L) {
                throw new IllegalArgumentException("intervalNanos");
            }
            RecurringCallbackTimer timer = new RecurringCallbackTimer(intervalNanos, callback);
            activeTimer.set(timer);
            Safepoint.setSafepointRequested((int)timer.requestedChecks);
        } else {
            activeTimer.set(null);
        }
    }

    @Uninterruptible(reason="Must not contain safepoint checks.")
    void onSafepointCheckSlowpath(long timestamp, int value) {
        RecurringCallbackTimer timer = activeTimer.get();
        if (timer != null) {
            timer.evaluate(timestamp, value);
        }
    }

    @Uninterruptible(reason="Called by uninterruptible code.")
    boolean needsCallbackOnSafepointCheckSlowpath() {
        return activeTimer.get() != null;
    }

    boolean needsNativeToJavaSlowpath() {
        return Options.CheckRecurringCallbackOnNativeToJavaTransition.getValue() != false && activeTimer.get() != null;
    }

    @Uninterruptible(reason="Must not contain safepoint checks.")
    private static void pauseRecurringCallback() {
        assert (currentPauseDepth.get() >= 0);
        currentPauseDepth.set(currentPauseDepth.get() + 1);
    }

    @Uninterruptible(reason="Must not contain safepoint checks.")
    private static void resumeRecurringCallback() {
        assert (currentPauseDepth.get() > 0);
        currentPauseDepth.set(currentPauseDepth.get() - 1);
        if (!ThreadingSupportImpl.isRecurringCallbackPaused() && activeTimer.get() != null) {
            activeTimer.get().afterResume();
        }
    }

    @Uninterruptible(reason="Called by uninterruptible code.")
    static boolean isRecurringCallbackPaused() {
        return currentPauseDepth.get() != 0;
    }

    static class RecurringCallbackTimer {
        private static final Threading.RecurringCallbackAccess CALLBACK_ACCESS = new Threading.RecurringCallbackAccess(){

            public void throwException(Throwable t) {
                throw new Safepoint.SafepointException(t);
            }
        };
        private static final double EWMA_LAMBDA = 0.3;
        private static final int INITIAL_CHECKS = 100;
        private static final long MINIMUM_INTERVAL_NANOS = 1000L;
        private final long targetIntervalNanos;
        private final Threading.RecurringCallback callback;
        private long requestedChecks;
        private double ewmaChecksPerNano;
        private long lastCapture;
        private long nextDeadline;
        private volatile boolean isExecuting = false;
        private boolean isPending = false;

        RecurringCallbackTimer(long targetIntervalNanos, Threading.RecurringCallback callback) {
            long now;
            this.targetIntervalNanos = Math.max(1000L, targetIntervalNanos);
            this.callback = callback;
            this.lastCapture = now = System.nanoTime();
            this.nextDeadline = now + targetIntervalNanos;
            this.requestedChecks = 100L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Uninterruptible(reason="Must not contain safepoint checks.")
        void evaluate(long timestamp, int value) {
            long remainingNanos;
            double checks;
            long now;
            block11: {
                if (this.isExecuting || SnippetRuntime.isUnwindingForException()) {
                    return;
                }
                assert (VMThreads.StatusSupport.isStatusJava());
                long unsignedIntMax = 0xFFFFFFFFL;
                this.isExecuting = true;
                now = 0L;
                try {
                    boolean shouldInvoke;
                    long elapsedNanos = timestamp - this.lastCapture;
                    long skippedChecks = (long)value & 0xFFFFFFFFL;
                    if (elapsedNanos > 0L && skippedChecks < this.requestedChecks) {
                        double checksPerNano = (double)(this.requestedChecks - skippedChecks) / (double)elapsedNanos;
                        this.ewmaChecksPerNano = this.ewmaChecksPerNano == 0.0 ? checksPerNano : 0.3 * checksPerNano + 0.7 * this.ewmaChecksPerNano;
                    }
                    boolean bl = shouldInvoke = this.isPending || timestamp >= this.nextDeadline;
                    if (!shouldInvoke) {
                        now = System.nanoTime();
                        boolean bl2 = shouldInvoke = now >= this.nextDeadline;
                    }
                    if (!shouldInvoke) break block11;
                    try {
                        if (!ThreadingSupportImpl.isRecurringCallbackPaused()) {
                            this.isPending = false;
                            this.invokeCallback();
                        } else {
                            this.isPending = true;
                        }
                    }
                    finally {
                        now = System.nanoTime();
                        this.nextDeadline = now + this.targetIntervalNanos;
                    }
                }
                catch (Throwable throwable) {
                    long remainingNanos2 = this.nextDeadline - now;
                    remainingNanos2 = remainingNanos2 < 1000L ? 1000L : remainingNanos2;
                    double checks2 = this.ewmaChecksPerNano * (double)remainingNanos2;
                    this.requestedChecks = checks2 > 4.294967295E9 ? 0xFFFFFFFFL : (checks2 < 1.0 ? 1L : (long)checks2);
                    this.lastCapture = now;
                    Safepoint.setSafepointRequested((int)this.requestedChecks);
                    this.isExecuting = false;
                    throw throwable;
                }
            }
            this.requestedChecks = (checks = this.ewmaChecksPerNano * (double)(remainingNanos = (remainingNanos = this.nextDeadline - now) < 1000L ? 1000L : remainingNanos)) > 4.294967295E9 ? 0xFFFFFFFFL : (checks < 1.0 ? 1L : (long)checks);
            this.lastCapture = now;
            Safepoint.setSafepointRequested((int)this.requestedChecks);
            this.isExecuting = false;
        }

        @Uninterruptible(reason="Required by caller, but does not apply to callee.", calleeMustBe=false)
        @RestrictHeapAccess(reason="Callee may allocate", access=RestrictHeapAccess.Access.UNRESTRICTED, overridesCallers=true)
        private void invokeCallback() {
            try {
                Safepoint.setSafepointRequested(-1);
                this.callback.run(CALLBACK_ACCESS);
            }
            catch (Safepoint.SafepointException se) {
                throw se;
            }
            catch (Throwable t) {
                Log.log().string("Exception caught in recurring callback (ignored): ").object(t).newline();
            }
        }

        @Uninterruptible(reason="Must not contain safepoint checks.")
        void afterResume() {
            assert (!ThreadingSupportImpl.isRecurringCallbackPaused());
            if (this.isPending) {
                long callbackTime = System.nanoTime();
                int callbackValue = Safepoint.getSafepointRequested(CurrentIsolate.getCurrentThread());
                try {
                    this.evaluate(callbackTime, callbackValue);
                }
                catch (Safepoint.SafepointException e) {
                    RecurringCallbackTimer.throwUnchecked(e.inner);
                }
            }
        }

        @Uninterruptible(reason="Called by uninterruptible code.")
        private static <T extends Throwable> void throwUnchecked(Throwable exception) throws T {
            throw exception;
        }
    }

    public static class PauseRecurringCallback
    implements AutoCloseable {
        private boolean closed = false;

        public PauseRecurringCallback() {
            ThreadingSupportImpl.pauseRecurringCallback();
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                ThreadingSupportImpl.resumeRecurringCallback();
            }
        }
    }

    static class Options {
        @Option(help={"Test whether a thread's recurring callback is pending on each transition from native code to Java."})
        public static final HostedOptionKey<Boolean> CheckRecurringCallbackOnNativeToJavaTransition = new HostedOptionKey<Boolean>(false);

        Options() {
        }
    }
}

