/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.headers.Errno;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.os.IsDefined;
import com.oracle.svm.core.posix.JavaNetNetworkInterface;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.ArpaInet;
import com.oracle.svm.core.posix.headers.Ioctl;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.NetIf;
import com.oracle.svm.core.posix.headers.NetinetIn;
import com.oracle.svm.core.posix.headers.PosixDirectives;
import com.oracle.svm.core.posix.headers.Socket;
import com.oracle.svm.core.posix.headers.Unistd;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.SocketException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.LINUX.class})
@CContext(value=PosixDirectives.class)
public class LinuxJavaNetNetworkInterface {

    static class PlatformSupportImpl
    implements JavaNetNetworkInterface.PlatformSupport {
        PlatformSupportImpl() {
        }

        @Override
        public JavaNetNetworkInterface.netif enumIPv4Interfaces(int sock, JavaNetNetworkInterface.netif ifsParameter) throws SocketException {
            JavaNetNetworkInterface.netif ifs = ifsParameter;
            NetIf.ifconf ifc = (NetIf.ifconf)StackValue.get(NetIf.ifconf.class);
            CCharPointer buf = (CCharPointer)WordFactory.nullPointer();
            long siocgifconfRequest = Socket.SIOCGIFCONF();
            if (IsDefined.__linux__()) {
                ifc.ifc_buf((CCharPointer)WordFactory.nullPointer());
                if (Ioctl.ioctl(sock, Socket.SIOCGIFCONF(), ifc) < 0) {
                    throw new SocketException(PosixUtils.lastErrorString("ioctl SIOCGIFCONF failed"));
                }
            } else if (IsDefined._AIX()) {
                // empty if block
            }
            if ((buf = (CCharPointer)LibC.malloc(WordFactory.unsigned((int)ifc.ifc_len()))).isNull()) {
                throw new OutOfMemoryError("Native heap allocation failed");
            }
            ifc.ifc_buf(buf);
            if (Ioctl.ioctl(sock, siocgifconfRequest, ifc) < 0) {
                int savedErrno = Errno.errno();
                LibC.free((PointerBase)buf);
                throw new SocketException(PosixUtils.errorString(savedErrno, "ioctl SIOCGIFCONF failed"));
            }
            NetIf.ifreq ifreqP = ifc.ifc_req();
            for (int i = 0; i < ifc.ifc_len() / SizeOf.get(NetIf.ifreq.class); ++i) {
                try {
                    ifs = JavaNetNetworkInterface.addif(sock, ifreqP.addressOf(i).ifr_name(), ifs, ifreqP.addressOf(i).ifr_addr(), Socket.AF_INET(), (short)0);
                    continue;
                }
                catch (Exception so) {
                    LibC.free((PointerBase)buf);
                    JavaNetNetworkInterface.freeif(ifs);
                    return null;
                }
            }
            LibC.free((PointerBase)buf);
            return ifs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JavaNetNetworkInterface.netif enumIPv6Interfaces(int sock, JavaNetNetworkInterface.netif ifsParameter) throws SocketException {
            JavaNetNetworkInterface.netif ifs = ifsParameter;
            CCharPointer ipv6addr = (CCharPointer)StackValue.get((int)16, CCharPointer.class);
            String _PATH_PROCNET_IFINET6 = "/proc/net/if_inet6";
            try {
                BufferedReader f;
                try {
                    f = new BufferedReader(new FileReader("/proc/net/if_inet6"));
                }
                catch (FileNotFoundException fnfe) {
                    return ifs;
                }
                try {
                    String line = f.readLine();
                    while (line != null) {
                        IfInet6Info info = IfInet6Info.parse(line);
                        if (info != null) {
                            NetinetIn.sockaddr_in6 addr = (NetinetIn.sockaddr_in6)StackValue.get(NetinetIn.sockaddr_in6.class);
                            try (CTypeConversion.CCharPointerHolder addr6Holder = CTypeConversion.toCString((CharSequence)info.getIPv6());){
                                ArpaInet.inet_pton(Socket.AF_INET6(), addr6Holder.get(), (PointerBase)ipv6addr);
                            }
                            LibC.memset(addr, WordFactory.signed((int)0), WordFactory.unsigned((int)SizeOf.get(NetinetIn.sockaddr_in6.class)));
                            LibC.memcpy(addr.sin6_addr().s6_addr(), (PointerBase)ipv6addr, WordFactory.unsigned((int)16));
                            addr.set_sin6_scope_id(info.getIndex());
                            var11_13 = null;
                            try (CTypeConversion.CCharPointerHolder devnameHolder = CTypeConversion.toCString((CharSequence)info.getDevice());){
                                ifs = JavaNetNetworkInterface.addif(sock, devnameHolder.get(), ifs, (Socket.sockaddr)((Object)addr), Socket.AF_INET6(), (short)info.getPrefixLength());
                            }
                            catch (Throwable throwable) {
                                var11_13 = throwable;
                                throw throwable;
                            }
                        }
                        line = f.readLine();
                    }
                }
                finally {
                    f.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return ifs;
        }

        @Override
        public Socket.sockaddr getBroadcast(int sock, CCharPointer ifname, Socket.sockaddr brdcast_store) throws SocketException {
            Socket.sockaddr ret = (Socket.sockaddr)WordFactory.nullPointer();
            NetIf.ifreq if2 = (NetIf.ifreq)StackValue.get(NetIf.ifreq.class);
            LibC.memset(if2, WordFactory.signed((int)0), WordFactory.unsigned((int)SizeOf.get(NetIf.ifreq.class)));
            LibC.strcpy(if2.ifr_name(), ifname);
            if (Ioctl.ioctl(sock, Socket.SIOCGIFFLAGS(), if2) < 0) {
                throw new SocketException(PosixUtils.lastErrorString("IOCTL  SIOCGIFFLAGS failed"));
            }
            if (CTypeConversion.toBoolean((int)(if2.ifr_flags() & NetIf.IFF_BROADCAST()))) {
                if (Ioctl.ioctl(sock, Socket.SIOCGIFBRDADDR(), if2) < 0) {
                    throw new SocketException(PosixUtils.lastErrorString("IOCTL SIOCGIFBRDADDR failed"));
                }
                ret = brdcast_store;
                LibC.memcpy(ret, if2.ifr_broadaddr(), WordFactory.unsigned((int)SizeOf.get(Socket.sockaddr.class)));
            }
            return ret;
        }

        @Override
        public short getSubnet(int sock, CCharPointer ifname) throws SocketException {
            NetIf.ifreq if2 = (NetIf.ifreq)StackValue.get(NetIf.ifreq.class);
            LibC.memset(if2, WordFactory.signed((int)0), WordFactory.unsigned((int)SizeOf.get(NetIf.ifreq.class)));
            LibC.strcpy(if2.ifr_name(), ifname);
            if (Ioctl.ioctl(sock, Socket.SIOCGIFNETMASK(), if2) < 0) {
                throw new SocketException(PosixUtils.lastErrorString("IOCTL SIOCGIFNETMASK failed"));
            }
            int mask = NetinetIn.ntohl(((NetinetIn.sockaddr_in)((Object)if2.ifr_addr())).sin_addr().s_addr());
            short ret = 0;
            while (CTypeConversion.toBoolean((int)mask)) {
                mask <<= 1;
                ret = (short)(ret + 1);
            }
            return ret;
        }

        @Override
        public int getFlags(int sock, CCharPointer ifname, CIntPointer flags) {
            NetIf.ifreq if2 = (NetIf.ifreq)StackValue.get(NetIf.ifreq.class);
            LibC.memset(if2, WordFactory.signed((int)0), WordFactory.unsigned((int)SizeOf.get(NetIf.ifreq.class)));
            LibC.strcpy(if2.ifr_name(), ifname);
            if (Ioctl.ioctl(sock, Socket.SIOCGIFFLAGS(), if2) < 0) {
                return -1;
            }
            flags.write(if2.ifr_flags() & 0xFFFF);
            return 0;
        }

        @Override
        public int getIndex(int sock, CCharPointer name) {
            NetIf.ifreq if2 = (NetIf.ifreq)StackValue.get(NetIf.ifreq.class);
            LibC.memset(if2, WordFactory.signed((int)0), WordFactory.unsigned((int)SizeOf.get(NetIf.ifreq.class)));
            LibC.strcpy(if2.ifr_name(), name);
            if (Ioctl.ioctl(sock, Socket.SIOCGIFINDEX(), if2) < 0) {
                return -1;
            }
            return if2.ifr_ifindex();
        }

        @Override
        public int getMacAddress(CCharPointer ifname, NetinetIn.in_addr addr, CCharPointer buf) throws SocketException {
            NetIf.ifreq ifr = (NetIf.ifreq)StackValue.get(NetIf.ifreq.class);
            int sock = JavaNetNetworkInterface.openSocketWithFallback(ifname);
            if (sock < 0) {
                return -1;
            }
            LibC.memset(ifr, WordFactory.signed((int)0), WordFactory.unsigned((int)SizeOf.get(NetIf.ifreq.class)));
            LibC.strncpy(ifr.ifr_name(), ifname, WordFactory.unsigned((int)(NetIf.IF_NAMESIZE() - 1)));
            if (Ioctl.ioctl(sock, Socket.SIOCGIFHWADDR(), ifr) < 0) {
                try {
                    throw new SocketException(PosixUtils.lastErrorString("ioctl(SIOCGIFHWADDR) failed"));
                }
                catch (Throwable throwable) {
                    Unistd.close(sock);
                    throw throwable;
                }
            }
            Unistd.close(sock);
            LibC.memcpy(buf, (PointerBase)ifr.ifr_hwaddr().sa_data(), WordFactory.unsigned((int)NetIf.IFHWADDRLEN()));
            for (int i = 0; i < NetIf.IFHWADDRLEN(); ++i) {
                if (buf.read(i) == 0) continue;
                return NetIf.IFHWADDRLEN();
            }
            return -1;
        }

        static class IfInet6Info {
            static final String s32 = "(.{32})";
            static final String x8 = "([0-9a-fA-F]{1,8})";
            static final String x2 = "([0-9a-fA-F]{1,2})";
            static final String s20 = "(.{1,20})";
            static final String blank = "[ \t]+";
            static final String patternString = "(.{32})[ \t]+([0-9a-fA-F]{1,8})[ \t]+([0-9a-fA-F]{1,2})[ \t]+([0-9a-fA-F]{1,2})[ \t]+([0-9a-fA-F]{1,2})[ \t]+(.{1,20})";
            static final Pattern pattern = Pattern.compile("(.{32})[ \t]+([0-9a-fA-F]{1,8})[ \t]+([0-9a-fA-F]{1,2})[ \t]+([0-9a-fA-F]{1,2})[ \t]+([0-9a-fA-F]{1,2})[ \t]+(.{1,20})");
            String ipv6;
            String index;
            String prefixLength;
            String scope;
            String flags;
            String device;

            public static IfInet6Info parse(String line) {
                Matcher matcher = pattern.matcher(line);
                IfInet6Info result = matcher.matches() ? new IfInet6Info(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5), matcher.group(6)) : null;
                return result;
            }

            private IfInet6Info(String ipv6, String index, String prefix, String scope, String flags, String device) {
                this.ipv6 = ipv6;
                this.index = index;
                this.prefixLength = prefix;
                this.scope = scope;
                this.flags = flags;
                this.device = device;
            }

            String getIPv6(int which) {
                return this.ipv6.substring(which * 4, (which + 1) * 4);
            }

            String getIPv6() {
                return this.getIPv6(0) + ":" + this.getIPv6(1) + ":" + this.getIPv6(2) + ":" + this.getIPv6(3) + ":" + this.getIPv6(4) + ":" + this.getIPv6(5) + ":" + this.getIPv6(6) + ":" + this.getIPv6(7);
            }

            int getIndex() {
                return Integer.parseInt(this.index, 16);
            }

            int getPrefixLength() {
                return Integer.parseInt(this.prefixLength, 16);
            }

            int getScope() {
                return Integer.parseInt(this.scope, 16);
            }

            int getflags() {
                return Integer.parseInt(this.flags, 16);
            }

            String getDevice() {
                return this.device;
            }

            void toLog(Log trace) {
                trace.string("  .ipv6:   ").string(this.getIPv6()).newline();
                trace.string("  .index:  ").hex(this.getIndex()).newline();
                trace.string("  .prefix: ").hex(this.getPrefixLength()).newline();
                trace.string("  .scope:  ").hex(this.getScope()).newline();
                trace.string("  .flags:  ").hex(this.getflags()).newline();
                trace.string("  .device: ").string(this.getDevice()).newline();
            }
        }
    }

    @AutomaticFeature
    static class JavaNetNetworkInterfaceFeature
    implements Feature {
        JavaNetNetworkInterfaceFeature() {
        }

        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            ImageSingletons.add(JavaNetNetworkInterface.PlatformSupport.class, (Object)new PlatformSupportImpl());
        }
    }
}

