/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Objects;
import org.graalvm.nativeimage.ImageSingletons;

public final class SystemInOutErrSupport {
    private InputStream in = new BufferedInputStream(new FileInputStream(FileDescriptor.in));
    private PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out), 128), true);
    private PrintStream err = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.err), 128), true);

    public static void setIn(InputStream in) {
        ((SystemInOutErrSupport)ImageSingletons.lookup(SystemInOutErrSupport.class)).in = Objects.requireNonNull(in);
    }

    public static void setOut(PrintStream out) {
        ((SystemInOutErrSupport)ImageSingletons.lookup(SystemInOutErrSupport.class)).out = Objects.requireNonNull(out);
    }

    public static void setErr(PrintStream err) {
        ((SystemInOutErrSupport)ImageSingletons.lookup(SystemInOutErrSupport.class)).err = Objects.requireNonNull(err);
    }

    Object replaceStreams(Object object) {
        if (object == System.in) {
            return this.in;
        }
        if (object == System.out) {
            return this.out;
        }
        if (object == System.err) {
            return this.err;
        }
        return object;
    }
}

