/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.hosted;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.annotation.CustomSubstitutionField;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.annotation.CustomSubstitutionType;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.hosted.substitute.DeletedMethod;
import com.oracle.svm.reflect.helpers.ExceptionHelpers;
import com.oracle.svm.reflect.hosted.ReflectionDataBuilder;
import com.oracle.svm.reflect.hosted.ReflectionSubstitution;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatConvertNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.PointerEqualsNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;
import org.graalvm.util.GuardedAnnotationAccess;

public final class ReflectionSubstitutionType
extends CustomSubstitutionType<CustomSubstitutionField, ReflectionSubstitutionMethod> {
    private String stableName;

    public ReflectionSubstitutionType(ResolvedJavaType original, Member member) {
        super(original);
        this.stableName = "L" + ReflectionSubstitution.getStableProxyName(member).replace(".", "/") + ";";
        block50: for (ResolvedJavaMethod method : original.getDeclaredMethods()) {
            switch (method.getName()) {
                case "invoke": {
                    this.addSubstitutionMethod(method, new ReflectiveInvokeMethod(method, (Method)member));
                    continue block50;
                }
                case "get": {
                    this.addSubstitutionMethod(method, new ReflectiveReadMethod(method, (Field)member, JavaKind.Object));
                    continue block50;
                }
                case "getBoolean": {
                    this.addSubstitutionMethod(method, new ReflectiveReadMethod(method, (Field)member, JavaKind.Boolean));
                    continue block50;
                }
                case "getByte": {
                    this.addSubstitutionMethod(method, new ReflectiveReadMethod(method, (Field)member, JavaKind.Byte));
                    continue block50;
                }
                case "getShort": {
                    this.addSubstitutionMethod(method, new ReflectiveReadMethod(method, (Field)member, JavaKind.Short));
                    continue block50;
                }
                case "getChar": {
                    this.addSubstitutionMethod(method, new ReflectiveReadMethod(method, (Field)member, JavaKind.Char));
                    continue block50;
                }
                case "getInt": {
                    this.addSubstitutionMethod(method, new ReflectiveReadMethod(method, (Field)member, JavaKind.Int));
                    continue block50;
                }
                case "getLong": {
                    this.addSubstitutionMethod(method, new ReflectiveReadMethod(method, (Field)member, JavaKind.Long));
                    continue block50;
                }
                case "getFloat": {
                    this.addSubstitutionMethod(method, new ReflectiveReadMethod(method, (Field)member, JavaKind.Float));
                    continue block50;
                }
                case "getDouble": {
                    this.addSubstitutionMethod(method, new ReflectiveReadMethod(method, (Field)member, JavaKind.Double));
                    continue block50;
                }
                case "set": {
                    this.addSubstitutionMethod(method, ReflectionSubstitutionType.createWriteMethod(method, (Field)member, JavaKind.Object));
                    continue block50;
                }
                case "setBoolean": {
                    this.addSubstitutionMethod(method, ReflectionSubstitutionType.createWriteMethod(method, (Field)member, JavaKind.Boolean));
                    continue block50;
                }
                case "setByte": {
                    this.addSubstitutionMethod(method, ReflectionSubstitutionType.createWriteMethod(method, (Field)member, JavaKind.Byte));
                    continue block50;
                }
                case "setShort": {
                    this.addSubstitutionMethod(method, ReflectionSubstitutionType.createWriteMethod(method, (Field)member, JavaKind.Short));
                    continue block50;
                }
                case "setChar": {
                    this.addSubstitutionMethod(method, ReflectionSubstitutionType.createWriteMethod(method, (Field)member, JavaKind.Char));
                    continue block50;
                }
                case "setInt": {
                    this.addSubstitutionMethod(method, ReflectionSubstitutionType.createWriteMethod(method, (Field)member, JavaKind.Int));
                    continue block50;
                }
                case "setLong": {
                    this.addSubstitutionMethod(method, ReflectionSubstitutionType.createWriteMethod(method, (Field)member, JavaKind.Long));
                    continue block50;
                }
                case "setFloat": {
                    this.addSubstitutionMethod(method, ReflectionSubstitutionType.createWriteMethod(method, (Field)member, JavaKind.Float));
                    continue block50;
                }
                case "setDouble": {
                    this.addSubstitutionMethod(method, ReflectionSubstitutionType.createWriteMethod(method, (Field)member, JavaKind.Double));
                    continue block50;
                }
                case "newInstance": {
                    Class<?> holder = member.getDeclaringClass();
                    if (Modifier.isAbstract(holder.getModifiers()) || holder.isInterface() || holder.isPrimitive() || holder.isArray()) {
                        this.addSubstitutionMethod(method, new ThrowingMethod(method, InstantiationException.class, "Cannot instantiate " + holder));
                        continue block50;
                    }
                    this.addSubstitutionMethod(method, new ReflectiveNewInstanceMethod(method, (Constructor)member));
                    continue block50;
                }
                case "toString": {
                    this.addSubstitutionMethod(method, new ToStringMethod(method, member.getName()));
                    continue block50;
                }
                case "hashCode": {
                    this.addSubstitutionMethod(method, new HashCodeMethod(method, member.hashCode()));
                    continue block50;
                }
                case "equals": {
                    this.addSubstitutionMethod(method, new EqualsMethod(method));
                    continue block50;
                }
                default: {
                    throw VMError.shouldNotReachHere("unexpected method: " + method.getName());
                }
            }
        }
    }

    private static ReflectionSubstitutionMethod createWriteMethod(ResolvedJavaMethod method, Field field, JavaKind kind) {
        ReflectionDataBuilder reflectionDataBuilder = (ReflectionDataBuilder)ImageSingletons.lookup(RuntimeReflectionSupport.class);
        if (Modifier.isFinal(field.getModifiers()) && !reflectionDataBuilder.inspectFinalFieldWritableForAnalysis(field)) {
            return new ThrowingMethod(method, IllegalAccessException.class, "Cannot set final field: " + field.getDeclaringClass().getName() + "." + field.getName() + ". Enable by specifying \"allowWrite\" for this field in the reflection configuration.");
        }
        return new ReflectiveWriteMethod(method, field, kind);
    }

    public String getName() {
        return this.stableName;
    }

    private static void throwFailedCast(HostedGraphKit graphKit, ResolvedJavaType expectedType, ValueNode actual) {
        ResolvedJavaMethod createFailedCast = graphKit.findMethod(ExceptionHelpers.class, "createFailedCast", true);
        JavaConstant expected = graphKit.getConstantReflection().asJavaClass(expectedType);
        ConstantNode expectedNode = graphKit.createConstant((Constant)expected, JavaKind.Object);
        ValueNode exception = graphKit.createJavaCallWithExceptionAndUnwind(CallTargetNode.InvokeKind.Static, createFailedCast, new ValueNode[]{expectedNode, actual});
        graphKit.append((ValueNode)new UnwindNode(exception));
        graphKit.mergeUnwinds();
    }

    private static ValueNode createCheckcast(HostedGraphKit graphKit, ValueNode value, ResolvedJavaType type, boolean nonNull) {
        TypeReference typeRef = TypeReference.createTrusted((Assumptions)graphKit.getAssumptions(), (ResolvedJavaType)type);
        LogicNode condition = nonNull ? (LogicNode)graphKit.append((ValueNode)InstanceOfNode.create((TypeReference)typeRef, (ValueNode)value)) : (LogicNode)graphKit.append((ValueNode)InstanceOfNode.createAllowNull((TypeReference)typeRef, (ValueNode)value, null, null));
        graphKit.startIf(condition, 0.99);
        graphKit.thenPart();
        PiNode ret = graphKit.createPiNode(value, (Stamp)StampFactory.object((TypeReference)typeRef, (boolean)nonNull));
        graphKit.elsePart();
        ReflectionSubstitutionType.throwFailedCast(graphKit, type, value);
        graphKit.endIf();
        return ret;
    }

    private static void fillArgsArray(HostedGraphKit graphKit, ValueNode argumentArray, int receiverOffset, ValueNode[] args, Class<?>[] argTypes) {
        for (int i = 0; i < argTypes.length; ++i) {
            JavaKind argKind = JavaKind.fromJavaClass(argTypes[i]);
            ValueNode arg = graphKit.createLoadIndexed(argumentArray, i, JavaKind.Object);
            if (argKind.isPrimitive()) {
                arg = ReflectionSubstitutionType.createCheckcast(graphKit, arg, graphKit.getMetaAccess().lookupJavaType(argKind.toBoxedJavaClass()), true);
                arg = graphKit.createUnboxing(arg, argKind);
            } else {
                arg = ReflectionSubstitutionType.createCheckcast(graphKit, arg, graphKit.getMetaAccess().lookupJavaType(argTypes[i]), false);
            }
            args[i + receiverOffset] = arg;
        }
    }

    private static void throwIllegalArgumentException(HostedGraphKit graphKit, String message) {
        ResolvedJavaType exceptionType = graphKit.getMetaAccess().lookupJavaType(IllegalArgumentException.class);
        ValueNode ite = graphKit.append((ValueNode)new NewInstanceNode(exceptionType, true));
        ResolvedJavaMethod cons = null;
        for (ResolvedJavaMethod c : exceptionType.getDeclaredConstructors()) {
            if (c.getSignature().getParameterCount(false) != 2) continue;
            cons = c;
        }
        JavaConstant msg = graphKit.getConstantReflection().forString(message);
        ConstantNode msgNode = graphKit.createConstant((Constant)msg, JavaKind.Object);
        ConstantNode cause = graphKit.createConstant((Constant)JavaConstant.NULL_POINTER, JavaKind.Object);
        graphKit.createJavaCallWithExceptionAndUnwind(CallTargetNode.InvokeKind.Special, cons, new ValueNode[]{ite, msgNode, cause});
        graphKit.append((ValueNode)new UnwindNode(ite));
        graphKit.mergeUnwinds();
    }

    private static boolean canImplicitCast(JavaKind from, JavaKind to) {
        if (from == to) {
            return true;
        }
        switch (to) {
            case Object: {
                return true;
            }
            case Boolean: 
            case Char: {
                return false;
            }
        }
        switch (from) {
            case Byte: {
                return true;
            }
            case Short: {
                return to != JavaKind.Byte;
            }
            case Char: {
                return to != JavaKind.Byte && to != JavaKind.Short;
            }
            case Int: {
                return to == JavaKind.Long || to.isNumericFloat();
            }
            case Long: 
            case Float: {
                return to.isNumericFloat();
            }
        }
        return false;
    }

    private static ValueNode doImplicitCast(HostedGraphKit graphKit, JavaKind from, JavaKind to, ValueNode value) {
        assert (ReflectionSubstitutionType.canImplicitCast(from, to));
        if (from == to) {
            return value;
        }
        switch (to) {
            case Object: {
                ResolvedJavaType boxedRetType = graphKit.getMetaAccess().lookupJavaType(from.toBoxedJavaClass());
                return graphKit.createBoxing(value, from, boxedRetType);
            }
            case Float: {
                switch (from) {
                    case Int: {
                        return graphKit.append((ValueNode)new FloatConvertNode(FloatConvert.I2F, value));
                    }
                    case Long: {
                        return graphKit.append((ValueNode)new FloatConvertNode(FloatConvert.L2F, value));
                    }
                }
                break;
            }
            case Double: {
                switch (from) {
                    case Float: {
                        return graphKit.append((ValueNode)new FloatConvertNode(FloatConvert.F2D, value));
                    }
                    case Int: {
                        return graphKit.append((ValueNode)new FloatConvertNode(FloatConvert.I2D, value));
                    }
                    case Long: {
                        return graphKit.append((ValueNode)new FloatConvertNode(FloatConvert.L2D, value));
                    }
                }
                break;
            }
            case Short: {
                assert (from.isNumericInteger() && from.getBitCount() < to.getBitCount());
                return graphKit.append(NarrowNode.create((ValueNode)value, (int)to.getBitCount(), (NodeView)NodeView.DEFAULT));
            }
            case Int: {
                assert (from.isNumericInteger() && from.getBitCount() < to.getBitCount());
                return value;
            }
            case Long: {
                assert (from.isNumericInteger() && from.getBitCount() < to.getBitCount());
                if (from.isUnsigned()) {
                    return graphKit.append(ZeroExtendNode.create((ValueNode)value, (int)to.getBitCount(), (NodeView)NodeView.DEFAULT));
                }
                return graphKit.append(SignExtendNode.create((ValueNode)value, (int)to.getBitCount(), (NodeView)NodeView.DEFAULT));
            }
            default: {
                throw VMError.shouldNotReachHere();
            }
        }
        assert (from.isNumericInteger() && from.getByteCount() < 4);
        ValueNode intermediate = ReflectionSubstitutionType.doImplicitCast(graphKit, from, JavaKind.Int, value);
        return ReflectionSubstitutionType.doImplicitCast(graphKit, JavaKind.Int, to, intermediate);
    }

    private static boolean isDeletedField(ResolvedJavaField field) {
        return GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)field, Delete.class);
    }

    private static void handleDeletedField(HostedGraphKit graphKit, HostedProviders providers, ResolvedJavaField field, JavaKind returnKind) {
        Delete deleteAnnotation = (Delete)GuardedAnnotationAccess.getAnnotation((AnnotatedElement)field, Delete.class);
        String msg = AnnotationSubstitutionProcessor.deleteErrorMessage((AnnotatedElement)field, deleteAnnotation.value(), false);
        ConstantNode msgNode = ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(msg), (MetaAccessProvider)providers.getMetaAccess(), (StructuredGraph)graphKit.getGraph());
        ResolvedJavaMethod reportErrorMethod = providers.getMetaAccess().lookupJavaMethod((Executable)DeletedMethod.reportErrorMethod);
        graphKit.createInvokeWithExceptionAndUnwind(reportErrorMethod, CallTargetNode.InvokeKind.Static, graphKit.getFrameState(), graphKit.bci(), graphKit.bci(), new ValueNode[]{msgNode});
        ConstantNode returnValue = null;
        if (returnKind != JavaKind.Void) {
            returnValue = (ConstantNode)graphKit.unique((FloatingNode)ConstantNode.defaultForKind((JavaKind)returnKind));
        }
        graphKit.createReturn((ValueNode)returnValue, returnKind);
    }

    @Override
    public Annotation[] getAnnotations() {
        return InternalVMMethod.Holder.ARRAY;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return annotationClass == InternalVMMethod.class;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (annotationClass == InternalVMMethod.class) {
            return (T)((Annotation)annotationClass.cast(InternalVMMethod.Holder.INSTANCE));
        }
        return null;
    }

    private static final class ThrowingMethod
    extends ReflectionSubstitutionMethod {
        private final Class<? extends Throwable> exceptionClass;
        private final String message;

        private ThrowingMethod(ResolvedJavaMethod original, Class<? extends Throwable> exceptionClass, String message) {
            super(original);
            this.exceptionClass = exceptionClass;
            this.message = message;
        }

        public StructuredGraph buildGraph(DebugContext ctx, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
            HostedGraphKit graphKit = new HostedGraphKit(ctx, providers, method);
            ResolvedJavaType exceptionType = graphKit.getMetaAccess().lookupJavaType(this.exceptionClass);
            ValueNode instance = graphKit.append((ValueNode)new NewInstanceNode(exceptionType, true));
            ResolvedJavaMethod cons = null;
            for (ResolvedJavaMethod c : exceptionType.getDeclaredConstructors()) {
                if (c.getSignature().getParameterCount(false) != 1) continue;
                ResolvedJavaType stringType = providers.getMetaAccess().lookupJavaType(String.class);
                if (!c.getSignature().getParameterType(0, null).equals(stringType)) continue;
                cons = c;
            }
            JavaConstant msg = graphKit.getConstantReflection().forString(this.message);
            ConstantNode msgNode = graphKit.createConstant((Constant)msg, JavaKind.Object);
            graphKit.createJavaCallWithExceptionAndUnwind(CallTargetNode.InvokeKind.Special, cons, new ValueNode[]{instance, msgNode});
            graphKit.append((ValueNode)new UnwindNode(instance));
            graphKit.mergeUnwinds();
            assert (graphKit.getGraph().verify());
            return graphKit.getGraph();
        }
    }

    private static class EqualsMethod
    extends ReflectionSubstitutionMethod {
        EqualsMethod(ResolvedJavaMethod original) {
            super(original);
        }

        public StructuredGraph buildGraph(DebugContext ctx, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
            HostedGraphKit graphKit = new HostedGraphKit(ctx, providers, method);
            ValueNode self = graphKit.loadLocal(0, JavaKind.Object);
            ValueNode other = graphKit.loadLocal(1, JavaKind.Object);
            ConstantNode trueValue = graphKit.createInt(1);
            ConstantNode falseValue = graphKit.createInt(0);
            LogicNode otherIsNull = (LogicNode)graphKit.append((ValueNode)IsNullNode.create((ValueNode)other));
            graphKit.startIf(otherIsNull, 0.4);
            graphKit.thenPart();
            graphKit.createReturn((ValueNode)falseValue, JavaKind.Boolean);
            graphKit.elsePart();
            PiNode otherNonNull = graphKit.createPiNode(other, StampFactory.objectNonNull());
            FloatingNode selfHub = graphKit.unique((FloatingNode)new LoadHubNode(providers.getStampProvider(), self));
            FloatingNode otherHub = graphKit.unique((FloatingNode)new LoadHubNode(providers.getStampProvider(), (ValueNode)otherNonNull));
            LogicNode equals = (LogicNode)graphKit.unique((FloatingNode)PointerEqualsNode.create((ValueNode)selfHub, (ValueNode)otherHub, (NodeView)NodeView.DEFAULT));
            graphKit.startIf(equals, 0.4);
            graphKit.thenPart();
            graphKit.createReturn((ValueNode)trueValue, JavaKind.Boolean);
            graphKit.elsePart();
            graphKit.createReturn((ValueNode)falseValue, JavaKind.Boolean);
            graphKit.endIf();
            graphKit.endIf();
            assert (graphKit.getGraph().verify());
            return graphKit.getGraph();
        }
    }

    private static class HashCodeMethod
    extends ReflectionSubstitutionMethod {
        private final int hashCode;

        HashCodeMethod(ResolvedJavaMethod original, int hashCode) {
            super(original);
            this.hashCode = hashCode;
        }

        public StructuredGraph buildGraph(DebugContext ctx, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
            HostedGraphKit graphKit = new HostedGraphKit(ctx, providers, method);
            ConstantNode nameNode = graphKit.createInt(this.hashCode);
            graphKit.createReturn((ValueNode)nameNode, JavaKind.Int);
            assert (graphKit.getGraph().verify());
            return graphKit.getGraph();
        }
    }

    private static class ToStringMethod
    extends ReflectionSubstitutionMethod {
        private final String name;

        ToStringMethod(ResolvedJavaMethod original, String name) {
            super(original);
            this.name = name;
        }

        public StructuredGraph buildGraph(DebugContext ctx, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
            HostedGraphKit graphKit = new HostedGraphKit(ctx, providers, method);
            ConstantNode nameNode = graphKit.createObject(this.name);
            graphKit.createReturn((ValueNode)nameNode, JavaKind.Object);
            assert (graphKit.getGraph().verify());
            return graphKit.getGraph();
        }
    }

    private static class ReflectiveNewInstanceMethod
    extends ReflectionSubstitutionMethod {
        private final Constructor<?> constructor;

        ReflectiveNewInstanceMethod(ResolvedJavaMethod original, Constructor<?> constructor) {
            super(original);
            this.constructor = constructor;
        }

        public StructuredGraph buildGraph(DebugContext ctx, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
            HostedGraphKit graphKit = new HostedGraphKit(ctx, providers, method);
            ResolvedJavaType type = providers.getMetaAccess().lookupJavaType(this.constructor.getDeclaringClass());
            graphKit.emitEnsureInitializedCall(type);
            ResolvedJavaMethod cons = providers.getMetaAccess().lookupJavaMethod(this.constructor);
            Class[] argTypes = this.constructor.getParameterTypes();
            ValueNode ret = graphKit.append((ValueNode)new NewInstanceNode(type, true));
            ValueNode[] args = new ValueNode[argTypes.length + 1];
            args[0] = ret;
            if (argTypes.length > 0) {
                ValueNode argumentArray = graphKit.loadLocal(1, JavaKind.Object);
                ReflectionSubstitutionType.fillArgsArray(graphKit, argumentArray, 1, args, argTypes);
            }
            graphKit.createJavaCallWithException(CallTargetNode.InvokeKind.Special, cons, args);
            graphKit.noExceptionPart();
            graphKit.createReturn(ret, JavaKind.Object);
            graphKit.exceptionPart();
            graphKit.throwInvocationTargetException();
            graphKit.endInvokeWithException();
            graphKit.mergeUnwinds();
            assert (graphKit.getGraph().verify());
            return graphKit.getGraph();
        }
    }

    private static class ReflectiveInvokeMethod
    extends ReflectionSubstitutionMethod {
        private final Method method;

        ReflectiveInvokeMethod(ResolvedJavaMethod original, Method method) {
            super(original);
            this.method = method;
        }

        public StructuredGraph buildGraph(DebugContext ctx, ResolvedJavaMethod m, HostedProviders providers, GraphProvider.Purpose purpose) {
            HostedGraphKit graphKit = new HostedGraphKit(ctx, providers, m);
            ResolvedJavaMethod targetMethod = providers.getMetaAccess().lookupJavaMethod((Executable)this.method);
            Class[] argTypes = this.method.getParameterTypes();
            int receiverOffset = targetMethod.isStatic() ? 0 : 1;
            ValueNode[] args = new ValueNode[argTypes.length + receiverOffset];
            if (targetMethod.isStatic()) {
                graphKit.emitEnsureInitializedCall(targetMethod.getDeclaringClass());
            } else {
                ValueNode receiver = graphKit.loadLocal(1, JavaKind.Object);
                args[0] = ReflectionSubstitutionType.createCheckcast(graphKit, receiver, targetMethod.getDeclaringClass(), true);
            }
            if (argTypes.length > 0) {
                ValueNode argumentArray = graphKit.loadLocal(2, JavaKind.Object);
                ReflectionSubstitutionType.fillArgsArray(graphKit, argumentArray, receiverOffset, args, argTypes);
            }
            CallTargetNode.InvokeKind invokeKind = targetMethod.isStatic() ? CallTargetNode.InvokeKind.Static : (targetMethod.isInterface() ? CallTargetNode.InvokeKind.Interface : (targetMethod.canBeStaticallyBound() || targetMethod.isConstructor() ? CallTargetNode.InvokeKind.Special : CallTargetNode.InvokeKind.Virtual));
            ValueNode ret = graphKit.createJavaCallWithException(invokeKind, targetMethod, args);
            graphKit.noExceptionPart();
            JavaKind retKind = targetMethod.getSignature().getReturnKind();
            if (retKind == JavaKind.Void) {
                ret = graphKit.createObject(null);
            } else if (retKind.isPrimitive()) {
                ResolvedJavaType boxedRetType = providers.getMetaAccess().lookupJavaType(retKind.toBoxedJavaClass());
                ret = graphKit.createBoxing(ret, retKind, boxedRetType);
            }
            graphKit.createReturn(ret, JavaKind.Object);
            graphKit.exceptionPart();
            graphKit.throwInvocationTargetException();
            graphKit.endInvokeWithException();
            graphKit.mergeUnwinds();
            assert (graphKit.getGraph().verify());
            return graphKit.getGraph();
        }
    }

    private static class ReflectiveWriteMethod
    extends ReflectionSubstitutionMethod {
        private final Field field;
        private final JavaKind kind;

        ReflectiveWriteMethod(ResolvedJavaMethod original, Field field, JavaKind kind) {
            super(original);
            this.field = field;
            this.kind = kind;
        }

        public StructuredGraph buildGraph(DebugContext ctx, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
            HostedGraphKit graphKit = new HostedGraphKit(ctx, providers, method);
            ResolvedJavaField targetField = providers.getMetaAccess().lookupJavaField(this.field);
            JavaKind fieldKind = targetField.getJavaKind();
            if (ReflectionSubstitutionType.isDeletedField(targetField)) {
                ReflectionSubstitutionType.handleDeletedField(graphKit, providers, targetField, JavaKind.Void);
            } else if (this.kind == JavaKind.Object || ReflectionSubstitutionType.canImplicitCast(this.kind, fieldKind)) {
                ValueNode receiver;
                if (targetField.isStatic()) {
                    receiver = null;
                    graphKit.emitEnsureInitializedCall(targetField.getDeclaringClass());
                } else {
                    receiver = graphKit.loadLocal(1, JavaKind.Object);
                    receiver = ReflectionSubstitutionType.createCheckcast(graphKit, receiver, targetField.getDeclaringClass(), true);
                }
                ValueNode value = graphKit.loadLocal(2, this.kind);
                if (this.kind == JavaKind.Object) {
                    if (fieldKind.isPrimitive()) {
                        for (JavaKind valueKind : JavaKind.values()) {
                            if (!ReflectionSubstitutionType.canImplicitCast(valueKind, fieldKind)) continue;
                            ResolvedJavaType type = providers.getMetaAccess().lookupJavaType(valueKind.toBoxedJavaClass());
                            TypeReference typeRef = TypeReference.createTrusted((Assumptions)graphKit.getAssumptions(), (ResolvedJavaType)type);
                            LogicNode condition = (LogicNode)graphKit.append((ValueNode)InstanceOfNode.create((TypeReference)typeRef, (ValueNode)value));
                            graphKit.startIf(condition, 0.5);
                            graphKit.thenPart();
                            PiNode boxed = graphKit.createPiNode(value, (Stamp)StampFactory.object((TypeReference)typeRef, (boolean)true));
                            ValueNode unboxed = graphKit.createUnboxing((ValueNode)boxed, valueKind);
                            ValueNode converted = ReflectionSubstitutionType.doImplicitCast(graphKit, valueKind, fieldKind, unboxed);
                            graphKit.append((ValueNode)new StoreFieldNode(receiver, targetField, converted));
                            graphKit.createReturn(null, JavaKind.Void);
                            graphKit.elsePart();
                        }
                        ResolvedJavaType expectedType = providers.getMetaAccess().lookupJavaType(fieldKind.toBoxedJavaClass());
                        ReflectionSubstitutionType.throwFailedCast(graphKit, expectedType, value);
                    } else {
                        ResolvedJavaType type = providers.getMetaAccess().lookupJavaType(this.field.getType());
                        value = ReflectionSubstitutionType.createCheckcast(graphKit, value, type, false);
                        graphKit.append((ValueNode)new StoreFieldNode(receiver, targetField, value));
                        graphKit.createReturn(null, JavaKind.Void);
                    }
                } else if (fieldKind == JavaKind.Object && !this.field.getType().equals(this.kind.toBoxedJavaClass())) {
                    ReflectionSubstitutionType.throwIllegalArgumentException(graphKit, "cannot write field of type " + targetField.getJavaKind() + " with Field." + method.getName());
                } else {
                    value = ReflectionSubstitutionType.doImplicitCast(graphKit, this.kind, fieldKind, value);
                    graphKit.append((ValueNode)new StoreFieldNode(receiver, targetField, value));
                    graphKit.createReturn(null, JavaKind.Void);
                }
            } else {
                ReflectionSubstitutionType.throwIllegalArgumentException(graphKit, "cannot write field of type " + targetField.getJavaKind() + " with Field." + method.getName());
            }
            graphKit.mergeUnwinds();
            assert (graphKit.getGraph().verify());
            return graphKit.getGraph();
        }
    }

    private static class ReflectiveReadMethod
    extends ReflectionSubstitutionMethod {
        private final Field field;
        private final JavaKind kind;

        ReflectiveReadMethod(ResolvedJavaMethod original, Field field, JavaKind kind) {
            super(original);
            this.field = field;
            this.kind = kind;
        }

        public StructuredGraph buildGraph(DebugContext ctx, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
            HostedGraphKit graphKit = new HostedGraphKit(ctx, providers, method);
            ResolvedJavaField targetField = providers.getMetaAccess().lookupJavaField(this.field);
            if (ReflectionSubstitutionType.isDeletedField(targetField)) {
                ReflectionSubstitutionType.handleDeletedField(graphKit, providers, targetField, this.kind);
            } else if (ReflectionSubstitutionType.canImplicitCast(targetField.getJavaKind(), this.kind)) {
                ValueNode receiver;
                if (targetField.isStatic()) {
                    receiver = null;
                    graphKit.emitEnsureInitializedCall(targetField.getDeclaringClass());
                } else {
                    receiver = graphKit.loadLocal(1, JavaKind.Object);
                    receiver = ReflectionSubstitutionType.createCheckcast(graphKit, receiver, targetField.getDeclaringClass(), true);
                }
                ValueNode ret = graphKit.append((ValueNode)LoadFieldNode.create((Assumptions)graphKit.getAssumptions(), (ValueNode)receiver, (ResolvedJavaField)targetField));
                ret = ReflectionSubstitutionType.doImplicitCast(graphKit, targetField.getJavaKind(), this.kind, ret);
                graphKit.createReturn(ret, this.kind);
            } else {
                ReflectionSubstitutionType.throwIllegalArgumentException(graphKit, "cannot read field of type " + targetField.getJavaKind() + " with " + method.getName());
            }
            assert (graphKit.getGraph().verify());
            return graphKit.getGraph();
        }
    }

    public static abstract class ReflectionSubstitutionMethod
    extends CustomSubstitutionMethod {
        public ReflectionSubstitutionMethod(ResolvedJavaMethod original) {
            super(original);
        }

        @Override
        public int getMaxLocals() {
            return this.original.getMaxLocals();
        }
    }
}

