/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.annotate.AnnotateOriginal;
import com.oracle.svm.core.util.VMError;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.StructuredGraph;

public class AnnotatedMethod
implements ResolvedJavaMethod,
GraphProvider {
    private final ResolvedJavaMethod original;
    private final ResolvedJavaMethod annotated;

    public AnnotatedMethod(ResolvedJavaMethod original, ResolvedJavaMethod annotated) {
        this.original = original;
        this.annotated = annotated;
    }

    public ResolvedJavaMethod getOriginal() {
        return this.original;
    }

    public ResolvedJavaMethod getAnnotated() {
        return this.annotated;
    }

    public String getName() {
        return this.original.getName();
    }

    public Signature getSignature() {
        return this.original.getSignature();
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        if (this.original instanceof GraphProvider) {
            return ((GraphProvider)this.original).buildGraph(debug, method, providers, purpose);
        }
        return null;
    }

    public boolean allowRuntimeCompilation() {
        if (this.original instanceof GraphProvider) {
            return ((GraphProvider)this.original).allowRuntimeCompilation();
        }
        return true;
    }

    public byte[] getCode() {
        return this.original.getCode();
    }

    public int getCodeSize() {
        return this.original.getCodeSize();
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.original.getDeclaringClass();
    }

    public int getMaxLocals() {
        return this.original.getMaxLocals();
    }

    public int getMaxStackSize() {
        return this.original.getMaxStackSize();
    }

    public int getModifiers() {
        return this.original.getModifiers();
    }

    public boolean isSynthetic() {
        return this.original.isSynthetic();
    }

    public boolean isVarArgs() {
        return this.original.isVarArgs();
    }

    public boolean isBridge() {
        return this.original.isBridge();
    }

    public boolean isClassInitializer() {
        return this.original.isClassInitializer();
    }

    public boolean isConstructor() {
        return this.original.isConstructor();
    }

    public boolean canBeStaticallyBound() {
        return this.original.canBeStaticallyBound();
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return this.original.getExceptionHandlers();
    }

    public StackTraceElement asStackTraceElement(int bci) {
        return this.original.asStackTraceElement(bci);
    }

    public ProfilingInfo getProfilingInfo(boolean includeNormal, boolean includeOSR) {
        return this.original.getProfilingInfo(includeNormal, includeOSR);
    }

    public ConstantPool getConstantPool() {
        return this.original.getConstantPool();
    }

    private Annotation[] getAnnotationsImpl(Function<ResolvedJavaMethod, Annotation[]> src) {
        Map result = Arrays.stream((Object[])src.apply(this.annotated)).filter(annotation -> !annotation.getClass().equals(AnnotateOriginal.class)).collect(Collectors.toMap(annotation -> annotation.getClass(), Function.identity()));
        for (Annotation annotation2 : src.apply(this.original)) {
            result.putIfAbsent(annotation2.getClass(), annotation2);
        }
        return result.values().toArray(new Annotation[result.size()]);
    }

    public Annotation[] getAnnotations() {
        return this.getAnnotationsImpl(AnnotatedElement::getAnnotations);
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotationsImpl(AnnotatedElement::getDeclaredAnnotations);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (annotationClass.equals(AnnotateOriginal.class)) {
            return null;
        }
        Annotation result = this.annotated.getAnnotation(annotationClass);
        if (result != null) {
            return (T)result;
        }
        return (T)this.original.getAnnotation(annotationClass);
    }

    public Annotation[][] getParameterAnnotations() {
        throw VMError.unimplemented();
    }

    public Type[] getGenericParameterTypes() {
        return this.original.getGenericParameterTypes();
    }

    public boolean canBeInlined() {
        return this.original.canBeInlined();
    }

    public boolean hasNeverInlineDirective() {
        return this.original.hasNeverInlineDirective();
    }

    public boolean shouldBeInlined() {
        return this.original.shouldBeInlined();
    }

    public LineNumberTable getLineNumberTable() {
        return this.original.getLineNumberTable();
    }

    public String toString() {
        return "AnnotatedMethod<definition/implementation " + this.original.toString() + ", extra annotations " + Arrays.toString(this.getAnnotations()) + ">";
    }

    public LocalVariableTable getLocalVariableTable() {
        return this.original.getLocalVariableTable();
    }

    public void reprofile() {
        this.original.reprofile();
    }

    public Constant getEncoding() {
        return this.original.getEncoding();
    }

    public boolean isInVirtualMethodTable(ResolvedJavaType resolved) {
        return this.original.isInVirtualMethodTable(resolved);
    }

    public boolean isDefault() {
        return this.original.isDefault();
    }

    public SpeculationLog getSpeculationLog() {
        return this.original.getSpeculationLog();
    }
}

