/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.objectfile.BasicProgbitsSectionImpl;
import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.SectionName;
import com.oracle.objectfile.macho.MachOObjectFile;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.CConst;
import com.oracle.svm.core.c.CGlobalDataImpl;
import com.oracle.svm.core.c.CHeader;
import com.oracle.svm.core.c.CTypedef;
import com.oracle.svm.core.c.CUnsigned;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.c.function.GraalIsolateHeader;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.graal.code.CGlobalDataReference;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import com.oracle.svm.hosted.c.GraalAccess;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.codegen.CSourceCodeWriter;
import com.oracle.svm.hosted.c.codegen.QueryCodeWriter;
import com.oracle.svm.hosted.code.CEntryPointCallStubMethod;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.image.AbstractBootImage;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.meta.MethodPointer;
import com.oracle.svm.util.ReflectionUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.invoke.MethodType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataSectionReference;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.serviceprovider.BufferUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CFunctionPointer;

public abstract class NativeBootImage
extends AbstractBootImage {
    public static final long RWDATA_CGLOBALS_PARTITION_OFFSET = 0L;
    private final ObjectFile objectFile;
    private final int wordSize;
    private final Set<HostedMethod> uniqueEntryPoints = new HashSet<HostedMethod>();
    private ObjectFile.Section textSection;
    private ObjectFile.Section roDataSection;
    private ObjectFile.Section rwDataSection;
    private ObjectFile.Section heapSection;

    @Override
    public ObjectFile.Section getTextSection() {
        assert (this.textSection != null);
        return this.textSection;
    }

    @Override
    public abstract String[] makeLaunchCommand(AbstractBootImage.NativeImageKind var1, String var2, Path var3, Path var4, Method var5);

    protected final void write(Path outputFile) {
        try {
            Path outFileParent = outputFile.normalize().getParent();
            if (outFileParent != null) {
                Files.createDirectories(outFileParent, new FileAttribute[0]);
            }
            FileChannel channel = FileChannel.open(outputFile, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            this.objectFile.write(channel);
        }
        catch (Exception ex) {
            throw VMError.shouldNotReachHere(ex);
        }
        this.resultingImageSize = (int)outputFile.toFile().length();
        if (NativeImageOptions.PrintImageElementSizes.getValue().booleanValue()) {
            for (ObjectFile.Element e : this.objectFile.getElements()) {
                System.out.printf("PrintImageElementSizes:  size: %15d  name: %s\n", e.getMemSize(this.objectFile.getDecisionsByElement()), e.getElementName());
            }
        }
    }

    void writeHeaderFiles(Path outputDir, String imageName, Map<ResolvedJavaMethod, String> symbolAliases, boolean dynamic) {
        Map hostedMethods = this.uniqueEntryPoints.stream().filter(this::shouldWriteHeader).map(m -> Pair.create(NativeBootImage.cHeader(m), (Object)m)).collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toList())));
        hostedMethods.forEach((headerClass, methods) -> {
            methods.sort(NativeBootImage::sortMethodsByFileNameAndPosition);
            CHeader.Header header = headerClass == CHeader.Header.class ? NativeBootImage.defaultCHeaderAnnotation(imageName) : NativeBootImage.instantiateCHeader(headerClass);
            this.writeHeaderFile(outputDir, header, (List<HostedMethod>)methods, symbolAliases, dynamic);
        });
    }

    private void writeHeaderFile(Path outDir, CHeader.Header header, List<HostedMethod> methods, Map<ResolvedJavaMethod, String> symbolAliases, boolean dynamic) {
        CSourceCodeWriter writer = new CSourceCodeWriter(outDir.getParent());
        String imageHeaderGuard = "__" + header.name().toUpperCase().replaceAll("[^A-Z0-9]", "_") + "_H";
        String dynamicSuffix = dynamic ? "_dynamic.h" : ".h";
        writer.appendln("#ifndef " + imageHeaderGuard);
        writer.appendln("#define " + imageHeaderGuard);
        writer.appendln();
        QueryCodeWriter.writeCStandardHeaders(writer);
        List<String> dependencies = header.dependsOn().stream().map(NativeBootImage::instantiateCHeader).map(depHeader -> "<" + depHeader.name() + dynamicSuffix + ">").collect(Collectors.toList());
        writer.includeFiles(dependencies);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(baos);
        header.writePreamble(printWriter);
        printWriter.flush();
        for (String line : baos.toString().split("\\r?\\n")) {
            writer.appendln(line);
        }
        if (methods.size() > 0) {
            writer.appendln();
            writer.appendln("#if defined(__cplusplus)");
            writer.appendln("extern \"C\" {");
            writer.appendln("#endif");
            writer.appendln();
            methods.forEach(m -> this.writeMethodHeader((HostedMethod)m, writer, symbolAliases, dynamic));
            writer.appendln("#if defined(__cplusplus)");
            writer.appendln("}");
            writer.appendln("#endif");
        }
        writer.appendln("#endif");
        Path fileNamePath = outDir.getFileName();
        if (fileNamePath == null) {
            throw UserError.abort("Cannot determine header file name for directory " + outDir);
        }
        String fileName = fileNamePath.resolve(header.name() + dynamicSuffix).toString();
        writer.writeFile(fileName, false);
    }

    private static Class<? extends CHeader.Header> cHeader(HostedMethod entryPointStub) {
        AnalysisMethod entryPoint = CEntryPointCallStubSupport.singleton().getMethodForStub((CEntryPointCallStubMethod)entryPointStub.wrapped.wrapped);
        CHeader methodAnnotation = (CHeader)entryPoint.getDeclaredAnnotation(CHeader.class);
        if (methodAnnotation != null) {
            return methodAnnotation.value();
        }
        for (AnalysisType enclosingType = entryPoint.getDeclaringClass(); enclosingType != null; enclosingType = enclosingType.getEnclosingType()) {
            CHeader enclosing = (CHeader)enclosingType.getDeclaredAnnotation(CHeader.class);
            if (enclosing == null) continue;
            return enclosing.value();
        }
        return CHeader.Header.class;
    }

    private static CHeader.Header instantiateCHeader(Class<? extends CHeader.Header> header) {
        try {
            return (CHeader.Header)ReflectionUtil.newInstance(header);
        }
        catch (ReflectionUtil.ReflectionUtilError ex) {
            throw UserError.abort("CHeader " + header.getName() + " cannot be instantiated. Please make sure that it has a nullary constructor and is not abstract.", ex.getCause());
        }
    }

    private static CHeader.Header defaultCHeaderAnnotation(final String defaultHeaderName) {
        return new CHeader.Header(){

            @Override
            public String name() {
                return defaultHeaderName;
            }

            @Override
            public List<Class<? extends CHeader.Header>> dependsOn() {
                return Collections.singletonList(GraalIsolateHeader.class);
            }
        };
    }

    private static int sortMethodsByFileNameAndPosition(HostedMethod stub1, HostedMethod stub2) {
        ResolvedJavaMethod rm1 = CEntryPointCallStubSupport.singleton().getMethodForStub((CEntryPointCallStubMethod)((CEntryPointCallStubMethod)stub1.wrapped.wrapped)).wrapped;
        ResolvedJavaMethod rm2 = CEntryPointCallStubSupport.singleton().getMethodForStub((CEntryPointCallStubMethod)((CEntryPointCallStubMethod)stub2.wrapped.wrapped)).wrapped;
        int fileComparison = rm1.getDeclaringClass().getSourceFileName().compareTo(rm2.getDeclaringClass().getSourceFileName());
        if (fileComparison != 0) {
            return fileComparison;
        }
        if (rm1.getLineNumberTable() != null && rm2.getLineNumberTable() != null) {
            return rm1.getLineNumberTable().getLineNumber(0) - rm2.getLineNumberTable().getLineNumber(0);
        }
        return 0;
    }

    private void writeMethodHeader(HostedMethod m, CSourceCodeWriter writer, Map<ResolvedJavaMethod, String> symbolAliases, boolean dynamic) {
        String symbolName;
        assert (Modifier.isStatic(m.getModifiers())) : "Published methods that go into the header must be static.";
        CEntryPointData cEntryPointData = (CEntryPointData)m.getWrapped().getEntryPointData();
        String docComment = cEntryPointData.getDocumentation();
        if (docComment != null && !docComment.isEmpty()) {
            writer.appendln("/*");
            Arrays.stream(docComment.split("\n")).forEach(l -> writer.appendln(" * " + l));
            writer.appendln(" */");
        }
        if ((symbolName = symbolAliases.get(m)) == null || symbolName.isEmpty()) {
            symbolName = cEntryPointData.getSymbolName();
        }
        if (dynamic) {
            writer.append("typedef ");
        }
        AnnotatedType annotatedReturnType = this.getAnnotatedReturnType(m);
        writer.append(CSourceCodeWriter.toCTypeName(m, (ResolvedJavaType)m.getSignature().getReturnType((ResolvedJavaType)m.getDeclaringClass()), Optional.ofNullable(annotatedReturnType.getAnnotation(CTypedef.class)).map(CTypedef::name), false, annotatedReturnType.isAnnotationPresent(CUnsigned.class), (MetaAccessProvider)this.metaAccess, this.nativeLibs));
        writer.append(" ");
        assert (!symbolName.isEmpty());
        if (dynamic) {
            writer.append("(*").append(symbolName).append("_fn_t)");
        } else {
            writer.append(symbolName);
        }
        writer.append("(");
        String sep = "";
        AnnotatedType[] annotatedParameterTypes = this.getAnnotatedParameterTypes(m);
        ResolvedJavaMethod.Parameter[] parameters = m.getParameters();
        assert (parameters != null);
        for (int i = 0; i < m.getSignature().getParameterCount(false); ++i) {
            writer.append(sep);
            sep = ", ";
            writer.append(CSourceCodeWriter.toCTypeName(m, (ResolvedJavaType)m.getSignature().getParameterType(i, (ResolvedJavaType)m.getDeclaringClass()), Optional.ofNullable(annotatedParameterTypes[i].getAnnotation(CTypedef.class)).map(CTypedef::name), annotatedParameterTypes[i].isAnnotationPresent(CConst.class), annotatedParameterTypes[i].isAnnotationPresent(CUnsigned.class), (MetaAccessProvider)this.metaAccess, this.nativeLibs));
            if (!parameters[i].isNamePresent()) continue;
            writer.append(" ");
            writer.append(parameters[i].getName());
        }
        writer.appendln(");");
        writer.appendln();
    }

    private AnnotatedType getAnnotatedReturnType(HostedMethod hostedMethod) {
        return this.getMethod(hostedMethod).getAnnotatedReturnType();
    }

    private AnnotatedType[] getAnnotatedParameterTypes(HostedMethod hostedMethod) {
        return this.getMethod(hostedMethod).getAnnotatedParameterTypes();
    }

    private Method getMethod(HostedMethod hostedMethod) {
        Method method;
        AnalysisMethod entryPoint = CEntryPointCallStubSupport.singleton().getMethodForStub((CEntryPointCallStubMethod)hostedMethod.wrapped.wrapped);
        try {
            method = entryPoint.getDeclaringClass().getJavaClass().getDeclaredMethod(entryPoint.getName(), MethodType.fromMethodDescriptorString(entryPoint.getSignature().toMethodDescriptor(), this.imageClassLoader).parameterArray());
        }
        catch (NoSuchMethodException e) {
            throw VMError.shouldNotReachHere(e);
        }
        return method;
    }

    private boolean shouldWriteHeader(HostedMethod method) {
        Object data = method.getWrapped().getEntryPointData();
        return data instanceof CEntryPointData && ((CEntryPointData)data).getPublishAs() == CEntryPointOptions.Publish.SymbolAndHeader;
    }

    private ObjectFile.Symbol defineDataSymbol(String name, ObjectFile.Element section, long position) {
        return this.objectFile.createDefinedSymbol(name, section, position, this.wordSize, false, true);
    }

    @Override
    public void build(DebugContext debug) {
        try (DebugContext.Scope buildScope = debug.scope((Object)"NativeBootImage.build");){
            BasicProgbitsSectionImpl heapSectionImpl;
            RelocatableBuffer heapSectionBuffer;
            CGlobalDataFeature cGlobals = CGlobalDataFeature.singleton();
            int textSectionSize = this.codeCache.getCodeCacheSize();
            int roConstantsSize = this.codeCache.getAlignedConstantsSize();
            int cglobalsSize = ConfigurationValues.getObjectLayout().alignUp(cGlobals.getSize());
            if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                this.heap.alignRelocatablePartition(this.objectFile.getPageSize());
            }
            long roSectionSize = roConstantsSize;
            long rwSectionSize = cglobalsSize;
            if (!SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                roSectionSize += this.heap.getReadOnlySectionSize();
                rwSectionSize += this.heap.getWritableSectionSize();
            }
            RelocatableBuffer textBuffer = RelocatableBuffer.factory("text", textSectionSize, this.objectFile.getByteOrder());
            NativeTextSectionImpl textImpl = NativeTextSectionImpl.factory(textBuffer, this.objectFile, this.codeCache);
            String textSectionName = SectionName.TEXT.getFormatDependentName(this.objectFile.getFormat());
            this.textSection = this.objectFile.newProgbitsSection(textSectionName, this.objectFile.getPageSize(), false, true, (ObjectFile.ProgbitsSectionImpl)textImpl);
            RelocatableBuffer roDataBuffer = RelocatableBuffer.factory("roData", roSectionSize, this.objectFile.getByteOrder());
            BasicProgbitsSectionImpl roDataImpl = new BasicProgbitsSectionImpl(roDataBuffer.getBytes());
            String roDataSectionName = SectionName.RODATA.getFormatDependentName(this.objectFile.getFormat());
            this.roDataSection = this.objectFile.newProgbitsSection(roDataSectionName, this.objectFile.getPageSize(), false, false, (ObjectFile.ProgbitsSectionImpl)roDataImpl);
            RelocatableBuffer rwDataBuffer = RelocatableBuffer.factory("rwData", rwSectionSize, this.objectFile.getByteOrder());
            BasicProgbitsSectionImpl rwDataImpl = new BasicProgbitsSectionImpl(rwDataBuffer.getBytes());
            String rwDataSectionName = SectionName.DATA.getFormatDependentName(this.objectFile.getFormat());
            this.rwDataSection = this.objectFile.newProgbitsSection(rwDataSectionName, this.objectFile.getPageSize(), true, false, (ObjectFile.ProgbitsSectionImpl)rwDataImpl);
            this.objectFile.createDefinedSymbol(this.textSection.getName(), (ObjectFile.Element)this.textSection, 0L, 0, false, false);
            this.objectFile.createDefinedSymbol("__svm_text_end", (ObjectFile.Element)this.textSection, (long)textSectionSize, 0, false, true);
            this.objectFile.createDefinedSymbol(this.roDataSection.getName(), (ObjectFile.Element)this.roDataSection, 0L, 0, false, false);
            this.objectFile.createDefinedSymbol(this.rwDataSection.getName(), (ObjectFile.Element)this.rwDataSection, 0L, 0, false, false);
            long constantsPartitionOffset = 0L;
            long roConstantsEndOffset = 0L + (long)roConstantsSize;
            long rwGlobalsEndOffset = 0L + (long)ConfigurationValues.getObjectLayout().alignUp(cGlobals.getSize());
            if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                boolean writable = SubstrateOptions.SpawnIsolates.getValue() == false;
                long heapSize = this.heap.getReadOnlySectionSize() + this.heap.getWritableSectionSize();
                heapSectionBuffer = RelocatableBuffer.factory("heap", heapSize, this.objectFile.getByteOrder());
                heapSectionImpl = new BasicProgbitsSectionImpl(heapSectionBuffer.getBytes());
                String heapSectionName = SectionName.SVM_HEAP.getFormatDependentName(this.objectFile.getFormat());
                this.heapSection = this.objectFile.newProgbitsSection(heapSectionName, this.objectFile.getPageSize(), writable, false, (ObjectFile.ProgbitsSectionImpl)heapSectionImpl);
                this.objectFile.createDefinedSymbol(this.heapSection.getName(), (ObjectFile.Element)this.heapSection, 0L, 0, false, false);
                this.heap.setReadOnlySection(this.heapSection.getName(), 0L);
                long writableSectionOffset = this.heap.getReadOnlySectionSize();
                this.heap.setWritableSection(this.heapSection.getName(), writableSectionOffset);
                this.defineDataSymbol("__svm_heap_begin", (ObjectFile.Element)this.heapSection, 0L);
                this.defineDataSymbol("__svm_heap_end", (ObjectFile.Element)this.heapSection, heapSize);
                this.defineDataSymbol("__svm_heap_writable_begin", (ObjectFile.Element)this.heapSection, writableSectionOffset);
                this.defineDataSymbol("__svm_heap_writable_end", (ObjectFile.Element)this.heapSection, writableSectionOffset + this.heap.getWritableSectionSize());
                long relocatableOffset = this.heap.getReadOnlyRelocatablePartitionOffset();
                long relocatableSize = this.heap.getReadOnlyRelocatablePartitionSize();
                this.defineDataSymbol("__svm_heap_relocatable_begin", (ObjectFile.Element)this.heapSection, relocatableOffset);
                this.defineDataSymbol("__svm_heap_relocatable_end", (ObjectFile.Element)this.heapSection, relocatableOffset + relocatableSize);
            } else {
                heapSectionBuffer = null;
                heapSectionImpl = null;
                this.heap.setReadOnlySection(this.roDataSection.getName(), roConstantsEndOffset);
                this.heap.setWritableSection(this.rwDataSection.getName(), rwGlobalsEndOffset);
            }
            textImpl.writeTextSection(debug, this.textSection, this.entryPoints);
            this.codeCache.writeConstants(roDataBuffer);
            cGlobals.writeData(rwDataBuffer, (offset, symbolName) -> this.defineDataSymbol((String)symbolName, (ObjectFile.Element)this.rwDataSection, (long)offset.intValue() + 0L));
            this.defineDataSymbol("__svm_cglobaldata_base", (ObjectFile.Element)this.rwDataSection, 0L);
            if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                this.heap.writeHeap(debug, heapSectionBuffer, heapSectionBuffer);
                long firstRelocOffset = this.heap.getFirstRelocatablePointerOffsetInSection();
                this.defineDataSymbol("__svm_heap_relocatable_first_reloc_pointer", (ObjectFile.Element)this.heapSection, firstRelocOffset);
                assert (NativeBootImage.castToByteBuffer(heapSectionBuffer).getLong((int)firstRelocOffset) == 0L);
            } else {
                assert (heapSectionBuffer == null);
                this.heap.writeHeap(debug, roDataBuffer, rwDataBuffer);
            }
            this.markRelocationSitesFromMaps(textBuffer, (ObjectFile.ProgbitsSectionImpl)textImpl, this.heap.objects);
            this.markRelocationSitesFromMaps(roDataBuffer, (ObjectFile.ProgbitsSectionImpl)roDataImpl, this.heap.objects);
            this.markRelocationSitesFromMaps(rwDataBuffer, (ObjectFile.ProgbitsSectionImpl)rwDataImpl, this.heap.objects);
            if (heapSectionBuffer != null) {
                this.markRelocationSitesFromMaps(heapSectionBuffer, (ObjectFile.ProgbitsSectionImpl)heapSectionImpl, this.heap.objects);
            }
        }
    }

    private static ByteBuffer castToByteBuffer(RelocatableBuffer heapSectionBuffer) {
        return (ByteBuffer)BufferUtil.asBaseBuffer((Buffer)heapSectionBuffer.getBuffer().asReadOnlyBuffer()).position(0);
    }

    private void markRelocationSitesFromMaps(RelocatableBuffer relocationMap, ObjectFile.ProgbitsSectionImpl sectionImpl, Map<Object, NativeImageHeap.ObjectInfo> objectMap) {
        for (Map.Entry<Integer, RelocatableBuffer.Info> entry : relocationMap.entrySet()) {
            int offset = entry.getKey();
            RelocatableBuffer.Info info = entry.getValue();
            assert (GraalAccess.getOriginalTarget().arch instanceof AArch64 || NativeBootImage.checkEmbeddedOffset(sectionImpl, offset, info));
            if (info.getTargetObject() instanceof CFunctionPointer) {
                NativeBootImage.markFunctionRelocationSite(sectionImpl, offset, info);
                continue;
            }
            if (sectionImpl.getElement() == this.textSection) {
                this.markDataRelocationSiteFromText(relocationMap, sectionImpl, offset, info, objectMap);
                continue;
            }
            Object targetObject = info.getTargetObject();
            NativeImageHeap.ObjectInfo targetObjectInfo = objectMap.get(targetObject);
            NativeBootImage.markDataRelocationSite(sectionImpl, offset, info, targetObjectInfo);
        }
    }

    private static boolean checkEmbeddedOffset(ObjectFile.ProgbitsSectionImpl sectionImpl, int offset, RelocatableBuffer.Info info) {
        ByteBuffer dataBuf = ByteBuffer.wrap(sectionImpl.getContent()).order(sectionImpl.getElement().getOwner().getByteOrder());
        if (info.getRelocationSize() == 8) {
            long value = dataBuf.getLong(offset);
            assert (value == 0L || value == -2401018187971961171L) : String.format("unexpected embedded offset: 0x%x, info: %s", value, info);
        } else if (info.getRelocationSize() == 4) {
            int value = dataBuf.getInt(offset);
            assert (value == 0 || value == -559030611) : "unexpected embedded offset";
        } else {
            VMError.shouldNotReachHere("unsupported relocation size: " + info.getRelocationSize());
        }
        return true;
    }

    private static void markFunctionRelocationSite(ObjectFile.ProgbitsSectionImpl sectionImpl, int offset, RelocatableBuffer.Info info) {
        assert (info.getTargetObject() instanceof CFunctionPointer) : "Wrong type for FunctionPointer relocation: " + info.getTargetObject().toString();
        int functionPointerRelocationSize = 8;
        assert (info.getRelocationSize() == 8) : "Function relocation: " + info.getRelocationSize() + " should be " + 8 + " bytes.";
        ResolvedJavaMethod method = ((MethodPointer)info.getTargetObject()).getMethod();
        sectionImpl.markRelocationSite(offset, 8, ObjectFile.RelocationKind.DIRECT, NativeBootImage.localSymbolNameForMethod(method), false, Long.valueOf(0L));
    }

    private static void markDataRelocationSite(ObjectFile.ProgbitsSectionImpl sectionImpl, int offset, RelocatableBuffer.Info info, NativeImageHeap.ObjectInfo targetObjectInfo) {
        assert (info.getRelocationSize() == 4 || info.getRelocationSize() == 8) : "Data relocation size should be 4 or 8 bytes.";
        assert (targetObjectInfo != null);
        NativeImageHeap.HeapPartition partition = targetObjectInfo.getPartition();
        assert (partition != null);
        String targetSectionName = partition.getSectionName();
        long targetOffsetInSection = targetObjectInfo.getOffsetInSection();
        long relocationInfoAddend = info.hasExplicitAddend() ? info.getExplicitAddend() : 0L;
        long relocationAddend = targetOffsetInSection + relocationInfoAddend;
        sectionImpl.markRelocationSite(offset, info.getRelocationSize(), info.getRelocationKind(), targetSectionName, false, Long.valueOf(relocationAddend));
    }

    private void markDataRelocationSiteFromText(RelocatableBuffer buffer, ObjectFile.ProgbitsSectionImpl sectionImpl, int offset, RelocatableBuffer.Info info, Map<Object, NativeImageHeap.ObjectInfo> objectMap) {
        assert (ConfigurationValues.getTarget().arch instanceof AArch64 || info.getRelocationSize() == 4 || info.getRelocationSize() == 8) : "Data relocation size should be 4 or 8 bytes. Got size: " + info.getRelocationSize();
        Object target = info.getTargetObject();
        if (target instanceof DataSectionReference) {
            long addend = (long)((DataSectionReference)target).getOffset() - info.getExplicitAddend();
            sectionImpl.markRelocationSite(offset, info.getRelocationSize(), info.getRelocationKind(), this.roDataSection.getName(), false, Long.valueOf(addend));
        } else if (target instanceof CGlobalDataReference) {
            CGlobalDataReference ref = (CGlobalDataReference)((Object)target);
            CGlobalDataInfo dataInfo = ref.getDataInfo();
            CGlobalDataImpl<?> data = dataInfo.getData();
            long addend = 0L + (long)dataInfo.getOffset() - info.getExplicitAddend();
            sectionImpl.markRelocationSite(offset, info.getRelocationSize(), info.getRelocationKind(), this.rwDataSection.getName(), false, Long.valueOf(addend));
            if (dataInfo.isSymbolReference()) {
                if (this.objectFile.getSymbolTable().getSymbol(data.symbolName) == null) {
                    this.objectFile.createUndefinedSymbol(data.symbolName, 0, true);
                }
                ObjectFile.ProgbitsSectionImpl baseSectionImpl = (ObjectFile.ProgbitsSectionImpl)this.rwDataSection.getImpl();
                int offsetInSection = Math.toIntExact(0L + (long)dataInfo.getOffset());
                baseSectionImpl.markRelocationSite(offsetInSection, this.wordSize, ObjectFile.RelocationKind.DIRECT, data.symbolName, false, Long.valueOf(0L));
            }
        } else if (target instanceof ConstantReference) {
            assert (info.getRelocationKind() == ObjectFile.RelocationKind.DIRECT);
            Object object = SubstrateObjectConstant.asObject((Constant)((ConstantReference)target).getConstant());
            long targetOffset = objectMap.get(object).getOffsetInSection();
            int encShift = ((CompressEncoding)ImageSingletons.lookup(CompressEncoding.class)).getShift();
            long targetValue = targetOffset >>> encShift;
            assert (targetValue << encShift == targetOffset) : "Reference compression shift discards non-zero bits: " + Long.toHexString(targetOffset);
            Architecture arch = GraalAccess.getOriginalTarget().arch;
            if (arch instanceof AMD64) {
                if (info.getRelocationSize() == 8) {
                    buffer.getBuffer().putLong(offset, targetValue);
                } else if (info.getRelocationSize() == 4) {
                    buffer.getBuffer().putInt(offset, NumUtil.safeToInt((long)targetValue));
                } else {
                    new Exception().printStackTrace();
                    VMError.shouldNotReachHere("Unsupported object reference size: " + info.getRelocationSize());
                }
            } else if (arch instanceof AArch64) {
                int numInstrs = info.getRelocationSize() / 2;
                long curValue = targetValue;
                for (int i = 0; i < numInstrs; ++i) {
                    int instrValue = (int)(curValue & 0xFFFFL);
                    int prevValue = buffer.getBuffer().getInt(offset + 4 * i);
                    int newValue = prevValue & 0xFFE0001F | (instrValue <<= 5);
                    buffer.getBuffer().putInt(offset + 4 * i, 0xFFFFFFFF & newValue);
                    curValue >>= 16;
                }
            }
        } else {
            throw VMError.shouldNotReachHere("Unsupported target object for relocation in text section");
        }
    }

    public static String localSymbolNameForMethod(Method m) {
        return SubstrateUtil.uniqueShortName(m);
    }

    public static String localSymbolNameForMethod(ResolvedJavaMethod sm) {
        return SubstrateUtil.uniqueShortName(sm);
    }

    public static String globalSymbolNameForMethod(Method m) {
        return SubstrateUtil.mangleName(SubstrateUtil.uniqueShortName(m));
    }

    public static String globalSymbolNameForMethod(ResolvedJavaMethod sm) {
        return SubstrateUtil.mangleName(SubstrateUtil.uniqueShortName(sm));
    }

    @Override
    public ObjectFile getOrCreateDebugObjectFile() {
        assert (this.objectFile != null);
        return this.objectFile;
    }

    public NativeBootImage(AbstractBootImage.NativeImageKind k, HostedUniverse universe, HostedMetaAccess metaAccess, NativeLibraries nativeLibs, NativeImageHeap heap, NativeImageCodeCache codeCache, List<HostedMethod> entryPoints, HostedMethod mainEntryPoint, ClassLoader imageClassLoader) {
        super(k, universe, metaAccess, nativeLibs, heap, codeCache, entryPoints, imageClassLoader);
        this.uniqueEntryPoints.addAll(entryPoints);
        if (NativeImageOptions.MachODebugInfoTesting.getValue().booleanValue()) {
            this.objectFile = new MachOObjectFile();
        } else {
            this.objectFile = ObjectFile.getNativeObjectFile();
            if (this.objectFile == null) {
                throw new Error("Unsupported objectfile format: " + ObjectFile.getNativeFormat());
            }
        }
        if (mainEntryPoint != null) {
            this.objectFile.setMainEntryPoint(NativeBootImage.globalSymbolNameForMethod(mainEntryPoint));
        }
        this.objectFile.setByteOrder(ConfigurationValues.getTarget().arch.getByteOrder());
        int pageSize = NativeImageOptions.PageSize.getValue();
        if (pageSize > 0) {
            this.objectFile.setPageSize(pageSize);
        }
        this.wordSize = FrameAccess.wordSize();
        assert (this.objectFile.getWordSizeInBytes() == this.wordSize);
    }

    public static abstract class NativeTextSectionImpl
    extends BasicProgbitsSectionImpl {
        protected final RelocatableBuffer textBuffer;
        protected final ObjectFile objectFile;
        protected final NativeImageCodeCache codeCache;

        public static NativeTextSectionImpl factory(RelocatableBuffer relocatableBuffer, ObjectFile objectFile, NativeImageCodeCache codeCache) {
            return codeCache.getTextSectionImpl(relocatableBuffer, objectFile, codeCache);
        }

        private ObjectFile.Element getRodataSection() {
            return this.getElement().getOwner().elementForName(SectionName.RODATA.getFormatDependentName(this.getElement().getOwner().getFormat()));
        }

        public Set<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
            HashSet deps = ObjectFile.minimalDependencies(decisions, (ObjectFile.Element)this.getElement());
            LayoutDecision ourContent = decisions.get(this.getElement()).getDecision(LayoutDecision.Kind.CONTENT);
            LayoutDecision ourVaddr = decisions.get(this.getElement()).getDecision(LayoutDecision.Kind.VADDR);
            LayoutDecision rodataVaddr = decisions.get(this.getRodataSection()).getDecision(LayoutDecision.Kind.VADDR);
            deps.add(BuildDependency.createOrGet((LayoutDecision)ourContent, (LayoutDecision)ourVaddr));
            deps.add(BuildDependency.createOrGet((LayoutDecision)ourContent, (LayoutDecision)rodataVaddr));
            return deps;
        }

        public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
            return this.getContent();
        }

        protected abstract void defineMethodSymbol(String var1, boolean var2, ObjectFile.Element var3, HostedMethod var4, CompilationResult var5);

        protected void writeTextSection(DebugContext debug, ObjectFile.Section textSection, List<HostedMethod> entryPoints) {
            try (Indent indent = debug.logAndIndent("TextImpl.writeTextSection");){
                HashMap<String, HostedMethod> methodsBySignature = new HashMap<String, HostedMethod>();
                for (Map.Entry<HostedMethod, CompilationResult> entry : this.codeCache.getCompilations().entrySet()) {
                    String symName = NativeBootImage.localSymbolNameForMethod(entry.getKey());
                    String signatureString = SubstrateUtil.uniqueShortName(entry.getKey());
                    HostedMethod existing = (HostedMethod)methodsBySignature.get(signatureString);
                    HostedMethod current = entry.getKey();
                    if (existing != null) {
                        ResolvedJavaType currentReturnType;
                        ResolvedJavaType existingReturnType = existing.getSignature().getReturnType(null).resolve((ResolvedJavaType)existing.getDeclaringClass());
                        if (existingReturnType.isAssignableFrom(currentReturnType = current.getSignature().getReturnType(null).resolve((ResolvedJavaType)current.getDeclaringClass()))) {
                            HostedMethod replaced = methodsBySignature.put(signatureString, current);
                            assert (replaced.equals(existing));
                        }
                    } else {
                        methodsBySignature.put(signatureString, current);
                    }
                    this.defineMethodSymbol(symName, entryPoints.contains(current), (ObjectFile.Element)textSection, current, entry.getValue());
                }
                for (Map.Entry<HostedMethod, Object> entry : methodsBySignature.entrySet()) {
                    int entryPointIndex;
                    CEntryPointData cEntryData;
                    HostedMethod method = (HostedMethod)entry.getValue();
                    Object data = method.getWrapped().getEntryPointData();
                    CEntryPointData cEntryPointData = cEntryData = data instanceof CEntryPointData ? (CEntryPointData)data : null;
                    if (cEntryData != null && cEntryData.getPublishAs() == CEntryPointOptions.Publish.NotPublished || (entryPointIndex = entryPoints.indexOf(method)) == -1) continue;
                    String mangledSignature = SubstrateUtil.mangleName((String)((Object)entry.getKey()));
                    assert (mangledSignature.equals(NativeBootImage.globalSymbolNameForMethod(method)));
                    this.defineMethodSymbol(mangledSignature, true, (ObjectFile.Element)textSection, method, null);
                    if (cEntryData == null) continue;
                    assert (!cEntryData.getSymbolName().isEmpty());
                    this.defineMethodSymbol(cEntryData.getSymbolName(), true, (ObjectFile.Element)textSection, method, this.codeCache.getCompilations().get(method));
                }
                assert (this.textBuffer.mapSize() == 0);
                this.codeCache.patchMethods(debug, this.textBuffer, this.objectFile);
                this.codeCache.writeCode(this.textBuffer);
            }
        }

        protected NativeTextSectionImpl(RelocatableBuffer relocatableBuffer, ObjectFile objectFile, NativeImageCodeCache codeCache) {
            super(relocatableBuffer.getBytes());
            this.textBuffer = relocatableBuffer;
            this.objectFile = objectFile;
            this.codeCache = codeCache;
        }
    }
}

