/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.os.IsDefined;
import com.oracle.svm.core.posix.JavaNetNetUtil;
import com.oracle.svm.core.posix.JavaNetNetUtilMD;
import com.oracle.svm.core.posix.JavaNetNetworkInterface;
import com.oracle.svm.core.posix.Target_java_net_InetAddress;
import com.oracle.svm.core.posix.VmPrimsJNI;
import com.oracle.svm.core.posix.headers.NetIf;
import com.oracle.svm.core.posix.headers.NetinetIn;
import com.oracle.svm.core.posix.headers.Socket;
import com.oracle.svm.core.util.Utf8;
import com.oracle.svm.core.util.VMError;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.WordFactory;

@TargetClass(value=NetworkInterface.class)
@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
final class Target_java_net_NetworkInterface {
    @Alias
    static int defaultIndex;
    @Alias
    String name;
    @Alias
    String displayName;
    @Alias
    int index;
    @Alias
    InetAddress[] addrs;
    @Alias
    InterfaceAddress[] bindings;
    @Alias
    NetworkInterface[] childs;
    @Alias
    NetworkInterface parent;
    @Alias
    boolean virtual;

    @Alias
    Target_java_net_NetworkInterface() {
    }

    @Substitute
    static NetworkInterface getByName0(String name) throws SocketException {
        VMError.unimplemented();
        return null;
    }

    @Substitute
    static NetworkInterface[] getAll() {
        JavaNetNetworkInterface.netif ifs = JavaNetNetworkInterface.enumInterfaces();
        if (ifs == null) {
            return null;
        }
        int ifCount = 0;
        JavaNetNetworkInterface.netif curr = ifs;
        while (curr != null) {
            ++ifCount;
            curr = curr.next;
        }
        NetworkInterface[] netIFArr = new NetworkInterface[ifCount];
        curr = ifs;
        int arr_index = 0;
        while (curr != null) {
            NetworkInterface netifObj = JavaNetNetworkInterface.createNetworkInterface(curr);
            if (netifObj == null) {
                return null;
            }
            netIFArr[arr_index++] = netifObj;
            curr = curr.next;
        }
        return netIFArr;
    }

    @Substitute
    static NetworkInterface getByIndex0(int index) {
        NetworkInterface obj = null;
        if (index <= 0) {
            return null;
        }
        JavaNetNetworkInterface.netif ifs = JavaNetNetworkInterface.enumInterfaces();
        if (ifs == null) {
            return null;
        }
        JavaNetNetworkInterface.netif curr = ifs;
        while (curr != null && index != curr.index) {
            curr = curr.next;
        }
        if (curr != null) {
            obj = JavaNetNetworkInterface.createNetworkInterface(curr);
        }
        return obj;
    }

    @Substitute
    static NetworkInterface getByInetAddress0(InetAddress iaObj) {
        NetworkInterface obj = null;
        boolean match = false;
        int family = IsDefined.socket_AF_INET6() ? (JavaNetNetUtil.getInetAddress_family(iaObj) == Target_java_net_InetAddress.IPv4 ? Socket.AF_INET() : Socket.AF_INET6()) : Socket.AF_INET();
        JavaNetNetworkInterface.netif ifs = JavaNetNetworkInterface.enumInterfaces();
        if (ifs == null) {
            return null;
        }
        JavaNetNetworkInterface.netif curr = ifs;
        while (curr != null) {
            JavaNetNetworkInterface.netaddr addrP = curr.addr;
            while (addrP != null) {
                if (family == addrP.family) {
                    int address2;
                    int address1;
                    if (family == Socket.AF_INET() && (address1 = NetinetIn.htonl(((NetinetIn.sockaddr_in)((Object)addrP.addr)).sin_addr().s_addr())) == (address2 = JavaNetNetUtilMD.getInetAddress_addr(iaObj))) {
                        match = true;
                        break;
                    }
                    if (IsDefined.socket_AF_INET6() && family == Socket.AF_INET6()) {
                        int i;
                        CCharPointer bytes = ((NetinetIn.sockaddr_in6)((Object)addrP.addr)).sin6_addr().s6_addr();
                        CCharPointer caddr = (CCharPointer)StackValue.get((int)16, CCharPointer.class);
                        JavaNetNetUtil.getInet6Address_ipAddress((Inet6Address)iaObj, caddr);
                        for (i = 0; i < 16 && caddr.read(i) == bytes.read(i); ++i) {
                        }
                        if (i >= 16) {
                            match = true;
                            break;
                        }
                    }
                }
                if (match) break;
                addrP = addrP.next;
            }
            if (match) break;
            curr = curr.next;
        }
        if (match) {
            obj = JavaNetNetworkInterface.createNetworkInterface(curr);
        }
        return obj;
    }

    @Substitute
    private static boolean isLoopback0(String name, int index) {
        int ret = JavaNetNetworkInterface.getFlags0(name);
        return (ret & NetIf.IFF_LOOPBACK()) != 0;
    }

    @Substitute
    public static byte[] getMacAddr0(byte[] addrArray, String name, int index) throws SocketException {
        int len;
        JavaNetNetworkInterface.PlatformSupport platformSupport = (JavaNetNetworkInterface.PlatformSupport)ImageSingletons.lookup(JavaNetNetworkInterface.PlatformSupport.class);
        CCharPointer caddr = (CCharPointer)StackValue.get((int)4, CCharPointer.class);
        NetinetIn.in_addr iaddr = (NetinetIn.in_addr)StackValue.get(NetinetIn.in_addr.class);
        byte[] ret = null;
        CCharPointer mac = (CCharPointer)StackValue.get((int)16, CCharPointer.class);
        if (name == null) {
            throw new NullPointerException("network interface name is NULL");
        }
        byte[] name_utf = Utf8.stringToUtf8(name, true);
        if (name_utf == null) {
            throw new OutOfMemoryError();
        }
        if (addrArray != null) {
            VmPrimsJNI.GetByteArrayRegion(addrArray, 0, 4, caddr);
            int addr = caddr.read(0) << 24 & 0xFF000000;
            addr |= caddr.read(1) << 16 & 0xFF0000;
            addr |= caddr.read(2) << 8 & 0xFF00;
            iaddr.set_s_addr(NetinetIn.htonl(addr |= caddr.read(3) & 0xFF));
            try (PinnedObject name_utf_Pin = PinnedObject.create((Object)name_utf);){
                CCharPointer name_utf_Pointer = (CCharPointer)name_utf_Pin.addressOfArrayElement(0);
                len = platformSupport.getMacAddress(name_utf_Pointer, iaddr, mac);
            }
        }
        try (PinnedObject name_utf_Pin = PinnedObject.create((Object)name_utf);){
            CCharPointer name_utf_Pointer = (CCharPointer)name_utf_Pin.addressOfArrayElement(0);
            len = platformSupport.getMacAddress(name_utf_Pointer, (NetinetIn.in_addr)WordFactory.nullPointer(), mac);
        }
        if (len > 0 && (ret = new byte[len]) != null) {
            VmPrimsJNI.SetByteArrayRegion(ret, 0, len, mac);
        }
        return ret;
    }
}

