/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.KeepOriginal;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.util.VMError;
import java.text.spi.BreakIteratorProvider;
import java.text.spi.CollatorProvider;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.spi.CalendarDataProvider;
import java.util.spi.CalendarNameProvider;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import java.util.spi.LocaleServiceProvider;
import java.util.spi.TimeZoneNameProvider;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleServiceProviderPool;

@Substitute
@TargetClass(value=LocaleServiceProviderPool.class)
final class Target_sun_util_locale_provider_LocaleServiceProviderPool {
    private static final Map<Class<? extends LocaleServiceProvider>, Object> cachedPools = new HashMap<Class<? extends LocaleServiceProvider>, Object>();
    private final LocaleServiceProvider cachedProvider;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected static Class<LocaleServiceProvider>[] spiClasses() {
        return new Class[]{BreakIteratorProvider.class, CollatorProvider.class, DateFormatProvider.class, DateFormatSymbolsProvider.class, DecimalFormatSymbolsProvider.class, NumberFormatProvider.class, CurrencyNameProvider.class, LocaleNameProvider.class, TimeZoneNameProvider.class, CalendarDataProvider.class, CalendarNameProvider.class};
    }

    Target_sun_util_locale_provider_LocaleServiceProviderPool(LocaleServiceProvider cachedProvider) {
        this.cachedProvider = cachedProvider;
    }

    @Substitute
    private static LocaleServiceProviderPool getPool(Class<? extends LocaleServiceProvider> providerClass) {
        LocaleServiceProviderPool result = (LocaleServiceProviderPool)cachedPools.get(providerClass);
        if (result == null) {
            throw VMError.unsupportedFeature("LocaleServiceProviderPool.getPool " + providerClass.getName());
        }
        return result;
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private boolean hasProviders() {
        return false;
    }

    @KeepOriginal
    private native <P extends LocaleServiceProvider, S> S getLocalizedObject(LocaleServiceProviderPool.LocalizedObjectGetter<P, S> var1, Locale var2, Object ... var3);

    @KeepOriginal
    private native <P extends LocaleServiceProvider, S> S getLocalizedObject(LocaleServiceProviderPool.LocalizedObjectGetter<P, S> var1, Locale var2, String var3, Object ... var4);

    @Substitute
    private <P extends LocaleServiceProvider, S> S getLocalizedObjectImpl(LocaleServiceProviderPool.LocalizedObjectGetter<P, S> getter, Locale locale, boolean isObjectProvider, String key, Object ... params) {
        if (locale == null) {
            throw new NullPointerException();
        }
        return getter.getObject(this.cachedProvider, locale, key, params);
    }

    @KeepOriginal
    @TargetElement(onlyWith={JDK11OrLater.class})
    public native <P extends LocaleServiceProvider, S> S getLocalizedObject(LocaleServiceProviderPool.LocalizedObjectGetter<P, S> var1, Locale var2, Boolean var3, String var4, Object ... var5);

    @KeepOriginal
    @TargetElement(onlyWith={JDK11OrLater.class})
    static native void config(Class<? extends Object> var0, String var1);

    static {
        try {
            for (Class<LocaleServiceProvider> providerClass : Target_sun_util_locale_provider_LocaleServiceProviderPool.spiClasses()) {
                LocaleProviderAdapter lda = LocaleProviderAdapter.forJRE();
                LocaleServiceProvider provider = lda.getLocaleServiceProvider(providerClass);
                assert (provider != null) : "Target_sun_util_locale_provider_LocaleServiceProviderPool: There should be no null LocaleServiceProviders.";
                cachedPools.put(providerClass, new Target_sun_util_locale_provider_LocaleServiceProviderPool(provider));
            }
        }
        catch (Throwable ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

