/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.meta;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.Cancellable;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.GraphEncoder;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.MethodSubstitutionPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.compiler.replacements.ConstantBindingParameterPlugin;
import org.graalvm.compiler.replacements.PEGraphDecoder;
import org.graalvm.compiler.replacements.ReplacementsImpl;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.util.DirectAnnotationAccess;

public class SubstrateReplacements
extends ReplacementsImpl {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private Builder builder;
    private InvocationPlugins snippetInvocationPlugins;
    private byte[] snippetEncoding;
    private Object[] snippetObjects;
    private NodeClass<?>[] snippetNodeClasses;
    private Map<ResolvedJavaMethod, Integer> snippetStartOffsets;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateReplacements(Providers providers, SnippetReflectionProvider snippetReflection, BytecodeProvider bytecodeProvider, TargetDescription target, GraphMakerFactory graphMakerFactory) {
        super((DebugHandlersFactory)new GraalDebugHandlersFactory(snippetReflection), providers, snippetReflection, bytecodeProvider, target);
        this.builder = new Builder(graphMakerFactory);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerImmutableObjects(Feature.CompilationAccess access) {
        access.registerAsImmutable((Object)this);
        access.registerAsImmutable((Object)this.snippetEncoding);
        access.registerAsImmutable((Object)this.snippetObjects);
        access.registerAsImmutable(this.snippetNodeClasses);
        access.registerAsImmutable(this.snippetStartOffsets, o -> true);
        access.registerAsImmutable((Object)this.snippetInvocationPlugins, o -> true);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Collection<StructuredGraph> getSnippetGraphs(boolean trackNodeSourcePosition, OptionValues options) {
        ArrayList<StructuredGraph> result = new ArrayList<StructuredGraph>(this.snippetStartOffsets.size());
        for (ResolvedJavaMethod method : this.snippetStartOffsets.keySet()) {
            result.add(this.getSnippet(method, null, null, trackNodeSourcePosition, null, options));
        }
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public NodeClass<?>[] getSnippetNodeClasses() {
        return this.snippetNodeClasses;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Collection<ResolvedJavaMethod> getSnippetMethods() {
        return this.snippetStartOffsets.keySet();
    }

    public void setGraphBuilderPlugins(GraphBuilderConfiguration.Plugins plugins) {
        GraphBuilderConfiguration.Plugins copy = new GraphBuilderConfiguration.Plugins(plugins);
        copy.clearInlineInvokePlugins();
        for (InlineInvokePlugin plugin : plugins.getInlineInvokePlugins()) {
            copy.appendInlineInvokePlugin((InlineInvokePlugin)(plugin == this ? new SnippetInlineInvokePlugin() : plugin));
        }
        super.setGraphBuilderPlugins(copy);
    }

    public StructuredGraph getSnippet(final ResolvedJavaMethod method, ResolvedJavaMethod recursiveEntry, Object[] args, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, OptionValues options) {
        Integer startOffset = this.snippetStartOffsets.get(method);
        if (startOffset == null) {
            throw VMError.shouldNotReachHere("snippet not found: " + method.format("%H.%n(%p)"));
        }
        ConstantBindingParameterPlugin parameterPlugin = null;
        if (args != null) {
            parameterPlugin = new ConstantBindingParameterPlugin(args, this.providers.getMetaAccess(), this.snippetReflection);
        }
        final EncodedGraph encodedGraph = new EncodedGraph(this.snippetEncoding, startOffset.intValue(), this.snippetObjects, this.snippetNodeClasses, null, null, null, false, trackNodeSourcePosition);
        try (DebugContext debug = this.openDebugContext("SVMSnippet_", method, options);){
            StructuredGraph result = new StructuredGraph.Builder(options, debug).method(method).trackNodeSourcePosition(trackNodeSourcePosition).setIsSubstitution(true).build();
            PEGraphDecoder graphDecoder = new PEGraphDecoder(ConfigurationValues.getTarget().arch, result, (CoreProviders)this.providers, null, this.snippetInvocationPlugins, new InlineInvokePlugin[0], (ParameterPlugin)parameterPlugin, null, null, null){

                protected EncodedGraph lookupEncodedGraph(ResolvedJavaMethod lookupMethod, MethodSubstitutionPlugin plugin, BytecodeProvider intrinsicBytecodeProvider, boolean isSubstitution, boolean track) {
                    if (lookupMethod.equals(method)) {
                        assert (!track || encodedGraph.trackNodeSourcePosition());
                        return encodedGraph;
                    }
                    throw VMError.shouldNotReachHere(method.format("%H.%n(%p)"));
                }
            };
            graphDecoder.decode(method, true, trackNodeSourcePosition);
            assert (result.verify());
            StructuredGraph structuredGraph = result;
            return structuredGraph;
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerSnippet(ResolvedJavaMethod method, ResolvedJavaMethod original, Object receiver, boolean trackNodeSourcePosition, OptionValues options) {
        assert (DirectAnnotationAccess.isAnnotationPresent((AnnotatedElement)method, Snippet.class)) : "Snippet must be annotated with @" + Snippet.class.getSimpleName() + " " + method;
        assert (method.hasBytecodes()) : "Snippet must not be abstract or native";
        assert (this.builder.graphs.get(method) == null) : "snippet registered twice: " + method.getName();
        try (DebugContext debug = this.openDebugContext("Snippet_", method, options);){
            Object[] args = SubstrateReplacements.prepareConstantArguments(receiver);
            StructuredGraph graph = this.makeGraph(debug, this.defaultBytecodeProvider, method, args, null, trackNodeSourcePosition, null);
            for (MethodCallTargetNode callTarget : graph.getNodes(MethodCallTargetNode.TYPE)) {
                ResolvedJavaMethod callee = callTarget.targetMethod();
                if (this.builder.delayedInvocationPluginMethods.contains(callee)) continue;
                throw VMError.shouldNotReachHere("method " + callee.format("%h.%n") + " not inlined in snippet " + method.format("%h.%n") + " (maybe not final?)");
            }
            this.builder.graphs.put(method, graph);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Set<ResolvedJavaMethod> getDelayedInvocationPluginMethods() {
        return this.builder.delayedInvocationPluginMethods;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void encodeSnippets() {
        GraphEncoder encoder = new GraphEncoder(ConfigurationValues.getTarget().arch);
        for (StructuredGraph structuredGraph : this.builder.graphs.values()) {
            encoder.prepare(structuredGraph);
        }
        encoder.finishPrepare();
        this.snippetStartOffsets = new HashMap<ResolvedJavaMethod, Integer>();
        for (Map.Entry entry : this.builder.graphs.entrySet()) {
            this.snippetStartOffsets.put((ResolvedJavaMethod)entry.getKey(), encoder.encode((StructuredGraph)entry.getValue()));
        }
        this.snippetEncoding = encoder.getEncoding();
        this.snippetObjects = encoder.getObjects();
        this.snippetNodeClasses = encoder.getNodeClasses();
        this.snippetInvocationPlugins = SubstrateReplacements.makeInvocationPlugins(this.getGraphBuilderPlugins(), this.builder, Function.identity());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static InvocationPlugins makeInvocationPlugins(GraphBuilderConfiguration.Plugins plugins, Builder builder, Function<Object, Object> objectReplacer) {
        HashMap<ResolvedJavaMethod, InvocationPlugin> result = new HashMap<ResolvedJavaMethod, InvocationPlugin>(builder.delayedInvocationPluginMethods.size());
        for (ResolvedJavaMethod method : builder.delayedInvocationPluginMethods) {
            ResolvedJavaMethod replacedMethod = (ResolvedJavaMethod)objectReplacer.apply(method);
            InvocationPlugin plugin = plugins.getInvocationPlugins().lookupInvocation(replacedMethod);
            assert (plugin != null) : "expected invocation plugin for " + replacedMethod;
            result.put(replacedMethod, plugin);
        }
        return new InvocationPlugins(result, null);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void copyFrom(SubstrateReplacements copyFrom, Function<Object, Object> objectReplacer) {
        this.snippetInvocationPlugins = SubstrateReplacements.makeInvocationPlugins(this.getGraphBuilderPlugins(), copyFrom.builder, objectReplacer);
        this.snippetEncoding = Arrays.copyOf(copyFrom.snippetEncoding, copyFrom.snippetEncoding.length);
        this.snippetNodeClasses = Arrays.copyOf(copyFrom.snippetNodeClasses, copyFrom.snippetNodeClasses.length);
        this.snippetObjects = new Object[copyFrom.snippetObjects.length];
        for (int i = 0; i < this.snippetObjects.length; ++i) {
            this.snippetObjects[i] = objectReplacer.apply(copyFrom.snippetObjects[i]);
        }
        this.snippetStartOffsets = new HashMap<ResolvedJavaMethod, Integer>(copyFrom.snippetStartOffsets.size());
        for (Map.Entry<ResolvedJavaMethod, Integer> entry : copyFrom.snippetStartOffsets.entrySet()) {
            this.snippetStartOffsets.put((ResolvedJavaMethod)objectReplacer.apply(entry.getKey()), entry.getValue());
        }
    }

    protected MethodSubstitutionPlugin getMethodSubstitution(ResolvedJavaMethod method) {
        return null;
    }

    public boolean hasSubstitution(ResolvedJavaMethod method, int callerBci) {
        return false;
    }

    public StructuredGraph getSubstitution(ResolvedJavaMethod original, int invokeBci, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosiion, OptionValues options) {
        return null;
    }

    public StructuredGraph getIntrinsicGraph(ResolvedJavaMethod method, CompilationIdentifier compilationId, DebugContext debug, Cancellable cancellable) {
        return null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected final ReplacementsImpl.GraphMaker createGraphMaker(ResolvedJavaMethod substitute, ResolvedJavaMethod substitutedMethod) {
        return this.builder.graphMakerFactory.create(this, substitute, substitutedMethod);
    }

    private static Object[] prepareConstantArguments(Object receiver) {
        if (receiver != null) {
            return new Object[]{receiver};
        }
        return null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected class SnippetInlineInvokePlugin
    implements InlineInvokePlugin {
        protected SnippetInlineInvokePlugin() {
        }

        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
            assert (b.parsingIntrinsic());
            assert (SubstrateReplacements.this.builder != null);
            Class intrinsifyingPlugin = SubstrateReplacements.this.getIntrinsifyingPlugin(method);
            if (intrinsifyingPlugin != null && GeneratedInvocationPlugin.class.isAssignableFrom(intrinsifyingPlugin)) {
                ((SubstrateReplacements)SubstrateReplacements.this).builder.delayedInvocationPluginMethods.add(method);
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_NO_EXCEPTION;
            }
            return InlineInvokePlugin.InlineInfo.createIntrinsicInlineInfo((ResolvedJavaMethod)method, (BytecodeProvider)SubstrateReplacements.this.defaultBytecodeProvider);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected static class Builder {
        protected final GraphMakerFactory graphMakerFactory;
        protected final Map<ResolvedJavaMethod, StructuredGraph> graphs;
        protected final Set<ResolvedJavaMethod> delayedInvocationPluginMethods;

        protected Builder(GraphMakerFactory graphMakerFactory) {
            this.graphMakerFactory = graphMakerFactory;
            this.graphs = new HashMap<ResolvedJavaMethod, StructuredGraph>();
            this.delayedInvocationPluginMethods = new HashSet<ResolvedJavaMethod>();
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static interface GraphMakerFactory {
        public ReplacementsImpl.GraphMaker create(ReplacementsImpl var1, ResolvedJavaMethod var2, ResolvedJavaMethod var3);
    }
}

